/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.enum.RemoveDuplicatesEnumeration;
import org.openide.util.enum.SequenceEnumeration;

public class NbBundle {
    private static final boolean USE_DEBUG_LOADER = Boolean.getBoolean("org.openide.util.NbBundle.DEBUG");
    private static String brandingToken = null;
    private static Hashtable cacheListFiles = new Hashtable();
    static /* synthetic */ Class class$org$openide$util$NbBundle;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static String getBranding() {
        return brandingToken;
    }

    public static void setBranding(String bt) throws IllegalArgumentException {
        brandingToken = bt;
    }

    public static synchronized URL getLocalizedFile(String baseName, String ext) throws MissingResourceException {
        return NbBundle.getLocalizedFile(baseName, ext, Locale.getDefault(), NbBundle.getLoader());
    }

    public static synchronized URL getLocalizedFile(String baseName, String ext, Locale locale) throws MissingResourceException {
        return NbBundle.getLocalizedFile(baseName, ext, locale, NbBundle.getLoader());
    }

    public static synchronized URL getLocalizedFile(String baseName, String ext, Locale locale, ClassLoader loader) throws MissingResourceException {
        URL lookup = null;
        LocaleIterator it = new LocaleIterator(locale);
        String cachePrefix = "[" + Integer.toString(loader.hashCode()) + "]";
        Vector<String> cacheCandidates = new Vector<String>();
        while (it.hasNext()) {
            String searchName = baseName + (String)it.next();
            String cacheName = cachePrefix + searchName.replace('.', '/');
            if (ext != null) {
                cacheName = cacheName + '.' + ext;
            }
            if ((lookup = (URL)cacheListFiles.get(cacheName)) != null) break;
            cacheCandidates.addElement(cacheName);
            String path = searchName.replace('.', '/');
            if (ext != null) {
                path = path + '.' + ext;
            }
            if ((lookup = loader.getResource(path)) != null) break;
        }
        if (lookup == null) {
            String path = baseName.replace('.', '/');
            if (ext != null) {
                path = path + '.' + ext;
            }
            throw new MissingResourceException(NbBundle.getMessage(class$org$openide$util$NbBundle == null ? (class$org$openide$util$NbBundle = NbBundle.class$("org.openide.util.NbBundle")) : class$org$openide$util$NbBundle, "MSG_FMT_CantFindResourceFor", path), baseName, "");
        }
        Enumeration enAdd = cacheCandidates.elements();
        while (enAdd.hasMoreElements()) {
            cacheListFiles.put(enAdd.nextElement(), lookup);
        }
        return lookup;
    }

    public static Object getLocalizedValue(Map table, String key, Locale locale) {
        if (table instanceof Attributes) {
            throw new IllegalArgumentException("Please do not use a java.util.jar.Attributes for NbBundle.getLocalizedValue without using the special form that works properly with Attributes.Name's as keys.");
        }
        LocaleIterator it = new LocaleIterator(locale);
        while (it.hasNext()) {
            String physicalKey = key + (String)it.next();
            Object v = table.get(physicalKey);
            if (v == null) continue;
            if (USE_DEBUG_LOADER && v instanceof String) {
                return (String)v + " (?:" + physicalKey + ")";
            }
            return v;
        }
        return null;
    }

    public static Object getLocalizedValue(Map table, String key) {
        return NbBundle.getLocalizedValue(table, key, Locale.getDefault());
    }

    public static String getLocalizedValue(Attributes attr, Attributes.Name key, Locale locale) {
        return (String)NbBundle.getLocalizedValue(NbBundle.attr2Map(attr), key.toString().toLowerCase(Locale.US), locale);
    }

    public static String getLocalizedValue(Attributes attr, Attributes.Name key) {
        return (String)NbBundle.getLocalizedValue(NbBundle.attr2Map(attr), key.toString().toLowerCase(Locale.US));
    }

    private static Map attr2Map(Attributes attr) {
        return new AttributesMap(attr);
    }

    public static final ResourceBundle getBundle(String baseName) throws MissingResourceException {
        return NbBundle.getBundle(baseName, Locale.getDefault(), NbBundle.getLoader());
    }

    public static ResourceBundle getBundle(Class clazz) {
        String name = NbBundle.findName(clazz);
        return NbBundle.getBundle(name, Locale.getDefault(), clazz.getClassLoader());
    }

    private static String findName(Class clazz) {
        String pref = clazz.getName();
        int last = pref.lastIndexOf(46);
        if (last >= 0) {
            pref = pref.substring(0, last + 1);
            return pref + "Bundle";
        }
        return "Bundle";
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale) throws MissingResourceException {
        return NbBundle.getBundle(baseName, locale, NbBundle.getLoader());
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) throws MissingResourceException {
        if (USE_DEBUG_LOADER) {
            loader = DebugLoader.get(loader);
        }
        String t = brandingToken == null ? "" : "_" + brandingToken;
        MissingResourceException e = null;
        ResourceBundle b = null;
        while (t != null) {
            try {
                String baseName2 = baseName + t;
                ResourceBundle bb = ResourceBundle.getBundle(baseName2, locale, loader);
                b = b == null ? bb : new MergedBundle(locale, b, bb);
            }
            catch (MissingResourceException mre) {
                e = mre;
            }
            int idx = t.lastIndexOf(95);
            t = idx == -1 ? null : t.substring(0, idx);
        }
        if (b == null) {
            if (e == null) {
                throw new MissingResourceException("should never happen", baseName, null);
            }
            throw e;
        }
        return b;
    }

    public static String getMessage(Class clazz, String resName) {
        return NbBundle.getBundle(clazz).getString(resName);
    }

    public static String getMessage(Class clazz, String resName, Object param1) {
        return NbBundle.getMessage(clazz, resName, new Object[]{param1});
    }

    public static String getMessage(Class clazz, String resName, Object param1, Object param2) {
        return NbBundle.getMessage(clazz, resName, new Object[]{param1, param2});
    }

    public static String getMessage(Class clazz, String resName, Object param1, Object param2, Object param3) {
        return NbBundle.getMessage(clazz, resName, new Object[]{param1, param2, param3});
    }

    public static String getMessage(Class clazz, String resName, Object[] arr) {
        return MessageFormat.format(NbBundle.getMessage(clazz, resName), arr);
    }

    private static ClassLoader getLoader() {
        ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = NbBundle.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
        return c != null ? c : ClassLoader.getSystemClassLoader();
    }

    public static Iterator getLocalizingSuffixes() {
        return new LocaleIterator(Locale.getDefault());
    }

    public static void setClassLoaderFinder(ClassLoaderFinder loaderFinder) {
        throw new Error();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class DebugLoader
    extends ClassLoader {
        private static int count = 0;
        private static final Map knownIDs = new HashMap();
        private static final Map existing = new WeakHashMap();

        private static int getID(String name) {
            Map map = knownIDs;
            synchronized (map) {
                Integer i = (Integer)knownIDs.get(name);
                if (i == null) {
                    i = new Integer(++count);
                    knownIDs.put(name, i);
                    System.err.println("NbBundle trace: #" + i + " = " + name);
                }
                int n = i;
                return n;
            }
        }

        public static ClassLoader get(ClassLoader normal) {
            Map map = existing;
            synchronized (map) {
                ClassLoader dl;
                Reference r = (Reference)existing.get(normal);
                if (r != null && (dl = (ClassLoader)r.get()) != null) {
                    ClassLoader classLoader = dl;
                    return classLoader;
                }
                dl = new DebugLoader(normal);
                existing.put(normal, new WeakReference<ClassLoader>(dl));
                ClassLoader classLoader = dl;
                return classLoader;
            }
        }

        private DebugLoader(ClassLoader cl) {
            super(cl);
        }

        public InputStream getResourceAsStream(String name) {
            InputStream base = super.getResourceAsStream(name);
            if (base == null) {
                return null;
            }
            if (name.endsWith(".properties")) {
                int id = DebugLoader.getID(name);
                boolean loc = name.indexOf("/Bundle.") != -1 || name.indexOf("/Bundle_") != -1;
                return new DebugInputStream(base, id, loc);
            }
            return base;
        }

        private static final class DebugInputStream
        extends InputStream {
            private final InputStream base;
            private final int id;
            private final boolean localizable;
            private int line = 0;
            private static final int WAITING_FOR_KEY = 0;
            private static final int IN_COMMENT = 1;
            private static final int IN_KEY = 2;
            private static final int IN_KEY_BACKSLASH = 3;
            private static final int AFTER_KEY = 4;
            private static final int WAITING_FOR_VALUE = 5;
            private static final int IN_VALUE = 6;
            private static final int IN_VALUE_BACKSLASH = 7;
            private int state = 0;
            private boolean twixtCrAndNl = false;
            private String toInsert = null;
            private boolean reverseLocalizable = false;
            private StringBuffer lastComment = null;

            public DebugInputStream(InputStream base, int id, boolean localizable) {
                this.base = base;
                this.id = id;
                this.localizable = localizable;
            }

            public int read() throws IOException {
                if (this.toInsert != null) {
                    char result = this.toInsert.charAt(0);
                    this.toInsert = this.toInsert.length() > 1 ? this.toInsert.substring(1) : null;
                    return result;
                }
                int next = this.base.read();
                if (next == 10) {
                    this.twixtCrAndNl = false;
                    ++this.line;
                } else if (next == 13) {
                    if (this.twixtCrAndNl) {
                        ++this.line;
                    } else {
                        this.twixtCrAndNl = true;
                    }
                } else {
                    this.twixtCrAndNl = false;
                }
                switch (this.state) {
                    case 0: {
                        switch (next) {
                            case 33: 
                            case 35: {
                                this.state = 1;
                                this.lastComment = new StringBuffer();
                                this.lastComment.append((char)next);
                                return next;
                            }
                            case -1: 
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                return next;
                            }
                            case 92: {
                                this.state = 3;
                                return next;
                            }
                        }
                        this.state = 2;
                        return next;
                    }
                    case 1: {
                        switch (next) {
                            case 10: 
                            case 13: {
                                String comment = this.lastComment.toString();
                                this.lastComment = null;
                                if (this.localizable && comment.equals("#NOI18N")) {
                                    this.reverseLocalizable = true;
                                } else if (this.localizable && comment.equals("#PARTNOI18N")) {
                                    System.err.println("NbBundle WARNING (" + this.id + ":" + this.line + "): #PARTNOI18N encountered, will not annotate I18N parts");
                                    this.reverseLocalizable = true;
                                } else if (!this.localizable && comment.equals("#I18N")) {
                                    this.reverseLocalizable = true;
                                } else if (!this.localizable && comment.equals("#PARTI18N")) {
                                    System.err.println("NbBundle WARNING (" + this.id + ":" + this.line + "): #PARTI18N encountered, will not annotate I18N parts");
                                    this.reverseLocalizable = false;
                                } else if (this.localizable && (comment.equals("#I18N") || comment.equals("#PARTI18N")) || !this.localizable && (comment.equals("#NOI18N") || comment.equals("#PARTNOI18N"))) {
                                    System.err.println("NbBundle WARNING (" + this.id + ":" + this.line + "): incongruous comment " + comment + " found for bundle");
                                    this.reverseLocalizable = false;
                                }
                                this.state = 0;
                                return next;
                            }
                        }
                        this.lastComment.append((char)next);
                        return next;
                    }
                    case 2: {
                        switch (next) {
                            case 92: {
                                this.state = 3;
                                return next;
                            }
                            case 9: 
                            case 32: {
                                this.state = 4;
                                return next;
                            }
                            case 58: 
                            case 61: {
                                this.state = 5;
                                return next;
                            }
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return next;
                            }
                        }
                        return next;
                    }
                    case 3: {
                        this.state = 2;
                        return next;
                    }
                    case 4: {
                        switch (next) {
                            case 58: 
                            case 61: {
                                this.state = 5;
                                return next;
                            }
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return next;
                            }
                        }
                        return next;
                    }
                    case 5: {
                        switch (next) {
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return next;
                            }
                            case 9: 
                            case 32: {
                                return next;
                            }
                            case 92: {
                                this.state = 7;
                                return next;
                            }
                        }
                        this.state = 6;
                        return next;
                    }
                    case 6: {
                        switch (next) {
                            case 92: {
                                this.state = 7;
                                return next;
                            }
                            case 10: 
                            case 13: {
                                boolean revLoc = this.reverseLocalizable;
                                this.reverseLocalizable = false;
                                this.state = 0;
                                if (this.localizable ^ revLoc) {
                                    this.toInsert = "(" + this.id + ":" + this.line + ")" + new Character((char)next);
                                    return 32;
                                }
                                return next;
                            }
                        }
                        return next;
                    }
                    case 7: {
                        this.state = 6;
                        return next;
                    }
                }
                throw new IOException("should never happen");
            }

            /*
             * WARNING - void declaration
             */
            public static void main(String[] args) throws Exception {
                int c;
                if (args.length != 1) {
                    throw new Exception();
                }
                boolean loc = Boolean.valueOf(args[0]);
                DebugInputStream dis = new DebugInputStream(System.in, 123, loc);
                while ((c = dis.read()) != -1) {
                    void var3_3;
                    System.out.write((int)var3_3);
                }
            }
        }
    }

    public static interface ClassLoaderFinder {
        public ClassLoader find();
    }

    private static class LocaleIterator
    implements Iterator {
        private boolean defaultInProgress = false;
        private boolean empty = false;
        private Locale locale;
        private Locale initLocale;
        private String current;
        private String branding;

        public LocaleIterator(Locale locale) {
            this.locale = this.initLocale = locale;
            if (locale.equals(Locale.getDefault())) {
                this.defaultInProgress = true;
            }
            this.current = '_' + locale.toString();
            this.branding = brandingToken == null ? null : "_" + brandingToken;
        }

        public Object next() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            String ret = this.branding == null ? this.current : this.branding + this.current;
            int lastUnderbar = this.current.lastIndexOf(95);
            if (lastUnderbar == 0) {
                if (this.empty) {
                    this.reset();
                } else {
                    this.current = "";
                    this.empty = true;
                }
            } else if (lastUnderbar == -1) {
                if (this.defaultInProgress) {
                    this.reset();
                } else {
                    this.locale = Locale.getDefault();
                    this.current = '_' + this.locale.toString();
                    this.defaultInProgress = true;
                }
            } else {
                this.current = this.current.substring(0, lastUnderbar);
            }
            return ret;
        }

        private void reset() {
            if (this.branding != null) {
                this.current = '_' + this.initLocale.toString();
                int idx = this.branding.lastIndexOf(95);
                this.branding = idx == 0 ? null : this.branding.substring(0, idx);
                this.empty = false;
            } else {
                this.current = null;
            }
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    private static class MergedBundle
    extends ResourceBundle {
        private Locale loc;
        private ResourceBundle sub1;
        private ResourceBundle sub2;

        public MergedBundle(Locale loc, ResourceBundle sub1, ResourceBundle sub2) {
            this.loc = loc;
            this.sub1 = sub1;
            this.sub2 = sub2;
        }

        public Locale getLocale() {
            return this.loc;
        }

        public Enumeration getKeys() {
            return new RemoveDuplicatesEnumeration(new SequenceEnumeration(this.sub1.getKeys(), this.sub2.getKeys()));
        }

        protected Object handleGetObject(String key) throws MissingResourceException {
            try {
                return this.sub1.getObject(key);
            }
            catch (MissingResourceException mre) {
                return this.sub2.getObject(key);
            }
        }
    }

    private static class AttributesMap
    extends HashMap {
        private Attributes attrs;
        static /* synthetic */ Class class$org$openide$util$NbBundle;

        public AttributesMap(Attributes attrs) {
            super(7);
            this.attrs = attrs;
        }

        public Object get(Object obj) {
            Attributes.Name an;
            try {
                an = new Attributes.Name((String)obj);
            }
            catch (IllegalArgumentException iae) {
                ErrorManager em = ErrorManager.getDefault();
                em.annotate(iae, 16, (String)obj, NbBundle.getMessage(class$org$openide$util$NbBundle == null ? (class$org$openide$util$NbBundle = AttributesMap.class$("org.openide.util.NbBundle")) : class$org$openide$util$NbBundle, "EXC_bad_attributes_name", obj, Locale.getDefault().toString()), null, null);
                em.notify(iae);
                return null;
            }
            return this.attrs.getValue(an);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

