/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public final class RequestProcessor {
    private static RequestProcessor DEFAULT = new RequestProcessor();
    private static RequestProcessor UNLIMITED = new RequestProcessor("Default RequestProcessor", 50);
    private static Timer starterThread = new Timer(true);
    String name;
    private static int counter = 0;
    boolean stopped = false;
    private Object processorLock = new Object();
    private HashSet processors = new HashSet();
    private Item pendingTail = null;
    private Item pendingHead = null;
    private int running = 0;
    private int throughput;
    static final boolean SLOW = Boolean.getBoolean("org.openide.util.RequestProcessor.Item.SLOW");

    public RequestProcessor() {
        this(null, 1);
    }

    public RequestProcessor(String name) {
        this(name, 1);
    }

    public RequestProcessor(String name, int throughput) {
        this.throughput = throughput;
        this.name = name != null ? name : "OpenIDE-request-processor-" + counter++;
    }

    public static RequestProcessor getDefault() {
        return UNLIMITED;
    }

    public Task post(Runnable run) {
        return this.post(run, 0, 1);
    }

    public Task post(Runnable run, int timeToWait) {
        return this.post(run, timeToWait, 1);
    }

    public Task post(Runnable run, int timeToWait, int priority) {
        Task task = this.create(run);
        task.setPriority(priority);
        task.schedule(timeToWait);
        return task;
    }

    public Task create(Runnable run) {
        return new Task(run);
    }

    public boolean isRequestProcessorThread() {
        Thread c = Thread.currentThread();
        Object object = this.processorLock;
        synchronized (object) {
            boolean bl = this.processors.contains(c);
            return bl;
        }
    }

    public void stop() {
        if (this == UNLIMITED || this == DEFAULT) {
            throw new IllegalArgumentException("Can't stop shared RP's");
        }
        Object object = this.processorLock;
        synchronized (object) {
            this.stopped = true;
            Iterator it = this.processors.iterator();
            while (it.hasNext()) {
                ((Processor)it.next()).interrupt();
            }
        }
    }

    public static Task postRequest(Runnable run) {
        return DEFAULT.post(run);
    }

    public static Task postRequest(Runnable run, int timeToWait) {
        return DEFAULT.post(run, timeToWait);
    }

    public static Task postRequest(Runnable run, int timeToWait, int priority) {
        return DEFAULT.post(run, timeToWait, priority);
    }

    public static Task createRequest(Runnable run) {
        return DEFAULT.create(run);
    }

    void enqueue(Item item) {
        Object object = this.processorLock;
        synchronized (object) {
            if (this.pendingTail == null) {
                this.pendingTail = this.pendingHead = item;
            } else {
                this.pendingTail.link = item;
                this.pendingTail = item;
                if (this.pendingHead == null) {
                    this.pendingHead = item;
                }
            }
            if (this.running < this.throughput) {
                ++this.running;
                Processor proc = Processor.get();
                this.processors.add(proc);
                proc.setName(this.name);
                proc.attachTo(this);
            }
        }
    }

    Item askForWork(Processor worker) {
        Object object = this.processorLock;
        synchronized (object) {
            if (this.stopped || this.pendingHead == null) {
                this.processors.remove(worker);
                Processor.put(worker);
                --this.running;
                Item item = null;
                return item;
            }
            Item ret = this.pendingHead;
            this.pendingHead = this.pendingHead.link;
            if (this.pendingHead == null) {
                this.pendingTail = null;
            }
            Item item = ret;
            return item;
        }
    }

    private static class Processor
    extends Thread {
        private static Stack pool = new Stack();
        private RequestProcessor source;
        private static final int INACTIVE_TIMEOUT = 60000;
        private boolean idle = true;
        private Object lock = new Object();
        static /* synthetic */ Class class$org$openide$util$RequestProcessor;

        static Processor get() {
            Stack stack = pool;
            synchronized (stack) {
                if (pool.isEmpty()) {
                    Processor proc = new Processor();
                    proc.idle = false;
                    proc.start();
                    Processor processor = proc;
                    return processor;
                }
                Processor proc = (Processor)pool.pop();
                proc.idle = false;
                Processor processor = proc;
                return processor;
            }
        }

        static void put(Processor proc) {
            Stack stack = pool;
            synchronized (stack) {
                proc.setName("Inactive RequestProcessor thread");
                proc.idle = true;
                pool.push(proc);
            }
        }

        public Processor() {
            super(Processor.getTopLevelThreadGroup(), "Inactive RequestProcessor thread");
            this.setDaemon(true);
        }

        void setPrio(int priority) {
            if (priority != this.getPriority()) {
                this.setPriority(priority);
            }
        }

        public void attachTo(RequestProcessor src) {
            Object object = this.lock;
            synchronized (object) {
                this.source = src;
                this.lock.notify();
            }
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            while (true) {
                current = null;
                var2_2 = this.lock;
                synchronized (var2_2) {
                    try {
                        if (this.source == null) {
                            this.lock.wait(60000L);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    current = this.source;
                    this.source = null;
                    if (current == null) {
                        e = Processor.pool;
                        synchronized (e) {
                            if (this.idle) {
                                Processor.pool.remove(this);
                                break;
                            }
                            continue;
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 11] lbl31 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (true) ** GOTO lbl42
                }
                do {
                    if ((todo = e.takeOverTask()) == null) continue;
                    this.setPrio(todo.getPriority());
                    try {
                        todo.run();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable ex) {
                        err = ErrorManager.getDefault();
                        err.annotate(ex, 4096, null, NbBundle.getMessage(Processor.class$org$openide$util$RequestProcessor == null ? Processor.class$("org.openide.util.RequestProcessor") : Processor.class$org$openide$util$RequestProcessor, "EXC_IN_REQUEST_PROCESSOR"), (Throwable)(RequestProcessor.SLOW != false ? e : null), null);
                        err.notify(ex);
                    }
lbl42:
                    // 4 sources

                } while ((item = current.askForWork(this)) != null);
            }
        }

        static ThreadGroup getTopLevelThreadGroup() {
            PrivilegedAction run = new PrivilegedAction(){

                public Object run() {
                    ThreadGroup current = Thread.currentThread().getThreadGroup();
                    while (current.getParent() != null) {
                        current = current.getParent();
                    }
                    return current;
                }
            };
            return (ThreadGroup)AccessController.doPrivileged(run);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class Item
    extends Exception {
        RequestProcessor owner;
        Item link;
        Task action;

        Item(Task task, RequestProcessor rp) {
            super("Posted StackTrace");
            this.action = task;
            this.owner = rp;
        }

        Task takeOverTask() {
            Object object = this.owner.processorLock;
            synchronized (object) {
                Task current = this.action;
                if (this.action != null) {
                    this.action.item = null;
                }
                this.action = null;
                Task task = current;
                return task;
            }
        }

        boolean clear() {
            return this.takeOverTask() != null;
        }

        public Throwable fillInStackTrace() {
            return SLOW ? super.fillInStackTrace() : this;
        }
    }

    public final class Task
    extends org.openide.util.Task {
        private Item item;
        private int priority = 1;
        private long time = 0L;

        Task(Runnable run) {
            super(run);
        }

        public int getDelay() {
            long delay = this.time - System.currentTimeMillis();
            if (delay < 0L) {
                return 0;
            }
            if (delay > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)delay;
        }

        public void schedule(int delay) {
            Item localItem;
            if (RequestProcessor.this.stopped) {
                throw new IllegalStateException("RequestProcessor already stopped!");
            }
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                this.notifyRunning();
                if (this.item != null) {
                    this.item.clear();
                }
                localItem = this.item = new Item(this, RequestProcessor.this);
            }
            if (delay == 0) {
                RequestProcessor.this.enqueue(localItem);
            } else {
                starterThread.schedule(new TimerTask(this, localItem){
                    private final /* synthetic */ Item val$localItem;
                    private final /* synthetic */ Task this$1;
                    {
                        this.this$1 = this$1;
                        this.val$localItem = val$localItem;
                    }

                    public void run() {
                        Task.access$100(this.this$1).enqueue(this.val$localItem);
                    }
                }, delay);
            }
        }

        public boolean cancel() {
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                boolean success;
                boolean bl = success = this.item == null ? false : this.item.clear();
                if (success) {
                    this.notifyFinished();
                }
                boolean bl2 = success;
                return bl2;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            if (priority < 1) {
                priority = 1;
            }
            if (priority > 10) {
                priority = 10;
            }
            this.priority = priority;
        }

        public void waitFinished() {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean toRun;
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    toRun = this.item == null ? false : this.item.clear();
                }
                if (toRun) {
                    this.run();
                }
            } else {
                super.waitFinished();
            }
        }

        public String toString() {
            return "RequestProcessor.Task [" + RequestProcessor.this.name + ", " + this.priority + "] for " + super.toString();
        }

        static /* synthetic */ RequestProcessor access$100(Task x0) {
            return x0.RequestProcessor.this;
        }
    }
}

