/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.SharedClassObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

public abstract class SharedClassObject
implements Externalizable {
    private static final long serialVersionUID = 4527891234589143259L;
    private static final String ATTR_GLOBAL = "global";
    static final String GLOBAL_METHOD_NAME = "isGlobal";
    private byte[] defaultInstance = null;
    private static final Object PROP_SUPPORT = new Object();
    private static final Map values = new WeakHashMap(4);
    private final DataEntry dataEntry;
    private Object lock;
    private final SharedClassObject first;
    private Throwable firstTrace = null;
    private static final Map instancesBeingCreated = new HashMap(3);
    private static final Set alreadyWarnedAboutDupes = new HashSet();
    private boolean systemOption = false;
    private boolean waitingOnSystemOption = false;
    private IllegalStateException prematureSystemOptionMutation = null;
    private boolean inReadExternal = false;
    private boolean addNotifySuper;
    private boolean removeNotifySuper;
    private boolean initializeSuper;

    protected final void finalize() throws Throwable {
        this.referenceLost();
    }

    protected boolean clearSharedData() {
        return true;
    }

    public final boolean equals(Object obj) {
        return obj instanceof SharedClassObject && this.getClass().equals(obj.getClass());
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    protected final Object getLock() {
        if (this.lock == null) {
            this.lock = this.getClass().getName().intern();
        }
        return this.lock;
    }

    protected SharedClassObject() {
        Object object = this.getLock();
        synchronized (object) {
            DataEntry de = (DataEntry)values.get(this.getClass());
            if (de == null) {
                de = new DataEntry();
                values.put(this.getClass(), de);
            }
            this.dataEntry = de;
            de.increase();
            this.first = de.first(this);
        }
        if (this.first != null) {
            if (this.first == this) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    Throwable t = new Throwable("First instance created here");
                    t.fillInStackTrace();
                    this.first.firstTrace = t;
                }
            } else {
                boolean creating;
                String clazz = this.getClass().getName();
                Map map = instancesBeingCreated;
                synchronized (map) {
                    creating = instancesBeingCreated.containsKey(clazz);
                }
                if (!creating && !alreadyWarnedAboutDupes.contains(clazz)) {
                    alreadyWarnedAboutDupes.add(clazz);
                    IllegalStateException e = new IllegalStateException("Warning: multiple instances of shared class " + clazz + " created.");
                    ErrorManager err = ErrorManager.getDefault();
                    if (this.first.firstTrace != null) {
                        err.annotate((Throwable)e, this.first.firstTrace);
                    } else {
                        err.annotate((Throwable)e, "(Run with -J-Dnetbeans.debug.exceptions=true for more details.)");
                    }
                    err.notify(1, e);
                }
            }
        }
    }

    private void referenceLost() {
        Object object = this.getLock();
        synchronized (object) {
            if ((this.dataEntry == null || this.dataEntry.decrease() == 0) && this.clearSharedData()) {
                values.remove(this.getClass());
            }
        }
    }

    protected final Object putProperty(Object key, Object value) {
        Object object = this.getLock();
        synchronized (object) {
            if (key.equals("netbeans.systemoption.hack")) {
                this.systemOption = true;
                Object var4_4 = null;
                return var4_4;
            }
            if (this.waitingOnSystemOption && key != PROP_SUPPORT && this.prematureSystemOptionMutation == null && !this.dataEntry.isInInitialize() && !this.inReadExternal) {
                this.prematureSystemOptionMutation = new IllegalStateException("...setting property here...");
            }
            Object object2 = this.dataEntry.getMap(this).put(key, value);
            return object2;
        }
    }

    protected final Object putProperty(String key, Object value, boolean notify) {
        Object previous = this.putProperty(key, value);
        if (notify) {
            this.firePropertyChange(key, previous, value);
        }
        return previous;
    }

    protected final Object getProperty(Object key) {
        Object object = this.getLock();
        synchronized (object) {
            Object object2 = this.dataEntry.get(this, key);
            return object2;
        }
    }

    protected void initialize() {
        this.initializeSuper = true;
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        boolean noListener;
        Object object = this.getLock();
        synchronized (object) {
            PropertyChangeSupport supp = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
            if (supp == null) {
                supp = new PropertyChangeSupport(this);
                this.putProperty(PROP_SUPPORT, supp);
            }
            noListener = !supp.hasListeners(null);
            supp.addPropertyChangeListener(l);
        }
        if (noListener) {
            this.addNotifySuper = false;
            this.addNotify();
            if (!this.addNotifySuper) {
                String msg = "You must call super.addNotify() from " + this.getClass().getName() + ".addNotify()";
                ErrorManager.getDefault().log(16, msg);
            }
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        boolean callRemoved;
        Object object = this.getLock();
        synchronized (object) {
            PropertyChangeSupport supp = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
            if (supp == null) {
                return;
            }
            boolean hasListener = supp.hasListeners(null);
            supp.removePropertyChangeListener(l);
            callRemoved = hasListener && !supp.hasListeners(null);
        }
        if (callRemoved) {
            this.removeNotifySuper = false;
            this.removeNotify();
            if (!this.removeNotifySuper) {
                String msg = "You must call super.removeNotify() from " + this.getClass().getName() + ".removeNotify()";
                ErrorManager.getDefault().log(16, msg);
            }
        }
    }

    protected void addNotify() {
        this.addNotifySuper = true;
    }

    protected void removeNotify() {
        this.removeNotifySuper = true;
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        PropertyChangeSupport supp = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
        if (supp != null) {
            supp.firePropertyChange(name, oldValue, newValue);
        }
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
    }

    protected Object writeReplace() {
        return new WriteReplace(this);
    }

    public static SharedClassObject findObject(Class clazz) {
        return SharedClassObject.findObject(clazz, false);
    }

    public static SharedClassObject findObject(Class clazz, boolean create) {
        String string = clazz.getName().intern();
        synchronized (string) {
            DataEntry de = (DataEntry)values.get(clazz);
            SharedClassObject obj = de == null ? null : de.get();
            boolean created = false;
            if (obj == null && create) {
                SetAccessibleAction action = new SetAccessibleAction(clazz);
                try {
                    obj = (SharedClassObject)AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    IllegalArgumentException newEx = new IllegalArgumentException(ex.toString());
                    ErrorManager.getDefault().copyAnnotation(newEx, ex);
                    throw newEx;
                }
                created = true;
            }
            if ((de = (DataEntry)values.get(clazz)) != null) {
                SharedClassObject obj2 = de.get();
                if (obj != null && obj != obj2) {
                    if (obj2 == null && create) {
                        throw new IllegalStateException("Inconsistent state: " + clazz);
                    }
                    SharedClassObject e = obj2;
                    return e;
                }
            }
            if (created) {
                Lookup.Result r;
                obj.reset();
                if (obj != null && obj.systemOption && (r = Lookup.getDefault().lookup(new Lookup.Template(clazz))).allInstances().isEmpty()) {
                    obj.waitingOnSystemOption = true;
                    SharedClassObject _obj = obj;
                    IllegalStateException start = new IllegalStateException("Making a SystemOption here that is not in lookup...");
                    class SOLoader
                    implements LookupListener {
                        private final /* synthetic */ Lookup.Result val$r;
                        private final /* synthetic */ SharedClassObject val$_obj;
                        private final /* synthetic */ IllegalStateException val$start;

                        SOLoader(Lookup.Result val$r, SharedClassObject val$_obj, IllegalStateException val$start) {
                            this.val$r = val$r;
                            this.val$_obj = val$_obj;
                            this.val$start = val$start;
                        }

                        public void resultChanged(LookupEvent ev) {
                            if (!this.val$r.allInstances().isEmpty()) {
                                this.val$r.removeLookupListener(this);
                                Object object = this.val$_obj.getLock();
                                synchronized (object) {
                                    SharedClassObject.access$002(this.val$_obj, false);
                                    if (SharedClassObject.access$100(this.val$_obj) != null) {
                                        SharedClassObject.access$200(this.val$start);
                                        SharedClassObject.access$200(SharedClassObject.access$100(this.val$_obj));
                                        SharedClassObject.access$200(new IllegalStateException("...and maybe getting clobbered here, see #17711."));
                                        SharedClassObject.access$102(this.val$_obj, null);
                                    }
                                }
                            }
                        }
                    }
                    r.addLookupListener(new SOLoader(r, _obj, start));
                }
            }
            if (obj == null && create) {
                throw new IllegalStateException("Inconsistent state: " + clazz);
            }
            SharedClassObject sharedClassObject = obj;
            return sharedClassObject;
        }
    }

    private static void warn(Throwable t) {
        ErrorManager.getDefault().notify(1, t);
    }

    static Object createInstancePrivileged(Class clazz) throws Exception {
        Map map;
        Object t;
        Constructor c = clazz.getDeclaredConstructor(new Class[0]);
        ((AccessibleObject)c).setAccessible(true);
        String name = clazz.getName();
        Map map2 = instancesBeingCreated;
        synchronized (map2) {
            Integer i = (Integer)instancesBeingCreated.get(name);
            instancesBeingCreated.put(name, i == null ? new Integer(1) : new Integer(i + 1));
        }
        try {
            t = c.newInstance(new Object[0]);
            Object var7_6 = null;
            map = instancesBeingCreated;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Map map3 = instancesBeingCreated;
            synchronized (map3) {
                Integer i = (Integer)instancesBeingCreated.get(name);
                if (i == 1) {
                    instancesBeingCreated.remove(name);
                } else {
                    instancesBeingCreated.put(name, new Integer(i - 1));
                }
            }
            ((AccessibleObject)c).setAccessible(false);
            throw throwable;
        }
        synchronized (map) {
            Integer i = (Integer)instancesBeingCreated.get(name);
            if (i == 1) {
                instancesBeingCreated.remove(name);
            } else {
                instancesBeingCreated.put(name, new Integer(i - 1));
            }
        }
        ((AccessibleObject)c).setAccessible(false);
        return t;
    }

    private void reset() {
        if (!this.systemOption || !this.isProjectOption()) {
            return;
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.defaultInstance == null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                    NbObjectOutputStream oo = new NbObjectOutputStream(baos);
                    oo.writeObject(this);
                    this.defaultInstance = baos.toByteArray();
                }
                catch (IOException e) {
                    this.defaultInstance = null;
                }
                return;
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.defaultInstance);
                NbObjectInputStream oi = new NbObjectInputStream(bais);
                oi.readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isProjectOption() {
        try {
            Class<?> clazz = this.getClass();
            if (this.hasGlobalAtrributeInBeanInfo(clazz)) {
                return !this.isGlobalFromBeanInfo(clazz);
            }
            Method m = clazz.getMethod(GLOBAL_METHOD_NAME, new Class[0]);
            ((AccessibleObject)m).setAccessible(true);
            Boolean b = (Boolean)m.invoke((Object)this, new Object[0]);
            return b == false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean hasGlobalAtrributeInBeanInfo(Class clazz) {
        try {
            BeanInfo b = Introspector.getBeanInfo(clazz);
            if (b != null) {
                Object v;
                BeanDescriptor bd = b.getBeanDescriptor();
                if (bd != null && (v = bd.getValue(ATTR_GLOBAL)) != null) {
                    return true;
                }
                BeanInfo[] infos = b.getAdditionalBeanInfo();
                if (infos != null) {
                    int i = 0;
                    while (i < infos.length) {
                        Object v2;
                        BeanDescriptor bd1 = infos[i].getBeanDescriptor();
                        if (bd1 != null && (v2 = bd1.getValue(ATTR_GLOBAL)) != null) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return false;
    }

    private boolean isGlobalFromBeanInfo(Class clazz) {
        try {
            BeanInfo b = Introspector.getBeanInfo(clazz);
            if (b != null) {
                Object v;
                BeanDescriptor bd = b.getBeanDescriptor();
                if (bd != null && (v = bd.getValue(ATTR_GLOBAL)) instanceof Boolean) {
                    return (Boolean)v;
                }
                BeanInfo[] infos = b.getAdditionalBeanInfo();
                if (infos != null) {
                    int i = 0;
                    while (i < infos.length) {
                        Object v2;
                        BeanDescriptor bd1 = infos[i].getBeanDescriptor();
                        if (bd1 != null && (v2 = bd1.getValue(ATTR_GLOBAL)) instanceof Boolean) {
                            return (Boolean)v2;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IntrospectionException ie) {
            ErrorManager.getDefault().notify(4096, ie);
        }
        throw new IllegalArgumentException("Trying to get a value from beaninfo but the value is not there");
    }

    static /* synthetic */ boolean access$002(SharedClassObject x0, boolean x1) {
        x0.waitingOnSystemOption = x1;
        return x0.waitingOnSystemOption;
    }

    static /* synthetic */ IllegalStateException access$100(SharedClassObject x0) {
        return x0.prematureSystemOptionMutation;
    }

    static /* synthetic */ void access$200(Throwable x0) {
        SharedClassObject.warn(x0);
    }

    static /* synthetic */ IllegalStateException access$102(SharedClassObject x0, IllegalStateException x1) {
        x0.prematureSystemOptionMutation = x1;
        return x0.prematureSystemOptionMutation;
    }

    static final class SetAccessibleAction
    implements PrivilegedExceptionAction {
        Class klass;

        SetAccessibleAction(Class klass) {
            this.klass = klass;
        }

        public Object run() throws Exception {
            return SharedClassObject.createInstancePrivileged(this.klass);
        }
    }

    static final class DataEntry {
        private HashMap map;
        private int count = 0;
        private WeakReference ref = new WeakReference<Object>(null);
        private boolean initialized = false;
        private boolean initializeInProgress = false;
        private Throwable invalid = null;

        DataEntry() {
        }

        public String toString() {
            return "SCO.DataEntry[ref=" + this.ref.get() + ",count=" + this.count + ",initialized=" + this.initialized + ",invalid=" + this.invalid + ",map=" + this.map + "]";
        }

        boolean isInInitialize() {
            return this.initializeInProgress;
        }

        Map getMap(SharedClassObject obj) {
            this.ensureValid(obj);
            if (this.map == null) {
                this.map = new HashMap();
            }
            if (!this.initialized) {
                this.initialized = true;
                this.tryToInitialize(obj);
            }
            return this.map;
        }

        Object get(SharedClassObject obj, Object key) {
            Object ret;
            this.ensureValid(obj);
            if (this.map == null) {
                this.map = new HashMap();
                ret = null;
            } else {
                ret = this.map.get(key);
            }
            if (ret == null && !this.initialized) {
                if (key == PROP_SUPPORT) {
                    return null;
                }
                this.initialized = true;
                this.tryToInitialize(obj);
                ret = this.map.get(key);
            }
            return ret;
        }

        Map getMap() {
            this.ensureValid(this.get());
            if (this.map == null) {
                this.map = new HashMap();
            }
            return this.map;
        }

        private void ensureValid(SharedClassObject obj) throws IllegalStateException {
            if (this.invalid != null) {
                String msg = obj != null ? obj.toString() : "<unknown object>";
                IllegalStateException ise = new IllegalStateException(msg);
                ErrorManager.getDefault().annotate((Throwable)ise, this.invalid);
                throw ise;
            }
        }

        private void tryToInitialize(SharedClassObject obj) throws IllegalStateException {
            this.initializeInProgress = true;
            obj.initializeSuper = false;
            try {
                try {
                    obj.initialize();
                }
                catch (Exception e) {
                    this.invalid = e;
                    IllegalStateException ise = new IllegalStateException(this.invalid.toString() + " from " + obj);
                    ErrorManager.getDefault().annotate((Throwable)ise, this.invalid);
                    throw ise;
                }
                catch (LinkageError e) {
                    this.invalid = e;
                    IllegalStateException ise = new IllegalStateException(this.invalid.toString() + " from " + obj);
                    ErrorManager.getDefault().annotate((Throwable)ise, this.invalid);
                    throw ise;
                }
                Object var6_2 = null;
                this.initializeInProgress = false;
            }
            catch (Throwable throwable) {
                Object var6_3 = null;
                this.initializeInProgress = false;
                throw throwable;
            }
            if (!obj.initializeSuper) {
                String msg = "You must call super.initialize() from " + obj.getClass().getName() + ".initialize()";
                ErrorManager.getDefault().log(16, msg);
            }
        }

        int increase() {
            return ++this.count;
        }

        int decrease() {
            return --this.count;
        }

        SharedClassObject first(SharedClassObject obj) {
            SharedClassObject s = (SharedClassObject)this.ref.get();
            if (s == null) {
                this.ref = new WeakReference<SharedClassObject>(obj);
                return obj;
            }
            return s;
        }

        public SharedClassObject get() {
            return (SharedClassObject)this.ref.get();
        }

        public void reset(SharedClassObject obj) {
            SharedClassObject s = this.get();
            if (s != null && s != obj) {
                return;
            }
            this.invalid = null;
            this.getMap().clear();
            this.initialized = true;
            this.tryToInitialize(obj);
        }
    }

    static final class WriteReplace
    implements Serializable {
        static final long serialVersionUID = 1327893248974327640L;
        private Class clazz;
        private String name;
        private transient SharedClassObject object;
        static /* synthetic */ Class class$java$io$ObjectStreamException;
        static /* synthetic */ Class class$java$lang$Object;

        public WriteReplace(SharedClassObject object) {
            this.object = object;
            this.clazz = object.getClass();
            this.name = this.clazz.getName();
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
            this.object.writeExternal(oos);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (this.clazz == null) {
                if (this.name != null) {
                    throw new ClassNotFoundException(this.name);
                }
                throw new ClassNotFoundException();
            }
            this.object = SharedClassObject.findObject(this.clazz, true);
            this.object.inReadExternal = true;
            try {
                this.object.readExternal(ois);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.object.inReadExternal = false;
                throw throwable;
            }
            this.object.inReadExternal = false;
        }

        private Object readResolve() throws ObjectStreamException {
            SharedClassObject resolved = this.object;
            Method resolveMethod = WriteReplace.findReadResolveMethod(this.object.getClass());
            if (resolveMethod != null) {
                try {
                    try {
                        ((AccessibleObject)resolveMethod).setAccessible(true);
                        resolved = (SharedClassObject)resolveMethod.invoke((Object)this.object, null);
                    }
                    catch (Exception ex) {
                        String banner = "Skipping " + this.object.getClass() + " resolution:";
                        ErrorManager err = ErrorManager.getDefault();
                        err.log(1, banner);
                        err.notify(1, ex);
                        Object var7_4 = null;
                        ((AccessibleObject)resolveMethod).setAccessible(false);
                    }
                    Object var7_3 = null;
                    ((AccessibleObject)resolveMethod).setAccessible(false);
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    ((AccessibleObject)resolveMethod).setAccessible(false);
                    throw throwable;
                }
            }
            return resolved;
        }

        private static Method findReadResolveMethod(Class clazz) {
            Method result = null;
            Class i = clazz;
            while (i != null) {
                try {
                    result = WriteReplace.accept(i.getDeclaredMethod("readResolve", new Class[0]));
                    if (result != null) {
                        break;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                i = i.getSuperclass();
            }
            return result;
        }

        private static Method accept(Method candidate) {
            Class<?>[] result;
            if (candidate != null && (result = candidate.getExceptionTypes()).length == 1 && (class$java$io$ObjectStreamException == null ? (class$java$io$ObjectStreamException = WriteReplace.class$("java.io.ObjectStreamException")) : class$java$io$ObjectStreamException).equals(result[0]) && (class$java$lang$Object == null ? (class$java$lang$Object = WriteReplace.class$("java.lang.Object")) : class$java$lang$Object).equals(candidate.getReturnType())) {
                return candidate;
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

