/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import org.openide.awt.Actions;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public abstract class BooleanStateAction
extends SystemAction
implements Presenter.Menu,
Presenter.Popup,
Presenter.Toolbar {
    static final long serialVersionUID = 6394800019181426199L;
    public static final String PROP_BOOLEAN_STATE = "booleanState";

    public JMenuItem getMenuPresenter() {
        return new Actions.CheckboxMenuItem(this, true);
    }

    public JMenuItem getPopupPresenter() {
        return new Actions.CheckboxMenuItem(this, false);
    }

    public Component getToolbarPresenter() {
        return new Actions.ToolbarToggleButton(this);
    }

    public boolean getBooleanState() {
        return this.getProperty(PROP_BOOLEAN_STATE).equals(Boolean.TRUE);
    }

    public void setBooleanState(boolean value) {
        Boolean newValue = new Boolean(value);
        Boolean oldValue = (Boolean)this.putProperty(PROP_BOOLEAN_STATE, newValue);
        this.firePropertyChange(PROP_BOOLEAN_STATE, oldValue, newValue);
    }

    protected void initialize() {
        this.putProperty(PROP_BOOLEAN_STATE, Boolean.TRUE);
        super.initialize();
    }

    public void actionPerformed(ActionEvent ev) {
        this.setBooleanState(!this.getBooleanState());
    }
}

