/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.openide.explorer.ExplorerManager;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;

public abstract class CallbackSystemAction
extends CallableSystemAction {
    private static final String PROP_ACTION_PERFORMER = "actionPerformer";
    private static final WeakSet notSurviving = new WeakSet(37);
    private static TopComponent.Registry registry;
    private static ExplorerManager explorerManager;
    private static FocusTracker ft;
    static final long serialVersionUID = -6305817805474624653L;

    protected void initialize() {
        super.initialize();
        this.setEnabled(false);
        this.setSurviveFocusChange(false);
    }

    public ActionPerformer getActionPerformer() {
        return (ActionPerformer)this.getProperty(PROP_ACTION_PERFORMER);
    }

    public void setActionPerformer(ActionPerformer performer) {
        ActionPerformer oldValue = (ActionPerformer)this.putProperty(PROP_ACTION_PERFORMER, performer);
        this.setEnabled(performer != null);
    }

    public void performAction() {
        ActionPerformer ap = this.getActionPerformer();
        if (ap != null) {
            ap.performAction(this);
        }
    }

    public boolean getSurviveFocusChange() {
        this.getProperty(null);
        return !notSurviving.contains(this.getClass());
    }

    public void setSurviveFocusChange(boolean b) {
        WeakSet weakSet = notSurviving;
        synchronized (weakSet) {
            if (b) {
                notSurviving.remove(this.getClass());
            } else {
                notSurviving.add(this.getClass());
            }
        }
    }

    static TopComponent.Registry getRegistry() {
        if (registry != null) {
            return registry;
        }
        try {
            Class<?> c = Class.forName("org.openide.windows.TopComponent$Registry");
            registry = (TopComponent.Registry)Lookup.getDefault().lookup(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (registry == null && ft == null) {
            CallbackSystemAction.startTrackingFocus();
        }
        if (registry != null) {
            CallbackSystemAction.stopTrackingFocus();
            registry.addPropertyChangeListener(new FocusTracker());
        }
        return registry;
    }

    static ExplorerManager getExplorerManager() {
        return explorerManager;
    }

    static void setExplorerManager(ExplorerManager e) {
        explorerManager = e;
    }

    private static void startTrackingFocus() {
        ft = new FocusTracker();
        Toolkit.getDefaultToolkit().addAWTEventListener(ft, 4L);
    }

    private static void stopTrackingFocus() {
        if (ft != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(ft);
            ft = null;
        }
    }

    private static void clearActionPerformers() {
        Iterator it;
        ArrayList<SharedClassObject> actions;
        WeakSet weakSet = notSurviving;
        synchronized (weakSet) {
            actions = new ArrayList<SharedClassObject>(notSurviving.size());
            it = notSurviving.iterator();
            while (it.hasNext()) {
                Class c = (Class)it.next();
                SharedClassObject a = SharedClassObject.findObject(c, false);
                if (a == null) continue;
                actions.add(a);
            }
        }
        it = ((AbstractList)actions).iterator();
        while (it.hasNext()) {
            CallbackSystemAction a = (CallbackSystemAction)it.next();
            a.setActionPerformer(null);
        }
    }

    static {
        CallbackSystemAction.getRegistry();
    }

    private static class FocusTracker
    implements AWTEventListener,
    PropertyChangeListener {
        FocusTracker() {
        }

        public void eventDispatched(AWTEvent event) {
            FocusEvent fe;
            if (event instanceof FocusEvent && ((fe = (FocusEvent)event).getID() & 0x3EC) == 0) {
                return;
            }
            Object source = event.getSource();
            if (source instanceof Component) {
                Component c = (Component)source;
                while (c != null && !(c instanceof ExplorerManager.Provider)) {
                    c = c.getParent();
                }
                if (c instanceof ExplorerManager.Provider) {
                    CallbackSystemAction.setExplorerManager(((ExplorerManager.Provider)((Object)c)).getExplorerManager());
                }
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("activated".equals(ev.getPropertyName())) {
                CallbackSystemAction.clearActionPerformers();
            }
        }
    }
}

