/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.EventListenerList;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.TransferListener;

public class ExTransferable
implements Transferable {
    public static final Transferable EMPTY = new Empty();
    public static final DataFlavor multiFlavor = new DataFlavor("application/x-java-openide-multinode;class=org.openide.util.datatransfer.MultiTransferObject", NbBundle.getBundle(class$org$openide$util$datatransfer$ExTransferable == null ? (class$org$openide$util$datatransfer$ExTransferable = ExTransferable.class$("org.openide.util.datatransfer.ExTransferable")) : class$org$openide$util$datatransfer$ExTransferable).getString("transferFlavorsMultiFlavorName"));
    private HashMap map = new HashMap();
    private EventListenerList listeners;
    static /* synthetic */ Class class$org$openide$util$datatransfer$ExTransferable;
    static /* synthetic */ Class class$org$openide$util$datatransfer$TransferListener;

    private ExTransferable(final Transferable t) {
        final DataFlavor[] df = t.getTransferDataFlavors();
        if (df != null) {
            int i = 0;
            while (i < df.length) {
                try {
                    final int fi = i;
                    this.map.put(df[i], new Single(df[i]){

                        public Object getData() throws IOException, UnsupportedFlavorException {
                            return t.getTransferData(df[fi]);
                        }
                    });
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public void put(Single single) {
        this.map.put(single.flavor, single);
    }

    public void remove(DataFlavor flavor) {
        this.map.remove(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.map.keySet().toArray(new DataFlavor[0]);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.map.containsKey(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Single o = (Single)this.map.get(flavor);
        if (o == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        return o.getTransferData(flavor);
    }

    public static ExTransferable create(Transferable t) {
        if (t instanceof ExTransferable) {
            return (ExTransferable)t;
        }
        return new ExTransferable(t);
    }

    public final synchronized void addTransferListener(TransferListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(class$org$openide$util$datatransfer$TransferListener == null ? (class$org$openide$util$datatransfer$TransferListener = ExTransferable.class$("org.openide.util.datatransfer.TransferListener")) : class$org$openide$util$datatransfer$TransferListener, l);
    }

    public final synchronized void removeTransferListener(TransferListener l) {
        if (this.listeners != null) {
            this.listeners.remove(class$org$openide$util$datatransfer$TransferListener == null ? (class$org$openide$util$datatransfer$TransferListener = ExTransferable.class$("org.openide.util.datatransfer.TransferListener")) : class$org$openide$util$datatransfer$TransferListener, l);
        }
    }

    final void fireAccepted(int action) {
        if (this.listeners == null) {
            return;
        }
        Object[] arr = this.listeners.getListenerList();
        int i = arr.length - 1;
        while (i >= 0) {
            ((TransferListener)arr[i]).accepted(action);
            i -= 2;
        }
    }

    final void fireRejected() {
        if (this.listeners == null) {
            return;
        }
        Object[] arr = this.listeners.getListenerList();
        int i = arr.length - 1;
        while (i >= 0) {
            ((TransferListener)arr[i]).rejected();
            i -= 2;
        }
    }

    final void fireOwnershipLost() {
        if (this.listeners == null) {
            return;
        }
        Object[] arr = this.listeners.getListenerList();
        int i = arr.length - 1;
        while (i >= 0) {
            ((TransferListener)arr[i]).ownershipLost();
            i -= 2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Empty
    implements Transferable {
        Empty() {
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[0];
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return false;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            throw new UnsupportedFlavorException(flavor);
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    public static class Multi
    implements Transferable {
        private MultiTransferObject transferObject;
        private static final DataFlavor[] flavorList = new DataFlavor[]{multiFlavor};

        public Multi(Transferable[] trans) {
            this.transferObject = new TransferObjectImpl(trans);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return flavorList;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(multiFlavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.transferObject;
        }

        static class TransferObjectImpl
        implements MultiTransferObject {
            private Transferable[] trans;

            public TransferObjectImpl(Transferable[] trans) {
                this.trans = trans;
            }

            public int getCount() {
                return this.trans.length;
            }

            public Transferable getTransferableAt(int index) {
                return this.trans[index];
            }

            public boolean isDataFlavorSupported(int index, DataFlavor flavor) {
                try {
                    return this.trans[index].isDataFlavorSupported(flavor);
                }
                catch (Exception e) {
                    return false;
                }
            }

            public boolean areDataFlavorsSupported(DataFlavor[] array) {
                HashSet<DataFlavor> flav = new HashSet<DataFlavor>();
                int i = 0;
                while (i < array.length) {
                    flav.add(array[i]);
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.trans.length) {
                    block5: {
                        DataFlavor[] flavors = this.trans[i2].getTransferDataFlavors();
                        if (flavors == null) {
                            return false;
                        }
                        int j = 0;
                        while (j < flavors.length) {
                            if (!flav.contains(flavors[j])) {
                                ++j;
                                continue;
                            }
                            break block5;
                        }
                        return false;
                    }
                    ++i2;
                }
                return true;
            }

            public DataFlavor[] getTransferDataFlavors(int i) {
                return this.trans[i].getTransferDataFlavors();
            }

            public Object getTransferData(int indx, DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                return this.trans[indx].getTransferData(flavor);
            }
        }
    }

    public static abstract class Single
    implements Transferable {
        private DataFlavor flavor;

        public Single(DataFlavor flavor) {
            this.flavor = flavor;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavor.equals(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.flavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.getData();
        }

        protected abstract Object getData() throws IOException, UnsupportedFlavorException;
    }
}

