/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.util.WeakSet;
import org.openide.util.io.SafeException;

public class NbObjectOutputStream
extends ObjectOutputStream {
    private static final String SVUID = "serialVersionUID";
    private static final Set alreadyReported = new WeakSet();
    private final List serializing = new ArrayList(50);
    private static Map examinedClasses;
    static /* synthetic */ Class class$java$io$IOException;

    public NbObjectOutputStream(OutputStream os) throws IOException {
        super(os);
        try {
            this.enableReplaceObject(true);
        }
        catch (SecurityException ex) {
            IOException ioe = new IOException(ex.toString());
            ErrorManager.getDefault().annotate((Throwable)ioe, ex);
            throw ioe;
        }
    }

    public Object replaceObject(Object obj) throws IOException {
        if (obj instanceof Image) {
            return null;
        }
        return super.replaceObject(obj);
    }

    public static void writeSafely(ObjectOutput oo, Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(200);
        try {
            NbObjectOutputStream oos = new NbObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bos.close();
        }
        catch (Exception exc) {
            oo.writeInt(0);
            throw new SafeException(exc);
        }
        oo.writeInt(bos.size());
        oo.write(bos.toByteArray());
    }

    protected void annotateClass(Class cl) throws IOException {
        super.annotateClass(cl);
        if (cl.isArray()) {
            return;
        }
        this.serializing.add(cl);
        if (NbObjectOutputStream.isSerialVersionUIDDeclared(cl)) {
            return;
        }
        if ((class$java$io$IOException == null ? (class$java$io$IOException = NbObjectOutputStream.class$("java.io.IOException")) : class$java$io$IOException).isAssignableFrom(cl)) {
            return;
        }
        String classname = cl.getName();
        if (alreadyReported.add(classname)) {
            HashSet<Class> serializingUniq = new HashSet<Class>();
            StringBuffer b = new StringBuffer("Serializable class ");
            b.append(classname);
            b.append(" does not declare serialVersionUID field. Encountered while storing: [");
            Iterator it = this.serializing.iterator();
            boolean first = true;
            while (it.hasNext()) {
                Class c = (Class)it.next();
                if (c == cl || !serializingUniq.add(c)) continue;
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(c.getName());
            }
            b.append("] See also http://www.netbeans.org/issues/show_bug.cgi?id=19915");
            String file = System.getProperty("InstanceDataObject.current.file");
            if (file != null && file.length() > 0) {
                b.append(" [may have been writing ");
                b.append(file);
                b.append("]");
            }
            ErrorManager.getDefault().log(16, b.toString());
        }
    }

    private static boolean isSerialVersionUIDDeclared(Class clazz) {
        String classname = clazz.getName();
        Boolean okay = (Boolean)examinedClasses.get(classname);
        if (okay == null) {
            if (classname.equals("java.util.HashSet")) {
                okay = Boolean.TRUE;
            } else {
                okay = Boolean.FALSE;
                Field[] flds = clazz.getDeclaredFields();
                int i = 0;
                while (i < flds.length) {
                    if (flds[i].getName().equals(SVUID)) {
                        okay = Boolean.TRUE;
                        break;
                    }
                    ++i;
                }
            }
            examinedClasses.put(clazz.getName(), okay);
        }
        return okay;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        alreadyReported.add("java.lang.Exception");
        alreadyReported.add("java.io.IOException");
        examinedClasses = new WeakHashMap(250);
    }
}

