/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.InheritanceTree;
import org.openide.util.lookup.WaitableResult;

public class AbstractLookup
extends Lookup {
    private Content treeLock;
    private InheritanceTree tree;
    private boolean usingTree;
    private Map reg;
    private int count;

    public AbstractLookup(Content content) {
        this.treeLock = content;
        content.attach(this);
    }

    protected AbstractLookup() {
        this(new Content());
    }

    private InheritanceTree getTree() {
        if (this.tree != null) {
            return this.tree;
        }
        Content content = this.treeLock;
        synchronized (content) {
            if (this.tree == null) {
                this.tree = new InheritanceTree();
                this.initialize();
            }
        }
        return this.tree;
    }

    private void checkForTreeModification() {
        if (this.usingTree) {
            this.usingTree = false;
            throw new IllegalStateException("You are trying to modify lookup from lookup query!");
        }
    }

    protected void initialize() {
        this.treeLock.initialize();
    }

    protected void beforeLookup(Lookup.Template template) {
        this.treeLock.beforeLookup(template);
    }

    protected final void addPair(Pair pair) {
        HashSet toNotify = new HashSet();
        InheritanceTree t = this.getTree();
        AbstractLookup abstractLookup = this;
        synchronized (abstractLookup) {
            this.checkForTreeModification();
            try {
                this.usingTree = true;
                ArrayList affected = new ArrayList();
                if (t.add(pair, affected)) {
                    this.collectListenersForList(toNotify, affected);
                    pair.index = this.count++;
                }
                Object var7_6 = null;
                this.usingTree = false;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.usingTree = false;
                throw throwable;
            }
        }
        AbstractLookup.notifyListeners(toNotify);
    }

    protected final void removePair(Pair pair) {
        HashSet toNotify;
        AbstractLookup abstractLookup = this;
        synchronized (abstractLookup) {
            if (this.tree == null) {
                return;
            }
            toNotify = new HashSet();
            ArrayList affected = new ArrayList();
            this.tree.remove(pair, affected);
            this.collectListenersForList(toNotify, affected);
        }
        AbstractLookup.notifyListeners(toNotify);
    }

    protected final void setPairs(Collection collection) {
        HashSet toNotify = new HashSet(27);
        InheritanceTree t = this.getTree();
        AbstractLookup abstractLookup = this;
        synchronized (abstractLookup) {
            this.checkForTreeModification();
            try {
                this.usingTree = true;
                HashMap<Pair, Info> shouldBeThere = new HashMap<Pair, Info>(collection.size() * 2);
                this.count = 0;
                Iterator it = collection.iterator();
                ArrayList arr = new ArrayList();
                while (it.hasNext()) {
                    Pair item = (Pair)it.next();
                    if (t.add(item, arr)) {
                        this.collectListenersForList(toNotify, arr);
                    }
                    shouldBeThere.put(item, new Info(this.count++, arr));
                    arr.clear();
                }
                ArrayList modified = new ArrayList(27);
                t.retainAll(shouldBeThere, modified);
                this.collectListenersForList(toNotify, modified);
                Object var10_9 = null;
                this.usingTree = false;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.usingTree = false;
                throw throwable;
            }
        }
        AbstractLookup.notifyListeners(toNotify);
    }

    public final Object lookup(Class clazz) {
        Lookup.Item item = this.lookupItem(new Lookup.Template(clazz));
        return item == null ? null : item.getInstance();
    }

    public final Lookup.Item lookupItem(Lookup.Template template) {
        this.beforeLookup(template);
        InheritanceTree t = this.getTree();
        AbstractLookup abstractLookup = this;
        synchronized (abstractLookup) {
            Pair pair;
            this.checkForTreeModification();
            try {
                this.usingTree = true;
                Enumeration en = t.lookup(template.getType());
                int smallest = InheritanceTree.unsorted(en) ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                Pair res = null;
                while (en.hasMoreElements()) {
                    Pair item = (Pair)en.nextElement();
                    if (!AbstractLookup.matches(template, item)) continue;
                    if (smallest == Integer.MIN_VALUE) {
                        Pair pair2 = item;
                        Object var10_9 = null;
                        this.usingTree = false;
                        return pair2;
                    }
                    if (smallest <= item.index) continue;
                    smallest = item.index;
                    res = item;
                }
                pair = res;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.usingTree = false;
                throw throwable;
            }
            Object var10_10 = null;
            this.usingTree = false;
            return pair;
        }
    }

    public final synchronized Lookup.Result lookup(Lookup.Template template) {
        LinkedList<WeakReference<R>> ws;
        R result = new R(template);
        if (this.reg == null) {
            this.reg = new HashMap(11);
        }
        if ((ws = (LinkedList<WeakReference<R>>)this.reg.get(template.getType())) == null) {
            ws = new LinkedList<WeakReference<R>>();
            this.reg.put(template.getType(), ws);
        }
        ws.add(new WeakReference<R>(result));
        return result;
    }

    private void collectListenersForList(HashSet allAffectedResults, ArrayList list) {
        if (list.size() == 1) {
            this.collectListeners(allAffectedResults, (Class)list.get(0));
        } else {
            Iterator it = ((AbstractList)list).iterator();
            while (it.hasNext()) {
                this.collectListeners(allAffectedResults, (Class)it.next());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void collectListeners(HashSet allAffectedResults, Class c) {
        if (this.reg != null) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            l = (List)this.reg.get(c);
            if (l != null && !l.isEmpty()) {
                it = l.iterator();
                while (it.hasNext()) {
                    ref = (Reference)it.next();
                    result = (R)ref.get();
                    if (result == null) {
                        it.remove();
                        continue;
                    }
                    allAffectedResults.add(result);
                }
            }
            c = c.getSuperclass();
lbl16:
            // 2 sources

            ** while (c != null)
        }
lbl17:
        // 1 sources

    }

    private static void notifyListeners(HashSet allAffectedResults) {
        if (allAffectedResults.isEmpty()) {
            return;
        }
        Iterator it = allAffectedResults.iterator();
        while (it.hasNext()) {
            R result = (R)it.next();
            result.fireStateChanged();
        }
    }

    static boolean matches(Lookup.Template t, Pair item) {
        String id = t.getId();
        if (id != null && !item.getId().equals(id)) {
            return false;
        }
        Object instance = t.getInstance();
        return instance == null || item.creatorOf(instance);
    }

    private static boolean compareArrays(Object[] a, Object[] b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] == null) {
                if (b[i] != null) {
                    return false;
                }
            } else {
                if (b[i] == null) {
                    return false;
                }
                if (!a[i].equals(b[i])) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    static final class Info {
        public int index;
        public ArrayList modified;

        public Info(int i, ArrayList m) {
            this.index = i;
            this.modified = (ArrayList)m.clone();
        }
    }

    public static class Content {
        private AbstractLookup al = null;
        private ArrayList earlyPairs = new ArrayList(3);

        final synchronized void attach(AbstractLookup al) {
            if (this.al == null) {
                this.al = al;
                Pair[] p = this.earlyPairs.toArray(new Pair[this.earlyPairs.size()]);
                int i = 0;
                while (i < p.length) {
                    this.addPair(p[i]);
                    ++i;
                }
            } else {
                throw new IllegalStateException("Trying to use content for " + al + " but it is already used for " + this.al);
            }
            this.earlyPairs = null;
        }

        public final void addPair(Pair pair) {
            AbstractLookup a = this.al;
            if (a != null) {
                a.addPair(pair);
            } else {
                this.earlyPairs.add(pair);
            }
        }

        public final void removePair(Pair pair) {
            AbstractLookup a = this.al;
            if (a != null) {
                a.removePair(pair);
            } else {
                ((AbstractCollection)this.earlyPairs).remove(pair);
            }
        }

        public final void setPairs(Collection c) {
            AbstractLookup a = this.al;
            if (a != null) {
                a.setPairs(c);
            } else {
                this.earlyPairs.clear();
                this.earlyPairs.addAll(c);
            }
        }

        void initialize() {
        }

        void beforeLookup(Lookup.Template template) {
        }
    }

    private final class R
    extends WaitableResult {
        private Lookup.Template template;
        private Set classesCache;
        private Collection instancesCache;
        private Collection itemsCache;
        private ArrayList listeners;

        R(Lookup.Template template) {
            this.template = template;
        }

        public void fireStateChanged() {
            LookupListener[] arr;
            Object[] newArray;
            Object[] previousArray;
            Collection previousItems = this.itemsCache;
            this.classesCache = null;
            this.instancesCache = null;
            this.itemsCache = null;
            if (previousItems != null && AbstractLookup.compareArrays(previousArray = previousItems.toArray(), newArray = this.allItems().toArray())) {
                return;
            }
            R r = this;
            synchronized (r) {
                if (this.listeners == null) {
                    return;
                }
                arr = this.listeners.toArray(new LookupListener[this.listeners.size()]);
            }
            LookupEvent ev = new LookupEvent(this);
            int i = 0;
            while (i < arr.length) {
                arr[i].resultChanged(ev);
                ++i;
            }
        }

        public synchronized void addLookupListener(LookupListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        public synchronized void removeLookupListener(LookupListener l) {
            ((AbstractCollection)this.listeners).remove(l);
        }

        public Collection allInstances() {
            ArrayList<Object> s = this.instancesCache;
            if (s != null) {
                return s;
            }
            s = new ArrayList<Object>(this.allItems().size());
            Iterator it = this.allItems().iterator();
            while (it.hasNext()) {
                Lookup.Item item = (Lookup.Item)it.next();
                Object obj = item.getInstance();
                if (obj == null) continue;
                s.add(obj);
            }
            this.instancesCache = s;
            return s;
        }

        public Set allClasses() {
            HashSet<Class> s = this.classesCache;
            if (s != null) {
                return s;
            }
            s = new HashSet<Class>();
            Iterator it = this.allItems().iterator();
            while (it.hasNext()) {
                Lookup.Item item = (Lookup.Item)it.next();
                Class clazz = item.getType();
                if (clazz == null) continue;
                s.add(clazz);
            }
            this.classesCache = s;
            return s;
        }

        public Collection allItems() {
            AbstractLookup.this.beforeLookup(this.template);
            if (this.itemsCache != null) {
                return this.itemsCache;
            }
            InheritanceTree t = AbstractLookup.this.getTree();
            AbstractLookup abstractLookup = AbstractLookup.this;
            synchronized (abstractLookup) {
                TreeSet<Pair> treeSet;
                AbstractLookup.this.checkForTreeModification();
                try {
                    AbstractLookup.this.usingTree = true;
                    Enumeration en = t.lookup(this.template.getType());
                    TreeSet<Pair> items = new TreeSet<Pair>(t);
                    while (en.hasMoreElements()) {
                        Pair i = (Pair)en.nextElement();
                        if (!AbstractLookup.matches(this.template, i)) continue;
                        items.add(i);
                    }
                    this.itemsCache = items;
                    treeSet = items;
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    AbstractLookup.this.usingTree = false;
                    throw throwable;
                }
                AbstractLookup.this.usingTree = false;
                return treeSet;
            }
        }

        protected void beforeLookup(Lookup.Template t) {
            if (t.getType() == this.template.getType()) {
                AbstractLookup.this.beforeLookup(t);
            }
        }
    }

    public static abstract class Pair
    extends Lookup.Item {
        int index = -1;

        protected Pair() {
        }

        protected abstract boolean instanceOf(Class var1);

        protected abstract boolean creatorOf(Object var1);
    }
}

