/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.QueueEnumeration;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;
import org.openide.util.lookup.AbstractLookup;

final class InheritanceTree
implements Comparator {
    private Node object = new Node(class$java$lang$Object == null ? (class$java$lang$Object = InheritanceTree.class$("java.lang.Object")) : class$java$lang$Object);
    private Map interfaces;
    static /* synthetic */ Class class$java$lang$Object;

    public boolean add(AbstractLookup.Pair item, Collection affected) {
        Node node = InheritanceTree.registerClass(this.object, item);
        affected.add(node.getType());
        if (!node.assignItem(item)) {
            return false;
        }
        boolean registeredAsInterface = this.registerInterface(item, affected);
        return registeredAsInterface;
    }

    public void remove(AbstractLookup.Pair item, Collection affected) {
        Node n = InheritanceTree.removeClass(this.object, item);
        if (n != null) {
            affected.add(n.getType());
        }
        this.removeInterface(item, affected);
    }

    public void retainAll(Map retain, Collection notify) {
        this.retainAllInterface(retain, notify);
        InheritanceTree.retainAllClasses(this.object, retain, notify);
    }

    public Enumeration lookup(Class clazz) {
        if (clazz.isInterface()) {
            return this.searchInterface(clazz);
        }
        return InheritanceTree.searchClass(this.object, clazz);
    }

    public static boolean unsorted(Enumeration en) {
        return en instanceof SequenceEnumeration;
    }

    public void print(PrintStream out, boolean instances) {
        InheritanceTree.printNode(this.object, "", out, instances);
    }

    private static Node registerClass(Node n, AbstractLookup.Pair item) {
        if (!n.accepts(item)) {
            return null;
        }
        if (n.children != null) {
            Node ch;
            Iterator it = ((AbstractList)n.children).iterator();
            while ((ch = InheritanceTree.extractNode(it)) != null) {
                Node result = InheritanceTree.registerClass(ch, item);
                if (result == null) continue;
                return result;
            }
        }
        return n;
    }

    private static Node removeClass(Node n, AbstractLookup.Pair item) {
        if (!n.accepts(item)) {
            return null;
        }
        if (n.items != null && ((AbstractCollection)n.items).remove(item)) {
            return n;
        }
        if (n.children != null) {
            Node ch;
            Iterator it = ((AbstractList)n.children).iterator();
            while ((ch = InheritanceTree.extractNode(it)) != null) {
                Node result = InheritanceTree.removeClass(ch, item);
                if ((ch.items == null || ch.items.isEmpty()) && (ch.children == null || ch.children.isEmpty())) {
                    it.remove();
                }
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static Node classToNode(Node n, Class clazz) {
        if (!n.accepts(clazz)) {
            return null;
        }
        if (n.getType() == clazz) {
            return n;
        }
        if (n.children != null) {
            Node ch;
            Iterator it = ((AbstractList)n.children).iterator();
            while ((ch = InheritanceTree.extractNode(it)) != null) {
                Node found = InheritanceTree.classToNode(ch, clazz);
                if (found == null) continue;
                return found;
            }
        }
        ArrayList<Node> reparent = null;
        if (n.children == null) {
            n.children = new ArrayList();
        } else {
            Node r;
            Iterator it = ((AbstractList)n.children).iterator();
            while ((r = InheritanceTree.extractNode(it)) != null) {
                if (!clazz.isAssignableFrom(r.getType())) continue;
                if (reparent == null) {
                    reparent = new ArrayList<Node>();
                }
                reparent.add(r);
                it.remove();
            }
        }
        Node newNode = new Node(clazz);
        n.children.add(newNode);
        if (reparent != null) {
            newNode.children = reparent;
        }
        if (n.items != null) {
            Iterator it = ((AbstractList)n.items).iterator();
            while (it.hasNext()) {
                AbstractLookup.Pair item = (AbstractLookup.Pair)it.next();
                if (!item.instanceOf(clazz)) continue;
                it.remove();
                newNode.assignItem(item);
            }
        }
        return newNode;
    }

    private static Enumeration searchClass(Node n, Class clazz) {
        if ((n = InheritanceTree.classToNode(n, clazz)) == null) {
            return EmptyEnumeration.EMPTY;
        }
        return InheritanceTree.nodeToEnum(n);
    }

    private static boolean retainAllClasses(Node node, Map retain, Collection notify) {
        Iterator it;
        boolean retained = false;
        if (node.items != null && retain != null) {
            it = ((AbstractList)node.items).iterator();
            while (it.hasNext()) {
                AbstractLookup.Pair item = (AbstractLookup.Pair)it.next();
                AbstractLookup.Info n = (AbstractLookup.Info)retain.get(item);
                if (n == null) {
                    it.remove();
                    retained = true;
                    continue;
                }
                if (item.index == n.index) continue;
                item.index = n.index;
                notify.addAll(n.modified);
            }
            if (retained && notify != null) {
                notify.add(node.getType());
            }
        }
        if (node.children != null) {
            Node ch;
            it = ((AbstractList)node.children).iterator();
            while ((ch = InheritanceTree.extractNode(it)) != null) {
                boolean result = InheritanceTree.retainAllClasses(ch, retain, notify);
                if (!result) continue;
                it.remove();
            }
        }
        return retained && node.items.isEmpty() && (node.children == null || node.children.isEmpty());
    }

    private static Enumeration nodeToEnum(Node n) {
        if (n.children == null) {
            return n.items == null ? EmptyEnumeration.EMPTY : Collections.enumeration(n.items);
        }
        QueueEnumeration en = new QueueEnumeration(){

            protected void process(Object obj) {
                Node n2 = (Node)obj;
                if (n2.children != null) {
                    Object[] nodes = n2.children.toArray();
                    this.put(nodes);
                }
            }
        };
        en.put(n);
        AlterEnumeration alt = new AlterEnumeration(en){

            protected Object alter(Object obj) {
                Node n2 = (Node)obj;
                if (n2.items == null || n2.items.isEmpty()) {
                    return EmptyEnumeration.EMPTY;
                }
                return Collections.enumeration(n2.items);
            }
        };
        return new SequenceEnumeration(alt);
    }

    private boolean registerInterface(AbstractLookup.Pair item, Collection affected) {
        if (this.interfaces == null) {
            return true;
        }
        Iterator it = this.interfaces.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Class iface = (Class)entry.getKey();
            if (!item.instanceOf(iface)) continue;
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection set = (Collection)value;
                if (!set.add(item)) {
                    return false;
                }
            } else {
                if (value.equals(item)) {
                    return false;
                }
                ArrayList<Object> ll = new ArrayList<Object>(3);
                ll.add(value);
                ll.add(item);
                entry.setValue(ll);
            }
            affected.add(iface);
        }
        return true;
    }

    private void removeInterface(AbstractLookup.Pair item, Collection affected) {
        if (this.interfaces == null) {
            return;
        }
        Iterator it = this.interfaces.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection set = (Collection)value;
                if (!set.remove(item)) continue;
                if (set.size() == 1) {
                    entry.setValue(set.iterator().next());
                }
                affected.add(entry.getKey());
                continue;
            }
            if (!value.equals(item)) continue;
            it.remove();
            affected.add(entry.getKey());
        }
    }

    private void retainAllInterface(Map retain, Collection affected) {
        if (this.interfaces == null) {
            return;
        }
        Iterator it = this.interfaces.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            boolean multi = value instanceof Collection;
            Iterator<Object> elems = multi ? ((Collection)value).iterator() : Collections.singleton(value).iterator();
            boolean changed = false;
            boolean reordered = false;
            while (elems.hasNext()) {
                AbstractLookup.Pair p = (AbstractLookup.Pair)elems.next();
                AbstractLookup.Info n = (AbstractLookup.Info)retain.get(p);
                if (n == null) {
                    if (multi) {
                        elems.remove();
                    }
                    changed = true;
                    continue;
                }
                if (p.index == n.index) continue;
                p.index = n.index;
                affected.addAll(n.modified);
                reordered = true;
            }
            if (reordered && value instanceof List) {
                List l = (List)value;
                Collections.sort(l, this);
            }
            if (!changed) continue;
            if (multi) {
                Collection c = (Collection)value;
                if (c.size() == 1) {
                    entry.setValue(c.iterator().next());
                }
            } else {
                it.remove();
            }
            affected.add(entry.getKey());
        }
    }

    private Enumeration searchInterface(Class clazz) {
        Object obj;
        if (this.interfaces == null) {
            this.interfaces = new WeakHashMap();
        }
        if ((obj = this.interfaces.get(clazz)) == null) {
            AbstractLookup.Pair one = null;
            ArrayList<AbstractLookup.Pair> items = null;
            Enumeration en = this.lookup(class$java$lang$Object == null ? (class$java$lang$Object = InheritanceTree.class$("java.lang.Object")) : class$java$lang$Object);
            while (en.hasMoreElements()) {
                AbstractLookup.Pair it = (AbstractLookup.Pair)en.nextElement();
                if (!it.instanceOf(clazz)) continue;
                if (one == null) {
                    one = it;
                    continue;
                }
                if (items == null) {
                    items = new ArrayList(3);
                    items.add(one);
                }
                items.add(it);
            }
            if (items == null && one != null) {
                this.interfaces.put(clazz, one);
                return new SingletonEnumeration(one);
            }
            if (items == null) {
                items = new ArrayList<AbstractLookup.Pair>(2);
            }
            this.interfaces.put(clazz, items);
            return Collections.enumeration(items);
        }
        if (obj instanceof Collection) {
            return Collections.enumeration((Collection)obj);
        }
        return new SingletonEnumeration(obj);
    }

    private static Node extractNode(Iterator it) {
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.get() == null) {
                it.remove();
                continue;
            }
            return n;
        }
        return null;
    }

    private static void printNode(Node n, String sp, PrintStream out, boolean instances) {
        Iterator it;
        int i;
        Class type = n.getType();
        out.print(sp);
        out.println("Node for: " + type + "\t" + (type == null ? null : type.getClassLoader()));
        if (n.items != null) {
            i = 0;
            it = ((AbstractList)new ArrayList(n.items)).iterator();
            while (it.hasNext()) {
                AbstractLookup.Pair p = (AbstractLookup.Pair)it.next();
                out.print(sp);
                out.print("  item (" + i++ + "): ");
                out.print(p);
                out.print(" id: " + Integer.toHexString(System.identityHashCode(p)));
                out.print(" index: ");
                out.print(p.index);
                if (instances) {
                    out.print(" I: " + p.getInstance());
                }
                out.println();
            }
        }
        if (n.children != null) {
            i = 0;
            it = ((AbstractList)n.children).iterator();
            while (it.hasNext()) {
                Node ch = (Node)it.next();
                InheritanceTree.printNode(ch, sp + "  ", out, instances);
            }
        }
    }

    public int compare(Object obj, Object obj1) {
        AbstractLookup.Pair i1 = (AbstractLookup.Pair)obj;
        AbstractLookup.Pair i2 = (AbstractLookup.Pair)obj1;
        int result = i1.index - i2.index;
        if (result == 0) {
            if (i1 != i2) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bs);
                ps.println("Please report this exception as issue http://www.netbeans.org/issues/show_bug.cgi?id=13779 Pair1: " + i1 + " pair2: " + i2 + " index1: " + i1.index + " index2: " + i2.index + " item1: " + i1.getInstance() + " item2: " + i2.getInstance() + " id1: " + Integer.toHexString(System.identityHashCode(i1)) + " id2: " + Integer.toHexString(System.identityHashCode(i2)));
                this.print(ps, false);
                ps.close();
                throw new IllegalStateException(bs.toString());
            }
            return 0;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class Node
    extends WeakReference {
        public ArrayList children;
        public ArrayList items;
        static /* synthetic */ Class class$java$lang$Object;

        public Node(Class clazz) {
            super(clazz);
        }

        public Class getType() {
            Class c = (Class)this.get();
            return c == null ? Void.TYPE : c;
        }

        public boolean accepts(Class clazz) {
            if (this.getType() == (class$java$lang$Object == null ? (class$java$lang$Object = Node.class$("java.lang.Object")) : class$java$lang$Object)) {
                return true;
            }
            return this.getType().isAssignableFrom(clazz);
        }

        public boolean accepts(AbstractLookup.Pair item) {
            if (this.getType() == (class$java$lang$Object == null ? (class$java$lang$Object = Node.class$("java.lang.Object")) : class$java$lang$Object)) {
                return true;
            }
            return item.instanceOf(this.getType());
        }

        public boolean assignItem(AbstractLookup.Pair item) {
            if (this.items == null) {
                this.items = new ArrayList();
                this.items.add(item);
                return true;
            }
            boolean was = ((AbstractCollection)this.items).remove(item);
            this.items.add(item);
            return !was;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

