/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class SimpleLookup
extends Lookup {
    private Collection allItems;

    SimpleLookup(Collection instances) {
        this.allItems = new ArrayList(instances.size());
        Iterator i = instances.iterator();
        while (i.hasNext()) {
            this.allItems.add(new InstanceContent.SimpleItem(i.next()));
        }
    }

    SimpleLookup(Collection keys, InstanceContent.Convertor conv) {
        this.allItems = new ArrayList(keys.size());
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            this.allItems.add(new InstanceContent.ConvertingItem(i.next(), conv));
        }
    }

    public Lookup.Result lookup(Lookup.Template template) {
        if (template == null) {
            throw new NullPointerException();
        }
        return new SimpleResult(template);
    }

    public Object lookup(Class clazz) {
        Lookup.Item item = this.lookupItem(new Lookup.Template(clazz));
        return item == null ? null : item.getInstance();
    }

    private static boolean matches(Lookup.Template t, AbstractLookup.Pair item) {
        if (!AbstractLookup.matches(t, item)) {
            return false;
        }
        Class type = t.getType();
        return type == null || type.isAssignableFrom(item.getType());
    }

    private class SimpleResult
    extends Lookup.Result {
        private Set classes;
        private Collection items;
        private Lookup.Template template;
        private Collection results;

        SimpleResult(Lookup.Template template) {
            this.template = template;
        }

        public void addLookupListener(LookupListener l) {
        }

        public void removeLookupListener(LookupListener l) {
        }

        public Collection allInstances() {
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                if (this.results != null) {
                    Collection collection = this.results;
                    return collection;
                }
            }
            ArrayList<Object> res = new ArrayList<Object>(SimpleLookup.this.allItems.size());
            Iterator i = this.allItems().iterator();
            while (i.hasNext()) {
                res.add(((Lookup.Item)i.next()).getInstance());
            }
            SimpleResult simpleResult2 = this;
            synchronized (simpleResult2) {
                this.results = Collections.unmodifiableCollection(res);
            }
            return this.results;
        }

        public Set allClasses() {
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                if (this.classes != null) {
                    Set set = this.classes;
                    return set;
                }
            }
            TreeSet<Class> res = new TreeSet<Class>();
            Iterator i = this.allItems().iterator();
            while (i.hasNext()) {
                res.add(((Lookup.Item)i.next()).getType());
            }
            SimpleResult simpleResult2 = this;
            synchronized (simpleResult2) {
                this.classes = Collections.unmodifiableSet(res);
            }
            return this.classes;
        }

        public Collection allItems() {
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                if (this.items != null) {
                    Collection collection = this.items;
                    return collection;
                }
            }
            ArrayList res = new ArrayList(SimpleLookup.this.allItems.size());
            Iterator i = SimpleLookup.this.allItems.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof AbstractLookup.Pair) || !SimpleLookup.matches(this.template, (AbstractLookup.Pair)o)) continue;
                res.add(o);
            }
            SimpleResult simpleResult2 = this;
            synchronized (simpleResult2) {
                this.items = Collections.unmodifiableCollection(res);
            }
            return this.items;
        }
    }
}

