/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.io.NbMarshalledObject;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public abstract class CloneableTopComponent
extends TopComponent
implements Externalizable,
TopComponent.Cloneable {
    static final long serialVersionUID = 4893753008783256289L;
    private Ref ref;
    public static final Ref EMPTY = new Ref();
    static /* synthetic */ Class class$org$openide$windows$CloneableTopComponent;

    public CloneableTopComponent() {
    }

    public CloneableTopComponent(DataObject obj) {
        super(obj);
    }

    public final Object clone() {
        return this.cloneComponent();
    }

    public final CloneableTopComponent cloneTopComponent() {
        CloneableTopComponent top = this.createClonedObject();
        top.setReference(this.getReference());
        return top;
    }

    public final TopComponent cloneComponent() {
        return this.cloneTopComponent();
    }

    protected CloneableTopComponent createClonedObject() {
        try {
            NbMarshalledObject o = new NbMarshalledObject(this);
            CloneableTopComponent top = (CloneableTopComponent)o.get();
            return top;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new InternalError();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new InternalError();
        }
    }

    public final synchronized Ref getReference() {
        if (this.ref == null) {
            this.ref = new Ref(this);
        }
        return this.ref;
    }

    public final synchronized void setReference(Ref another) {
        if (another == EMPTY) {
            throw new IllegalArgumentException(NbBundle.getBundle(class$org$openide$windows$CloneableTopComponent == null ? (class$org$openide$windows$CloneableTopComponent = CloneableTopComponent.class$("org.openide.windows.CloneableTopComponent")) : class$org$openide$windows$CloneableTopComponent).getString("EXC_CannotAssign"));
        }
        if (this.ref != null) {
            Ref ref = this.ref;
            synchronized (ref) {
                this.ref.getTable().remove(this);
            }
        }
        another.register(this);
    }

    public boolean canClose(Workspace workspace, boolean last) {
        if (last) {
            return this.getReference().unregister(this);
        }
        return true;
    }

    protected boolean closeLast() {
        return true;
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        Ref ref;
        super.readExternal(oi);
        if (this.serialVersion != 0 && (ref = (Ref)oi.readObject()) != null) {
            this.setReference(ref);
        }
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeObject(this.ref);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Ref
    implements Serializable {
        static final long serialVersionUID = 5543148876020730556L;
        private static final Object LOCK = new Object();
        private transient HashSet table;

        protected Ref() {
        }

        Ref(CloneableTopComponent c) {
            this.getTable().add(c);
        }

        private HashSet getTable() {
            if (this.table == null) {
                this.table = new HashSet(7);
            }
            return this.table;
        }

        Set componentSet() {
            Object object = LOCK;
            synchronized (object) {
                Set set = (Set)this.getTable().clone();
                return set;
            }
        }

        public Enumeration getComponents() {
            return Collections.enumeration(this.componentSet());
        }

        public boolean isEmpty() {
            Object object = LOCK;
            synchronized (object) {
                boolean bl = this.getTable().isEmpty();
                return bl;
            }
        }

        public CloneableTopComponent getAnyComponent() {
            Object object = LOCK;
            synchronized (object) {
                CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)this.getTable().iterator().next();
                return cloneableTopComponent;
            }
        }

        final void register(CloneableTopComponent c) {
            Object object = LOCK;
            synchronized (object) {
                this.getTable().add(c);
                c.ref = this;
            }
        }

        final boolean unregister(CloneableTopComponent c) {
            HashSet table = this.getTable();
            if (table.size() > 1 || c.closeLast()) {
                Object object = LOCK;
                synchronized (object) {
                    table.remove(c);
                }
                return true;
            }
            return false;
        }
    }
}

