/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.openide.util.io.NullInputStream;
import org.openide.util.io.NullOutputStream;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public interface InputOutput {
    public static final InputOutput NULL = new Null();
    public static final Reader nullReader = new InputStreamReader(new NullInputStream());
    public static final OutputWriter nullWriter = new NullOutputWriter();

    public OutputWriter getOut();

    public Reader getIn();

    public OutputWriter getErr();

    public void closeInputOutput();

    public boolean isClosed();

    public void setOutputVisible(boolean var1);

    public void setErrVisible(boolean var1);

    public void setInputVisible(boolean var1);

    public void select();

    public boolean isErrSeparated();

    public void setErrSeparated(boolean var1);

    public boolean isFocusTaken();

    public void setFocusTaken(boolean var1);

    public Reader flushReader();

    public static final class NullOutputWriter
    extends OutputWriter {
        NullOutputWriter() {
            super(new OutputStreamWriter(new NullOutputStream()));
        }

        public void reset() {
        }

        public void println(String s, OutputListener l) {
        }
    }

    public static final class Null
    implements InputOutput {
        public OutputWriter getOut() {
            return nullWriter;
        }

        public Reader getIn() {
            return nullReader;
        }

        public OutputWriter getErr() {
            return nullWriter;
        }

        public void closeInputOutput() {
        }

        public boolean isClosed() {
            return true;
        }

        public void setOutputVisible(boolean value) {
        }

        public void setErrVisible(boolean value) {
        }

        public void setInputVisible(boolean value) {
        }

        public void select() {
        }

        public boolean isErrSeparated() {
            return false;
        }

        public void setErrSeparated(boolean value) {
        }

        public boolean isFocusTaken() {
            return false;
        }

        public void setFocusTaken(boolean value) {
        }

        public Reader flushReader() {
            return nullReader;
        }
    }
}

