/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class TopComponent
extends JComponent
implements Externalizable,
Accessible {
    static final long serialVersionUID = -3022538025284122942L;
    private static Registry registry;
    public static final int CLOSE_EACH = 0;
    public static final int CLOSE_LAST = 1;
    private static SystemAction[] systemActions;
    private NodeName nodeName;
    private final WindowManager.Component manager;
    private int closeOperation = 1;
    private boolean processingRequestFocus = false;
    short serialVersion = 1;
    private static Method helpCtxMethod;
    static /* synthetic */ Class class$org$openide$actions$SaveAction;
    static /* synthetic */ Class class$org$openide$actions$CloneViewAction;
    static /* synthetic */ Class class$org$openide$actions$CloseViewAction;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;

    public TopComponent() {
        this.enableEvents(8L);
        this.putClientProperty("HelpIDMethod", TopComponent.getHelpCtxMethod());
        this.setRequestFocusEnabled(false);
        this.manager = WindowManager.getDefault().createTopComponentManager(this);
    }

    public TopComponent(DataObject obj) {
        this();
        Node n = obj.getNodeDelegate();
        this.nodeName = new NodeName(this);
        this.nodeName.attach(n);
        this.getAccessibleContext().setAccessibleDescription(n.getDisplayName());
    }

    public static final Registry getRegistry() {
        return WindowManager.getDefault().getRegistry();
    }

    public final Node[] getActivatedNodes() {
        return this.getManager().getActivatedNodes();
    }

    public final void setActivatedNodes(Node[] nodes) {
        this.getManager().setActivatedNodes(nodes);
        this.firePropertyChange("activatedNodes", null, null);
    }

    public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }

    public void open() {
        this.open(null);
    }

    public void open(Workspace workspace) {
        this.getManager().open(workspace);
    }

    public final boolean isOpened() {
        return this.getManager().whereOpened().size() > 0;
    }

    public final boolean isOpened(Workspace workspace) {
        return this.getManager().whereOpened().contains(workspace);
    }

    public final boolean close() {
        return this.close(WindowManager.getDefault().getCurrentWorkspace());
    }

    public final boolean close(Workspace workspace) {
        boolean result;
        Set whereOpened = this.getManager().whereOpened();
        if (this.closeOperation != 0 && !whereOpened.contains(workspace)) {
            return true;
        }
        switch (this.closeOperation) {
            case 1: {
                result = this.canClose(workspace, whereOpened.size() == 1);
                break;
            }
            case 0: {
                result = this.canClose(null, true);
                break;
            }
            default: {
                throw new IllegalStateException("closeOperation=" + this.closeOperation);
            }
        }
        if (result) {
            this.getManager().close(workspace);
        }
        return result;
    }

    public boolean canClose(Workspace workspace, boolean last) {
        return true;
    }

    protected void openNotify() {
    }

    protected void closeNotify() {
    }

    public SystemAction[] getSystemActions() {
        if (systemActions == null) {
            systemActions = new SystemAction[]{SystemAction.get(class$org$openide$actions$SaveAction == null ? (class$org$openide$actions$SaveAction = TopComponent.class$("org.openide.actions.SaveAction")) : class$org$openide$actions$SaveAction), SystemAction.get(class$org$openide$actions$CloneViewAction == null ? (class$org$openide$actions$CloneViewAction = TopComponent.class$("org.openide.actions.CloneViewAction")) : class$org$openide$actions$CloneViewAction), null, SystemAction.get(class$org$openide$actions$CloseViewAction == null ? (class$org$openide$actions$CloseViewAction = TopComponent.class$("org.openide.actions.CloseViewAction")) : class$org$openide$actions$CloseViewAction)};
        }
        return systemActions;
    }

    public final void setCloseOperation(int closeOperation) {
        if (closeOperation != 0 && closeOperation != 1) {
            throw new IllegalArgumentException(NbBundle.getBundle(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = TopComponent.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent).getString("EXC_UnknownOperation"));
        }
        if (this.closeOperation == closeOperation) {
            return;
        }
        this.closeOperation = closeOperation;
        this.firePropertyChange("closeOperation", null, null);
    }

    public final int getCloseOperation() {
        return this.closeOperation;
    }

    protected void componentOpened() {
        this.openNotify();
    }

    protected void componentClosed() {
        this.closeNotify();
    }

    protected void componentShowing() {
    }

    protected void componentHidden() {
    }

    protected void componentActivated() {
    }

    protected void componentDeactivated() {
    }

    public void requestFocus() {
        if (this.processingRequestFocus) {
            return;
        }
        this.processingRequestFocus = true;
        this.getManager().requestFocus();
        super.requestFocus();
        this.processingRequestFocus = false;
    }

    public void requestVisible() {
        this.getManager().requestVisible();
    }

    public void setName(String name) {
        if (name != null && name.equals(this.getName())) {
            return;
        }
        super.setName(name);
        this.getManager().nameChanged();
    }

    public void setIcon(Image icon) {
        this.getManager().setIcon(icon);
        this.firePropertyChange("icon", null, null);
    }

    public Image getIcon() {
        return this.getManager().getIcon();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = TopComponent.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent);
    }

    public List availableModes(List modes) {
        return modes;
    }

    final WindowManager.Component getManager() {
        return this.manager;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(new Short(this.serialVersion));
        out.writeInt(this.closeOperation);
        out.writeObject(this.getName());
        out.writeObject(this.getToolTipText());
        Node.Handle h = this.nodeName == null ? null : this.nodeName.node.getHandle();
        out.writeObject(h);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object firstObject = in.readObject();
        if (firstObject instanceof Integer) {
            this.serialVersion = 0;
            this.closeOperation = (Integer)firstObject;
            DataObject obj = (DataObject)in.readObject();
            super.setName((String)in.readObject());
            this.setToolTipText((String)in.readObject());
            if (obj != null) {
                this.nodeName = new NodeName(this);
                this.nodeName.attach(obj.getNodeDelegate());
            }
        } else {
            this.serialVersion = (Short)firstObject;
            this.closeOperation = in.readInt();
            super.setName((String)in.readObject());
            this.setToolTipText((String)in.readObject());
            Node.Handle h = (Node.Handle)in.readObject();
            if (h != null) {
                Node n = h.getNode();
                this.nodeName = new NodeName(this);
                this.nodeName.attach(n);
            }
        }
        if (this.closeOperation != 0 && this.closeOperation != 1) {
            throw new IOException("invalid closeOperation: " + this.closeOperation);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Replacer(this);
    }

    private static Method getHelpCtxMethod() {
        if (helpCtxMethod != null) {
            return helpCtxMethod;
        }
        try {
            helpCtxMethod = (class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = TopComponent.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent).getMethod("getHelpCtx", new Class[0]);
            return helpCtxMethod;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new InternalError();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }

                public String getAccessibleName() {
                    if (this.accessibleName != null) {
                        return this.accessibleName;
                    }
                    return TopComponent.this.getName();
                }

                public String getToolTipText() {
                    return TopComponent.this.getToolTipText();
                }
            };
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Replacer
    implements Serializable {
        static final long serialVersionUID = -8897067133215740572L;
        transient TopComponent tc;
        static /* synthetic */ Class class$java$lang$ClassLoader;
        static /* synthetic */ Class class$java$io$ObjectStreamException;
        static /* synthetic */ Class class$java$lang$Object;

        public Replacer(TopComponent tc) {
            this.tc = tc;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            oos.writeObject(this.tc.getClass().getName());
            this.tc.writeExternal(oos);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            block11: {
                String name = (String)ois.readObject();
                name = Utilities.translate(name);
                try {
                    Class<?>[] result;
                    Class<?> tcClass = Class.forName(name, true, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Replacer.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
                    Constructor<?> con = tcClass.getDeclaredConstructor(new Class[0]);
                    ((AccessibleObject)con).setAccessible(true);
                    try {
                        this.tc = (TopComponent)con.newInstance(new Object[0]);
                        Object var6_8 = null;
                        ((AccessibleObject)con).setAccessible(false);
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        ((AccessibleObject)con).setAccessible(false);
                        throw throwable;
                    }
                    this.tc.readExternal(ois);
                    Method resolveMethod = Replacer.findReadResolveMethod(tcClass);
                    if (resolveMethod == null || (result = resolveMethod.getExceptionTypes()).length != 1 || !(class$java$io$ObjectStreamException == null ? (class$java$io$ObjectStreamException = Replacer.class$("java.io.ObjectStreamException")) : class$java$io$ObjectStreamException).equals(result[0]) || !(class$java$lang$Object == null ? (class$java$lang$Object = Replacer.class$("java.lang.Object")) : class$java$lang$Object).equals(resolveMethod.getReturnType())) break block11;
                    ((AccessibleObject)resolveMethod).setAccessible(true);
                    try {
                        TopComponent unresolvedTc = this.tc;
                        this.tc = (TopComponent)resolveMethod.invoke((Object)this.tc, (Object[])new Class[0]);
                        if (this.tc == null) {
                            throw new InvalidObjectException("Resolved component is invalid: " + unresolvedTc);
                        }
                        Object var9_15 = null;
                        ((AccessibleObject)resolveMethod).setAccessible(false);
                    }
                    catch (Throwable throwable) {
                        Object var9_16 = null;
                        ((AccessibleObject)resolveMethod).setAccessible(false);
                        throw throwable;
                    }
                }
                catch (ClassNotFoundException exc) {
                    if (exc.getMessage().indexOf("org.netbeans.modules.objectbrowser") != -1 || exc.getMessage().indexOf("org.netbeans.modules.icebrowser") != -1) {
                        this.tc = null;
                    }
                    IOException newEx = new IOException(exc.getMessage());
                    ErrorManager.getDefault().annotate((Throwable)newEx, exc);
                    throw newEx;
                }
                catch (Exception exc) {
                    Throwable th = exc;
                    if (th instanceof InvocationTargetException) {
                        th = ((InvocationTargetException)th).getTargetException();
                    }
                    if (th instanceof IOException) {
                        throw (IOException)th;
                    }
                    IOException newEx = new IOException(th.getMessage());
                    ErrorManager.getDefault().annotate((Throwable)newEx, th);
                    throw newEx;
                }
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.tc;
        }

        private static Method findReadResolveMethod(Class clazz) {
            Method result = null;
            try {
                result = clazz.getMethod("readResolve", new Class[0]);
            }
            catch (NoSuchMethodException exc) {
                // empty catch block
            }
            Class i = clazz;
            while (i != null) {
                try {
                    result = i.getDeclaredMethod("readResolve", new Class[0]);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    i = i.getSuperclass();
                }
            }
            return result;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static interface Registry {
        public static final String PROP_OPENED = "opened";
        public static final String PROP_ACTIVATED = "activated";
        public static final String PROP_CURRENT_NODES = "currentNodes";
        public static final String PROP_ACTIVATED_NODES = "activatedNodes";

        public Set getOpened();

        public TopComponent getActivated();

        public Node[] getCurrentNodes();

        public Node[] getActivatedNodes();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    public static class NodeName
    extends NodeAdapter {
        private transient Reference top;
        private transient Node node;

        public NodeName(TopComponent top) {
            this.top = new WeakReference<TopComponent>(top);
        }

        final void attach(Node n) {
            TopComponent top = (TopComponent)this.top.get();
            if (top != null) {
                TopComponent topComponent = top;
                synchronized (topComponent) {
                    if (n == this.node) {
                        return;
                    }
                    if (this.node != null) {
                        this.node.removeNodeListener(this);
                    }
                    this.node = n;
                    if (n != null) {
                        n.addNodeListener(this);
                        top.setActivatedNodes(new Node[]{n});
                        top.setName(n.getDisplayName());
                    }
                }
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            TopComponent top = (TopComponent)this.top.get();
            if (top == null) {
                if (ev.getSource() instanceof Node) {
                    Node n = (Node)ev.getSource();
                    n.removeNodeListener(this);
                }
                return;
            }
            this.attach(this.node);
            if (ev.getPropertyName().equals("displayName")) {
                top.setName(this.node.getDisplayName());
            }
        }
    }

    public static interface Cloneable {
        public TopComponent cloneComponent();
    }
}

