/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Set;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public abstract class WindowManager
implements Serializable {
    public static final String PROP_WORKSPACES = "workspaces";
    public static final String PROP_CURRENT_WORKSPACE = "currentWorkspace";
    private TopComponent activeComponent;
    private TopComponent.Registry registry;
    private static WindowManager wmInstance;
    static final long serialVersionUID = -4133918059009277602L;
    static /* synthetic */ Class class$org$openide$windows$WindowManager;

    public static final WindowManager getDefault() {
        Class clazz = class$org$openide$windows$WindowManager == null ? (class$org$openide$windows$WindowManager = WindowManager.class$("org.openide.windows.WindowManager")) : class$org$openide$windows$WindowManager;
        synchronized (clazz) {
            if (wmInstance == null) {
                Lookup.Item resultItem = Lookup.getDefault().lookupItem(new Lookup.Template(class$org$openide$windows$WindowManager == null ? (class$org$openide$windows$WindowManager = WindowManager.class$("org.openide.windows.WindowManager")) : class$org$openide$windows$WindowManager));
                if (resultItem == null || !(resultItem.getInstance() instanceof WindowManager)) {
                    throw new IllegalStateException("Fatal error, can't find window manager instance in lookup.");
                }
                wmInstance = (WindowManager)resultItem.getInstance();
            }
            WindowManager windowManager = wmInstance;
            return windowManager;
        }
    }

    public abstract Frame getMainWindow();

    public abstract void updateUI();

    protected abstract Component createTopComponentManager(TopComponent var1);

    protected abstract TopComponent.Registry componentRegistry();

    public TopComponent.Registry getRegistry() {
        if (this.registry != null) {
            return this.registry;
        }
        WindowManager windowManager = this;
        synchronized (windowManager) {
            if (this.registry == null) {
                this.registry = this.componentRegistry();
            }
        }
        return this.registry;
    }

    public final Workspace createWorkspace(String name) {
        return this.createWorkspace(name, name);
    }

    public abstract Workspace createWorkspace(String var1, String var2);

    public abstract Workspace findWorkspace(String var1);

    public abstract Workspace[] getWorkspaces();

    public abstract void setWorkspaces(Workspace[] var1);

    public abstract Workspace getCurrentWorkspace();

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    protected static final Component findComponentManager(TopComponent tc) {
        return tc.getManager();
    }

    protected void activateComponent(TopComponent tc) {
        if (this.activeComponent == tc) {
            return;
        }
        if (this.activeComponent != null) {
            this.activeComponent.componentDeactivated();
        }
        this.activeComponent = tc;
        if (this.activeComponent != null) {
            this.activeComponent.componentActivated();
        }
    }

    protected void componentOpenNotify(TopComponent tc) {
        tc.componentOpened();
    }

    protected void componentCloseNotify(TopComponent tc) {
        tc.componentClosed();
    }

    protected void componentShowing(TopComponent tc) {
        tc.componentShowing();
    }

    protected void componentHidden(TopComponent tc) {
        tc.componentHidden();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static interface Component
    extends Serializable {
        public static final long serialVersionUID = 0L;

        public void open();

        public void open(Workspace var1);

        public void close(Workspace var1);

        public void requestFocus();

        public void requestVisible();

        public Node[] getActivatedNodes();

        public void setActivatedNodes(Node[] var1);

        public void nameChanged();

        public void setIcon(Image var1);

        public Image getIcon();

        public Set whereOpened();
    }
}

