/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.peer.MenuComponentPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;

public abstract class MenuComponent
implements Serializable {
    transient MenuComponentPeer peer;
    transient MenuContainer parent;
    transient AppContext appContext;
    Font font;
    private String name;
    private boolean nameExplicitlySet = false;
    boolean newEventsOnly = false;
    private volatile transient AccessControlContext acc = AccessController.getContext();
    static final String actionListenerK = "actionL";
    static final String itemListenerK = "itemL";
    private static final long serialVersionUID = -4536902356223894379L;
    AccessibleContext accessibleContext = null;

    final AccessControlContext getAccessControlContext() {
        if (this.acc == null) {
            throw new SecurityException("MenuComponent is missing AccessControlContext");
        }
        return this.acc;
    }

    public MenuComponent() throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.appContext = AppContext.getAppContext();
    }

    String constructComponentName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            MenuComponent menuComponent = this;
            synchronized (menuComponent) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = this.constructComponentName();
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        MenuComponent menuComponent = this;
        synchronized (menuComponent) {
            this.name = string;
            this.nameExplicitlySet = true;
        }
    }

    public MenuContainer getParent() {
        return this.getParent_NoClientCode();
    }

    final MenuContainer getParent_NoClientCode() {
        return this.parent;
    }

    @Deprecated
    public MenuComponentPeer getPeer() {
        return this.peer;
    }

    public Font getFont() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            return menuContainer.getFont();
        }
        return null;
    }

    final Font getFont_NoClientCode() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            if (menuContainer instanceof Component) {
                font = ((Component)menuContainer).getFont_NoClientCode();
            } else if (menuContainer instanceof MenuComponent) {
                font = ((MenuComponent)((Object)menuContainer)).getFont_NoClientCode();
            }
        }
        return font;
    }

    public void setFont(Font font) {
        this.font = font;
        MenuComponentPeer menuComponentPeer = this.peer;
        if (menuComponentPeer != null) {
            menuComponentPeer.setFont(font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuComponentPeer menuComponentPeer = this.peer;
            if (menuComponentPeer != null) {
                Toolkit.getEventQueue().removeSourceEvents(this, true);
                this.peer = null;
                menuComponentPeer.dispose();
            }
        }
    }

    @Deprecated
    public boolean postEvent(Event event) {
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            menuContainer.postEvent(event);
        }
        return false;
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        EventQueue.setCurrentEventAndMostRecentTime(aWTEvent);
        Toolkit.getDefaultToolkit().notifyAWTEventListeners(aWTEvent);
        if (this.newEventsOnly || this.parent != null && this.parent instanceof MenuComponent && ((MenuComponent)((Object)this.parent)).newEventsOnly) {
            if (this.eventEnabled(aWTEvent)) {
                this.processEvent(aWTEvent);
            } else if (aWTEvent instanceof ActionEvent && this.parent != null) {
                aWTEvent.setSource(this.parent);
                ((MenuComponent)((Object)this.parent)).dispatchEvent(aWTEvent);
            }
        } else {
            Event event = aWTEvent.convertToOld();
            if (event != null) {
                this.postEvent(event);
            }
        }
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        return false;
    }

    protected void processEvent(AWTEvent aWTEvent) {
    }

    protected String paramString() {
        String string = this.getName();
        return string != null ? string : "";
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    protected final Object getTreeLock() {
        return Component.LOCK;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.acc = AccessController.getContext();
        objectInputStream.defaultReadObject();
        this.appContext = AppContext.getAppContext();
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    int getAccessibleIndexInParent() {
        MenuContainer menuContainer = this.parent;
        if (!(menuContainer instanceof MenuComponent)) {
            return -1;
        }
        MenuComponent menuComponent = (MenuComponent)((Object)menuContainer);
        return menuComponent.getAccessibleChildIndex(this);
    }

    int getAccessibleChildIndex(MenuComponent menuComponent) {
        return -1;
    }

    AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
        return accessibleStateSet;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            MenuComponent.initIDs();
        }
        AWTAccessor.setMenuComponentAccessor(new AWTAccessor.MenuComponentAccessor(){

            @Override
            public AppContext getAppContext(MenuComponent menuComponent) {
                return menuComponent.appContext;
            }

            @Override
            public void setAppContext(MenuComponent menuComponent, AppContext appContext) {
                menuComponent.appContext = appContext;
            }

            @Override
            public MenuContainer getParent(MenuComponent menuComponent) {
                return menuComponent.parent;
            }

            @Override
            public Font getFont_NoClientCode(MenuComponent menuComponent) {
                return menuComponent.getFont_NoClientCode();
            }

            @Override
            public <T extends MenuComponentPeer> T getPeer(MenuComponent menuComponent) {
                return (T)menuComponent.peer;
            }
        });
    }

    protected abstract class AccessibleAWTMenuComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent,
    AccessibleSelection {
        private static final long serialVersionUID = -4269533416223798698L;

        protected AccessibleAWTMenuComponent() {
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public String getAccessibleName() {
            return this.accessibleName;
        }

        @Override
        public String getAccessibleDescription() {
            return this.accessibleDescription;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return MenuComponent.this.getAccessibleStateSet();
        }

        @Override
        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            MenuContainer menuContainer = MenuComponent.this.getParent();
            if (menuContainer instanceof Accessible) {
                return (Accessible)((Object)menuContainer);
            }
            return null;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return MenuComponent.this.getAccessibleIndexInParent();
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            return null;
        }

        @Override
        public Locale getLocale() {
            MenuContainer menuContainer = MenuComponent.this.getParent();
            if (menuContainer instanceof Component) {
                return ((Component)menuContainer).getLocale();
            }
            return Locale.getDefault();
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public Color getBackground() {
            return null;
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public Color getForeground() {
            return null;
        }

        @Override
        public void setForeground(Color color) {
        }

        @Override
        public Cursor getCursor() {
            return null;
        }

        @Override
        public void setCursor(Cursor cursor) {
        }

        @Override
        public Font getFont() {
            return MenuComponent.this.getFont();
        }

        @Override
        public void setFont(Font font) {
            MenuComponent.this.setFont(font);
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void setVisible(boolean bl) {
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public boolean contains(Point point) {
            return false;
        }

        @Override
        public Point getLocationOnScreen() {
            return null;
        }

        @Override
        public Point getLocation() {
            return null;
        }

        @Override
        public void setLocation(Point point) {
        }

        @Override
        public Rectangle getBounds() {
            return null;
        }

        @Override
        public void setBounds(Rectangle rectangle) {
        }

        @Override
        public Dimension getSize() {
            return null;
        }

        @Override
        public void setSize(Dimension dimension) {
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
        }

        @Override
        public int getAccessibleSelectionCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            return false;
        }

        @Override
        public void addAccessibleSelection(int n) {
        }

        @Override
        public void removeAccessibleSelection(int n) {
        }

        @Override
        public void clearAccessibleSelection() {
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }
}

