/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.alert;

import com.jrockit.mc.alert.AlertObject;
import com.jrockit.mc.alert.AlertPlugin;
import com.jrockit.mc.alert.Messages;
import com.jrockit.mc.ui.TableColumnSortManager;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class AlertDialog
extends TitleAreaDialog {
    public static final int DATE_COLUMN = 0;
    public static final int TIME_COLUMN = 1;
    public static final int RULE_COLUMN = 2;
    public static final int SOURCE_COLUMN = 3;
    private Button m_clearButton;
    private Text m_text;
    private TableViewer m_viewer;

    protected void createButtonsForButtonBar(Composite parent) {
        this.createPopupButton(parent);
        this.createClearButton(parent);
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    private void createPopupButton(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        final Button button = new Button(parent, 32);
        button.setText(Messages.AlertDialog_POP_UP_ON_ALERTS_TEXT);
        button.setSelection(AlertPlugin.getDefault().getPopup());
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (button != null && !button.isDisposed()) {
                    AlertPlugin.getDefault().setPopup(button.getSelection());
                }
            }
        });
    }

    protected void createClearButton(Composite parent) {
        this.m_clearButton = this.createButton(parent, 1024, Messages.AlertDialog_CLEAR_ALERTS_TEXT0, true);
        this.m_clearButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AlertPlugin.getDefault().clearNotificationEventLog();
                AlertDialog.this.m_text.setText("");
                AlertDialog.this.m_viewer.refresh();
            }
        });
    }

    public AlertDialog(Shell parentShell) {
        super(parentShell);
        this.setTitleImage(AlertPlugin.getDefault().getImage("AlertBanner"));
        this.setShellStyle(0x860 | AlertDialog.getDefaultOrientation() | 0x10 | 0x400);
        this.setBlockOnOpen(false);
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(Messages.AlertDialog_DIALOG_TITLE);
        this.getShell().setImage(UIPlugin.getDefault().getImage("alert_obj.png"));
        Control contents = super.createContents(parent);
        this.setTitle(Messages.AlertDialog_DIALOG_TITLE);
        this.setMessage(Messages.AlertDialog_DIALOG_MESSAGE);
        DisplayToolkit.placeDialogInCenter((Shell)this.getParentShell(), (Shell)this.getShell());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Control dialogArea = super.createDialogArea(parent);
        GridData gd = null;
        gd = new GridData(4, 4, true, true);
        Composite composite = new Composite((Composite)dialogArea, 0);
        composite.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 100;
        TableViewer viewer = this.createViewer(composite);
        viewer.getTable().setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, false);
        gd.heightHint = 100;
        this.m_text = this.createMessage(composite);
        this.m_text.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        viewer.refresh();
        return dialogArea;
    }

    private Text createMessage(Composite parent) {
        Text text = new Text(parent, 2634);
        return text;
    }

    public void select(AlertObject alertObject) {
        this.m_text.setText(alertObject.getMessage());
    }

    public TableViewer createViewer(Composite parent) {
        Table table = new Table(parent, 8456194);
        this.m_viewer = new TableViewer(table);
        table.setHeaderVisible(true);
        TableColumn tc1 = new TableColumn(table, 0);
        tc1.setText(Messages.AlertDialog_COLUMN_HEADER_DATE);
        tc1.setResizable(true);
        table.showColumn(tc1);
        TableColumn tc2 = new TableColumn(table, 0);
        tc2.setText(Messages.AlertDialog_COLUMN_HEADER_TIME);
        tc2.setResizable(true);
        table.showColumn(tc2);
        TableColumn tc3 = new TableColumn(table, 0);
        tc3.setText(Messages.AlertDialog_COLUMN_HEADER_RULE);
        tc3.setResizable(true);
        table.showColumn(tc3);
        TableColumn tc4 = new TableColumn(table, 0);
        tc4.setText(Messages.AlertDialog_COLUMN_HEADER_SOURCE);
        tc4.setResizable(true);
        table.showColumn(tc4);
        TableColumnSortManager tcsm = new TableColumnSortManager(this.m_viewer);
        tcsm.addColumn(tc1, 0, true);
        tcsm.addColumn(tc2, 1, true);
        tcsm.addColumn(tc3, 2, true);
        tcsm.addColumn(tc4, 3, true);
        TableLayout layout = new TableLayout();
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                if (ssel.size() >= 1) {
                    AlertDialog.this.select((AlertObject)ssel.getFirstElement());
                }
            }
        });
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, 60, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, 40, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(150, 150, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 100, false));
        this.m_viewer.setContentProvider((IContentProvider)new AlertContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new AlertLabelProvider());
        this.m_viewer.setInput((Object)this);
        this.m_viewer.getTable().setLayout((Layout)layout);
        this.m_viewer.getTable().layout(true);
        return this.m_viewer;
    }

    public void refreshAlertDialog() {
        Table table;
        if (this.m_viewer != null && (table = this.m_viewer.getTable()) != null && !table.isDisposed()) {
            table.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Table table = AlertDialog.this.m_viewer.getTable();
                    if (table != null && !table.isDisposed()) {
                        AlertDialog.this.m_viewer.refresh();
                    }
                }
            });
        }
    }

    public static class AlertContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return AlertPlugin.getDefault().getAlerts();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class AlertLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        public String getColumnText(Object element, int columnIndex) {
            String ret = null;
            if (element instanceof AlertObject) {
                AlertObject ao = (AlertObject)element;
                Date d = ao.getCreationTime();
                if (d != null) {
                    DateFormat df;
                    if (columnIndex == 0) {
                        df = DateFormat.getDateInstance(3);
                        ret = df.format(d);
                    }
                    if (columnIndex == 1) {
                        df = DateFormat.getTimeInstance(2);
                        ret = df.format(d);
                    }
                }
                if (columnIndex == 2) {
                    ret = String.valueOf(ao.getRule().getRulePath()) + "\\" + ao.getRule().getName();
                }
                if (columnIndex == 3) {
                    ret = ao.getConnectionHandle().getServerDescriptor().getDisplayName();
                }
                if (ret == null) {
                    ret = Messages.AlertDialog_UNKNOWN_DATA;
                }
            }
            return ret;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof AlertObject) {
                    AlertObject ao = (AlertObject)element;
                    if (ao.getException() != null) {
                        return UIPlugin.getDefault().getImage("jexception_obj.png");
                    }
                    return UIPlugin.getDefault().getImage("alert_obj.png");
                }
                return null;
            }
            return null;
        }

        public Color getForeground(Object element) {
            AlertObject ao;
            if (element instanceof AlertObject && (ao = (AlertObject)element).getException() != null) {
                return AlertDialog.this.m_viewer.getControl().getDisplay().getSystemColor(3);
            }
            return null;
        }

        public Color getBackground(Object element) {
            AlertObject ao;
            if (element instanceof AlertObject && (ao = (AlertObject)element).getException() != null) {
                return AlertDialog.this.m_viewer.getControl().getDisplay().getSystemColor(7);
            }
            return null;
        }
    }
}

