/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.windows;

import com.oracle.tools.packager.AbstractImageBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.windows.WinResources;
import com.oracle.tools.packager.windows.WindowsBundlerParam;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class WinAppBundler
extends AbstractImageBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(WinAppBundler.class.getName());
    public static final BundlerParamInfo<File> CONFIG_ROOT = new WindowsBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, map -> {
        File file = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)map), "windows");
        file.mkdirs();
        return file;
    }, (string, map) -> null);
    private static final String EXECUTABLE_NAME = "WinLauncher.exe";
    private static final String LIBRARY_NAME = "packager.dll";
    private static final String[] VS_VERS = new String[]{"100", "110", "120"};
    private static final String REDIST_MSVCR = "msvcrVS_VER.dll";
    private static final String REDIST_MSVCP = "msvcpVS_VER.dll";
    private static final String TOOL_ICON_SWAP = "IconSwap.exe";
    public static final BundlerParamInfo<URL> RAW_EXECUTABLE_URL = new WindowsBundlerParam<URL>(I18N.getString("param.raw-executable-url.name"), I18N.getString("param.raw-executable-url.description"), "win.launcher.url", URL.class, map -> WinResources.class.getResource(EXECUTABLE_NAME), (string, map) -> {
        try {
            return new URL((String)string);
        }
        catch (MalformedURLException malformedURLException) {
            Log.info(malformedURLException.toString());
            return null;
        }
    });
    public static final BundlerParamInfo<Boolean> REBRAND_EXECUTABLE = new WindowsBundlerParam<Boolean>(I18N.getString("param.rebrand-executable.name"), I18N.getString("param.rebrand-executable.description"), "win.launcher.rebrand", Boolean.class, map -> Boolean.TRUE, (string, map) -> Boolean.valueOf(string));
    public static final BundlerParamInfo<File> ICON_ICO = new StandardBundlerParam<File>(I18N.getString("param.icon-ico.name"), I18N.getString("param.icon-ico.description"), "icon.ico", File.class, map -> {
        File file = (File)StandardBundlerParam.ICON.fetchFrom((Map<String, Object>)map);
        if (file != null && !file.getName().toLowerCase().endsWith(".ico")) {
            Log.info(MessageFormat.format(I18N.getString("message.icon-not-ico"), file));
            return null;
        }
        return file;
    }, (string, map) -> new File((String)string));
    public static final String WIN_BUNDLER_PREFIX = "package/windows/";
    private static final String TEMPLATE_APP_ICON = "javalogo_white_48.ico";

    public WinAppBundler() {
        this.baseResourceLoader = WinResources.class;
    }

    File getConfigRoot(Map<String, ? super Object> map) {
        return CONFIG_ROOT.fetchFrom(map);
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            if (map == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            return this.doValidate(map);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    boolean doValidate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win")) {
            throw new UnsupportedPlatformException();
        }
        this.imageBundleValidation(map);
        if (WinResources.class.getResource(TOOL_ICON_SWAP) == null) {
            throw new ConfigException(I18N.getString("error.no-windows-resources"), I18N.getString("error.no-windows-resources.advice"));
        }
        this.testRuntime(WindowsBundlerParam.WIN_RUNTIME.fetchFrom(map), new String[]{"bin\\\\[^\\\\]+\\\\jvm.dll", "lib\\\\rt.jar"});
        if (((Boolean)StandardBundlerParam.USE_FX_PACKAGING.fetchFrom(map)).booleanValue()) {
            this.testRuntime(WindowsBundlerParam.WIN_RUNTIME.fetchFrom(map), new String[]{"lib\\\\ext\\\\jfxrt.jar", "lib\\\\jfxrt.jar"});
        }
        WinAppBundler.testRuntimeBitArchitecture(map);
        return true;
    }

    private static void testRuntimeBitArchitecture(Map<String, ? super Object> map) throws ConfigException {
        if ("true".equalsIgnoreCase(System.getProperty("fxpackager.disableBitArchitectureMismatchCheck"))) {
            Log.debug(I18N.getString("message.disable-bit-architecture-check"));
            return;
        }
        if (WindowsBundlerParam.BIT_ARCH_64.fetchFrom(map) != WindowsBundlerParam.BIT_ARCH_64_RUNTIME.fetchFrom(map) && !"systemjre".equals(map.get(".runtime.autodetect"))) {
            throw new ConfigException(I18N.getString("error.bit-architecture-mismatch"), I18N.getString("error.bit-architecture-mismatch.advice"));
        }
    }

    private static File getRootDir(File file, Map<String, ? super Object> map) {
        return new File(file, (String)StandardBundlerParam.APP_NAME.fetchFrom(map));
    }

    public static String getLauncherName(Map<String, ? super Object> map) {
        return (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".exe";
    }

    public static String getLauncherCfgName(Map<String, ? super Object> map) {
        return "app\\" + (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".cfg";
    }

    private File getConfig_AppIcon(Map<String, ? super Object> map) {
        return new File(this.getConfigRoot(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".ico");
    }

    protected void cleanupConfigFiles(Map<String, ? super Object> map) {
        this.getConfig_AppIcon(map).delete();
    }

    private void prepareConfigFiles(Map<String, ? super Object> map) throws IOException {
        File file = this.getConfig_AppIcon(map);
        File file2 = ICON_ICO.fetchFrom(map);
        if (file2 != null && file2.exists()) {
            this.fetchResource(WIN_BUNDLER_PREFIX + file.getName(), I18N.getString("resource.application-icon"), file2, file, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        } else {
            this.fetchResource(WIN_BUNDLER_PREFIX + file.getName(), I18N.getString("resource.application-icon"), TEMPLATE_APP_ICON, file, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        }
    }

    public boolean bundle(Map<String, ? super Object> map, File file) {
        return this.doBundle(map, file, false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File doBundle(Map<String, ? super Object> map, File file, boolean bl) {
        File file2;
        block13: {
            block11: {
                HashMap<String, ? super Object> hashMap = new HashMap<String, Object>(map);
                if (!file.isDirectory() && !file.mkdirs()) {
                    throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
                }
                if (!file.canWrite()) {
                    throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
                }
                try {
                    if (!bl) {
                        Log.info(MessageFormat.format(I18N.getString("message.creating-app-bundle"), StandardBundlerParam.APP_NAME.fetchFrom(map), file.getAbsolutePath()));
                    }
                    File file3 = WinAppBundler.getRootDir(file, map);
                    IOUtils.deleteRecursive(file3);
                    file3.mkdirs();
                    File file4 = new File(file3, "app");
                    file4.mkdirs();
                    this.createLauncherForEntryPoint(map, file3);
                    this.copyApplication(map, file4);
                    File file5 = new File(file3, "runtime");
                    this.copyRuntime(map, file5);
                    IOUtils.copyFromURL(WinResources.class.getResource(LIBRARY_NAME), new File(file3, LIBRARY_NAME));
                    this.copyMSVCDLLs(file3, file5);
                    List list = (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(map);
                    for (Map map2 : list) {
                        HashMap<String, ? super Object> hashMap2 = new HashMap<String, Object>(hashMap);
                        hashMap2.putAll(map2);
                        this.createLauncherForEntryPoint(hashMap2, file3);
                    }
                    if (!bl) {
                        Log.info(MessageFormat.format(I18N.getString("message.result-dir"), file.getAbsolutePath()));
                    }
                    file2 = file3;
                    if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) break block11;
                }
                catch (IOException iOException) {
                    File file6;
                    block14: {
                        block12: {
                            try {
                                Log.info("Exception: " + iOException);
                                Log.debug(iOException);
                                file6 = null;
                                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) break block12;
                            }
                            catch (Throwable throwable) {
                                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), this.getConfigRoot(map).getAbsolutePath()));
                                } else {
                                    this.cleanupConfigFiles(map);
                                }
                                throw throwable;
                            }
                            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), this.getConfigRoot(map).getAbsolutePath()));
                            break block14;
                        }
                        this.cleanupConfigFiles(map);
                    }
                    return file6;
                }
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), this.getConfigRoot(map).getAbsolutePath()));
                break block13;
            }
            this.cleanupConfigFiles(map);
        }
        return file2;
    }

    private void copyMSVCDLLs(File file, File file2) throws IOException {
        String string = null;
        if (file2 == null || !file2.isDirectory()) {
            file2 = new File(System.getProperty("java.home"));
        }
        for (String string2 : VS_VERS) {
            if (!this.copyMSVCDLLs(file, string2)) continue;
            string = string2;
            break;
        }
        if (string == null) {
            throw new RuntimeException("Not found MSVC dlls");
        }
        AtomicReference atomicReference = new AtomicReference();
        String string3 = string;
        Files.list(file2.toPath().resolve("bin")).filter(path -> Pattern.matches("msvc(r|p)\\d\\d\\d.dll", path.toFile().getName().toLowerCase())).filter(path -> !path.toString().toLowerCase().endsWith(string3 + ".dll")).forEach(path -> {
            try {
                IOUtils.copyFile(path.toFile(), new File(file, path.toFile().getName()));
            }
            catch (IOException iOException) {
                atomicReference.set(iOException);
            }
        });
        IOException iOException = (IOException)atomicReference.get();
        if (iOException != null) {
            throw iOException;
        }
    }

    private boolean copyMSVCDLLs(File file, String string) throws IOException {
        URL uRL = WinResources.class.getResource(REDIST_MSVCR.replaceAll("VS_VER", string));
        URL uRL2 = WinResources.class.getResource(REDIST_MSVCP.replaceAll("VS_VER", string));
        if (uRL != null && uRL2 != null) {
            IOUtils.copyFromURL(uRL, new File(file, REDIST_MSVCR.replaceAll("VS_VER", string)));
            IOUtils.copyFromURL(uRL2, new File(file, REDIST_MSVCP.replaceAll("VS_VER", string)));
            return true;
        }
        return false;
    }

    private void createLauncherForEntryPoint(Map<String, ? super Object> map, File file) throws IOException {
        this.prepareConfigFiles(map);
        if (((String)LAUNCHER_CFG_FORMAT.fetchFrom(map)).equals("prop")) {
            this.writeCfgFile(map, file);
        } else {
            this.writeCfgFile(map, new File(file, WinAppBundler.getLauncherCfgName(map)), this.getRuntimeLocation(map));
        }
        File file2 = new File(file, WinAppBundler.getLauncherName(map));
        IOUtils.copyFromURL(RAW_EXECUTABLE_URL.fetchFrom(map), file2);
        file2.setExecutable(true, false);
        if (REBRAND_EXECUTABLE.fetchFrom(map).booleanValue() && this.getConfig_AppIcon(map).exists()) {
            File file3 = File.createTempFile("iconswap", ".exe");
            file3.delete();
            IOUtils.copyFromURL(WinResources.class.getResource(TOOL_ICON_SWAP), file3);
            file3.setExecutable(true, false);
            file3.deleteOnExit();
            file2.setWritable(true);
            ProcessBuilder processBuilder = new ProcessBuilder(file3.getAbsolutePath(), this.getConfig_AppIcon(map).getAbsolutePath(), file2.getAbsolutePath());
            IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            file2.setReadOnly();
            file3.delete();
        }
        IOUtils.copyFile(this.getConfig_AppIcon(map), new File(file, (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".ico"));
    }

    private void copyApplication(Map<String, ? super Object> map, File file) throws IOException {
        List list = (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(map);
        if (list == null) {
            throw new RuntimeException("Null app resources?");
        }
        for (RelativeFileSet relativeFileSet : list) {
            if (relativeFileSet == null) {
                throw new RuntimeException("Null app resources?");
            }
            File file2 = relativeFileSet.getBaseDirectory();
            for (String string : relativeFileSet.getIncludedFiles()) {
                IOUtils.copyFile(new File(file2, string), new File(file, string));
            }
        }
    }

    private String getRuntimeLocation(Map<String, ? super Object> map) {
        if (WindowsBundlerParam.WIN_RUNTIME.fetchFrom(map) == null) {
            return "";
        }
        return "$APPDIR\\runtime";
    }

    private void writeCfgFile(Map<String, ? super Object> map, File file) throws FileNotFoundException {
        Map.Entry entry2;
        Object object222;
        File file2 = new File(file, WinAppBundler.getLauncherCfgName(map));
        file2.delete();
        PrintStream printStream = new PrintStream(file2);
        printStream.println("app.runtime=" + this.getRuntimeLocation(map));
        printStream.println("app.mainjar=" + ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(map)).getIncludedFiles().iterator().next());
        printStream.println("app.version=" + (String)StandardBundlerParam.VERSION.fetchFrom(map));
        printStream.println("app.id=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(map));
        printStream.println("app.preferences.id=" + (String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(map));
        printStream.println("app.identifier=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(map));
        printStream.println("app.mainclass=" + ((String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map)).replaceAll("\\.", "/"));
        printStream.println("app.classpath=" + (String)StandardBundlerParam.CLASSPATH.fetchFrom(map));
        List list = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(map);
        int n = 1;
        for (Object object222 : list) {
            printStream.println("jvmarg." + n + "=" + (String)object222);
            ++n;
        }
        Map map2 = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(map);
        for (Map.Entry object3 : map2.entrySet()) {
            printStream.println("jvmarg." + n + "=-D" + (String)object3.getKey() + "=" + (String)object3.getValue());
            ++n;
        }
        object222 = (String)StandardBundlerParam.PRELOADER_CLASS.fetchFrom(map);
        if (object222 != null) {
            printStream.println("jvmarg." + n + "=-Djavafx.preloader=" + (String)object222);
        }
        Map map3 = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(map);
        n = 1;
        for (Map.Entry entry2 : map3.entrySet()) {
            if (entry2.getKey() == null || entry2.getValue() == null) {
                Log.info(I18N.getString("message.jvm-user-arg-is-null"));
            } else {
                printStream.println("jvmuserarg." + n + ".name=" + (String)entry2.getKey());
                printStream.println("jvmuserarg." + n + ".value=" + (String)entry2.getValue());
            }
            ++n;
        }
        List list2 = (List)StandardBundlerParam.ARGUMENTS.fetchFrom(map);
        n = 1;
        entry2 = list2.iterator();
        while (entry2.hasNext()) {
            String string = (String)entry2.next();
            printStream.println("arg." + n + "=" + string);
            ++n;
        }
        printStream.close();
    }

    private void copyRuntime(Map<String, ? super Object> map, File file) throws IOException {
        RelativeFileSet relativeFileSet = WindowsBundlerParam.WIN_RUNTIME.fetchFrom(map);
        if (relativeFileSet == null) {
            return;
        }
        file.mkdirs();
        File file2 = relativeFileSet.getBaseDirectory();
        Set<String> set = relativeFileSet.getIncludedFiles();
        for (String string : set) {
            IOUtils.copyFile(new File(file2, string), new File(file, string));
        }
    }

    @Override
    public void extractRuntimeFlags(Map<String, ? super Object> map) {
        WinAppBundler.extractFlagsFromRuntime(map);
    }

    public static void extractFlagsFromRuntime(Map<String, ? super Object> map) {
        if (map.containsKey(".runtime.autodetect")) {
            return;
        }
        map.put(".runtime.autodetect", "attempted");
        RelativeFileSet relativeFileSet = WindowsBundlerParam.WIN_RUNTIME.fetchFrom(map);
        if (relativeFileSet == null) {
            map.put(".runtime.autodetect", "systemjre");
        } else {
            String string;
            File file = relativeFileSet.getBaseDirectory();
            File file2 = new File(file, "bin\\java");
            ProcessBuilder processBuilder = new ProcessBuilder(file2.getAbsolutePath(), "-version");
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                try (PrintStream printStream = new PrintStream(byteArrayOutputStream);){
                    IOUtils.exec(processBuilder, Log.isDebug(), true, printStream);
                }
                string = byteArrayOutputStream.toString();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                map.put(".runtime.autodetect", "failed");
                return;
            }
            AbstractImageBundler.extractFlagsFromVersion(map, string);
            map.put(".runtime.autodetect", "succeeded");
        }
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "windows.app";
    }

    @Override
    public String getBundleType() {
        return "IMAGE";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return WinAppBundler.getAppBundleParameters();
    }

    public static Collection<BundlerParamInfo<?>> getAppBundleParameters() {
        return Arrays.asList(StandardBundlerParam.APP_NAME, StandardBundlerParam.APP_RESOURCES, StandardBundlerParam.ARGUMENTS, StandardBundlerParam.CLASSPATH, ICON_ICO, StandardBundlerParam.JVM_OPTIONS, StandardBundlerParam.JVM_PROPERTIES, StandardBundlerParam.MAIN_CLASS, StandardBundlerParam.MAIN_JAR, StandardBundlerParam.PREFERENCES_ID, StandardBundlerParam.PRELOADER_CLASS, StandardBundlerParam.USER_JVM_OPTIONS, StandardBundlerParam.VERSION, WindowsBundlerParam.WIN_RUNTIME);
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.doBundle(map, file, false);
    }

    @Override
    protected String getCacheLocation(Map<String, ? super Object> map) {
        return "$CACHEDIR/";
    }
}

