/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.util.TimeRangeToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLAttributeInstance;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTagInstance;
import java.util.regex.Pattern;

public class TimeRangeHackJMC2809Toolkit {
    private static final Pattern INCOMPATIBLE_MINUTE_UNIT_FROM_JFC = Pattern.compile("^\\d([\\d.,\\s]*\\d)?\\s*m$");
    private static final String VALID_MINUTE_SUFFIX = "in";

    static boolean isTimespan(XMLTagInstance tagInstance) {
        for (XMLAttributeInstance attribute : tagInstance.getAttributeInstances()) {
            if (!"timespan".equals(attribute.getValue()) && !"threshold".equals(attribute.getValue()) && !"period".equals(attribute.getValue())) continue;
            return true;
        }
        return false;
    }

    static String patchMinuteUnitFromJFCIfTimespan(XMLTagInstance tagInstance, String tagContent) {
        if (TimeRangeHackJMC2809Toolkit.isTimespan(tagInstance) && INCOMPATIBLE_MINUTE_UNIT_FROM_JFC.matcher(tagContent).matches()) {
            return String.valueOf(tagContent) + VALID_MINUTE_SUFFIX;
        }
        return tagContent;
    }

    static String patchTimeSpanForJFCIfTimespan(XMLTagInstance tagInstance, String content) {
        if (TimeRangeHackJMC2809Toolkit.isTimespan(tagInstance)) {
            try {
                return TimeRangeToolkit.standardizeFormat((String)content, (TimeRangeToolkit.Format)TimeRangeToolkit.Format.JFR_OPTIONS, (boolean)false);
            }
            catch (QuantityConversionException quantityConversionException) {
                // empty catch block
            }
        }
        return content;
    }
}

