/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.threads;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.console.ui.tabs.threads.IThreadsModel;
import com.jrockit.mc.console.ui.tabs.threads.ThreadInfoCompositeSupport;
import com.jrockit.mc.console.ui.tabs.threads.ThreadModelException;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.IVirtualMachineService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.AttributeValueToolkit;
import com.jrockit.mc.ui.polling.PollManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.eclipse.jface.util.IPropertyChangeListener;

public class ThreadsModel
implements IThreadsModel {
    private static final String THREAD_OBJECT_NAME = "java.lang:type=Threading";
    private static final String THREAD_ALL_THREAD_IDS = "AllThreadIds";
    private static final String THREAD_FIND_DEADLOCKED_THREADS = "findDeadlockedThreads";
    private static final String THREAD_FIND_MONITOR_DEADLOCKED_THREADS = "findMonitorDeadlockedThreads";
    private static final String THREAD_GET_THREAD_INFO = "getThreadInfo";
    private static final String[] THREAD_ALL_THREAD_IDS_SIGNATURE = new String[]{"[J"};
    private static final String[] THREAD_GET_THREADS_INFO_WITH_STACKTRACES_SIGNATURE = new String[]{"[J", "int"};
    private final PollManager m_pollManager = new PollManager(3000, "console.ui.threaddump.update.interval.");
    private final IConnectionHandle m_connectionHandle;
    private volatile boolean m_cpuTimeEnabled;
    private volatile boolean m_findDeadlocked;
    private boolean m_useMonitoredDeadlockedThreads = false;
    private volatile ThreadInfoCompositeSupport[] m_threads;
    private int m_numberOfCPUs = -1;
    private final Map<Long, CPUSample> m_cpuSampleTimes = new HashMap<Long, CPUSample>();
    private boolean m_allocationEnabled;

    public ThreadsModel(IConnectionHandle connectionHandle) {
        ConsolePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.m_pollManager);
        this.m_connectionHandle = connectionHandle;
    }

    @Override
    public void dispose() {
        ConsolePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.m_pollManager);
        this.m_pollManager.stop();
    }

    @Override
    public void setDeadlockDetectionEnabled(boolean findDeadlocked) {
        if (findDeadlocked != this.m_findDeadlocked) {
            this.m_findDeadlocked = findDeadlocked;
            this.getPollManager().poll();
        }
    }

    @Override
    public boolean isDeadlockeDetectionEnabled() {
        return this.m_findDeadlocked;
    }

    @Override
    public PollManager getPollManager() {
        return this.m_pollManager;
    }

    private ObjectName getThreadMxBean() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(THREAD_OBJECT_NAME);
    }

    @Override
    public int getNumberOfCPUs() {
        MRI attr;
        Object result;
        if (this.m_numberOfCPUs == -1 && (result = this.getAttribute(attr = new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=OperatingSystem", "AvailableProcessors"))) instanceof Number) {
            this.m_numberOfCPUs = ((Number)result).intValue();
        }
        return this.m_numberOfCPUs;
    }

    @Override
    public ThreadInfoCompositeSupport[] getAllThreadIds() {
        return this.m_threads;
    }

    private void addCPUInformation(ThreadInfoCompositeSupport[] tips) throws ThreadModelException {
        if (this.isCPUTimeEnabled()) {
            int cpuCores = this.getNumberOfCPUs();
            long[] threadIDs = ThreadsModel.toIDArray(tips);
            long[] cpuTimes = null;
            try {
                cpuTimes = ((IVirtualMachineService)this.m_connectionHandle.getServiceOrThrow(IVirtualMachineService.class)).getThreadCpuTime(threadIDs);
            }
            catch (Exception e) {
                this.setCPUTimeEnabled(false);
                throw new ThreadModelException(Messages.ThreadsModel_EXCEPTION_CPU_TIME_NOT_AVAILABLE_MESSAGE, e);
            }
            int n = 0;
            while (n < tips.length) {
                if (cpuCores > 0) {
                    tips[n].setCPUTime(this.calculateCPUTime(tips[n].getThreadId(), cpuTimes[n], cpuCores));
                } else {
                    tips[n].setCPUTime(-477623.0);
                }
                ++n;
            }
        }
    }

    @Override
    public void setAllocationEnabled(boolean enabled) {
        this.m_allocationEnabled = enabled;
        this.getPollManager().poll();
    }

    @Override
    public boolean isAllocationEnabled() {
        return this.m_allocationEnabled;
    }

    @Override
    public void setCPUTimeEnabled(boolean enabled) {
        this.m_cpuSampleTimes.clear();
        this.m_cpuTimeEnabled = enabled;
        this.getPollManager().poll();
    }

    @Override
    public boolean isCPUTimeEnabled() {
        return this.m_cpuTimeEnabled;
    }

    private double calculateCPUTime(Long threadId, long cpuTime, int cpus) {
        long wallClockTime = System.currentTimeMillis() * 1000L * 1000L;
        if (cpuTime != -1L) {
            CPUSample last = this.m_cpuSampleTimes.get(threadId);
            if (last == null) {
                CPUSample sample = new CPUSample();
                sample.time = wallClockTime;
                sample.value = cpuTime;
                this.m_cpuSampleTimes.put(threadId, sample);
                return Double.NEGATIVE_INFINITY;
            }
            double cpuTimeDiff = cpuTime - last.value;
            long wallClockDiff = wallClockTime - last.time;
            last.value = cpuTime;
            last.time = wallClockTime;
            return wallClockDiff > 0L ? cpuTimeDiff / (double)((long)cpus * wallClockDiff) : Double.NEGATIVE_INFINITY;
        }
        return -456236.0;
    }

    private Object getAttribute(String mBean, String attributeName) {
        return this.getAttribute(new MRI(MRI.Type.ATTRIBUTE, mBean, attributeName));
    }

    private Object getAttribute(MRI descriptor) {
        MBeanServerConnection connection;
        block3: {
            try {
                connection = (MBeanServerConnection)this.m_connectionHandle.getServiceOrNull(MBeanServerConnection.class);
                if (connection != null) break block3;
                return null;
            }
            catch (Exception e) {
                ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Error when getting information from ThreadMxBean.", e);
                return null;
            }
        }
        return AttributeValueToolkit.getAttribute((MBeanServerConnection)connection, (MRI)descriptor);
    }

    private Object invoke(String mBean, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, ReflectionException {
        block7: {
            if (this.m_connectionHandle.isConnected()) break block7;
            return null;
        }
        try {
            return ((MBeanServerConnection)this.m_connectionHandle.getServiceOrDummy(MBeanServerConnection.class)).invoke(new ObjectName(mBean), operationName, params, signature);
        }
        catch (MalformedObjectNameException e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
        catch (MBeanException e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
        catch (NullPointerException e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
        catch (IOException e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
        catch (JMRuntimeException e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
        return null;
    }

    private void addDeadlockInformation(ThreadInfoCompositeSupport[] tips) throws ThreadModelException {
        if (this.isDeadlockeDetectionEnabled()) {
            Object deadLockedIds = null;
            try {
                deadLockedIds = this.m_useMonitoredDeadlockedThreads ? this.invoke(THREAD_OBJECT_NAME, THREAD_FIND_MONITOR_DEADLOCKED_THREADS, new Object[0], new String[0]) : this.invoke(THREAD_OBJECT_NAME, THREAD_FIND_DEADLOCKED_THREADS, new Object[0], new String[0]);
            }
            catch (InstanceNotFoundException e) {
                this.setDeadlockDetectionEnabled(false);
                throw new ThreadModelException(Messages.ThreadsModel_EXCEPTION_NO_DEADLOCK_DETECTION_AVAILABLE_MESSAGE, e);
            }
            catch (ReflectionException e) {
                if (!this.m_useMonitoredDeadlockedThreads) {
                    this.m_useMonitoredDeadlockedThreads = true;
                    this.addDeadlockInformation(tips);
                    return;
                }
                ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
                deadLockedIds = null;
            }
            long[] deadlocked = null;
            deadlocked = deadLockedIds instanceof long[] ? (long[])deadLockedIds : new long[]{};
            ThreadInfoCompositeSupport[] threadInfoCompositeSupportArray = tips;
            int n = tips.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadInfoCompositeSupport tip = threadInfoCompositeSupportArray[n2];
                if (tip != null) {
                    tip.setDeadlocked(Boolean.FALSE);
                    long[] lArray = deadlocked;
                    int n3 = deadlocked.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        long element = lArray[n4];
                        Long l = tip.getThreadId();
                        if (l != null && l == element) {
                            tip.setDeadlocked(Boolean.TRUE);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean isUsingMonitoredThreadlockedThreads() {
        return this.m_useMonitoredDeadlockedThreads;
    }

    private void addAllocationInformation(ThreadInfoCompositeSupport[] tips) throws ThreadModelException {
        if (this.isAllocationEnabled()) {
            long[] allocs;
            long[] ids = ThreadsModel.toIDArray(tips);
            try {
                allocs = ((IVirtualMachineService)this.m_connectionHandle.getServiceOrDummy(IVirtualMachineService.class)).getThreadAllocatedBytes(ids);
            }
            catch (Exception e) {
                this.setAllocationEnabled(false);
                throw new ThreadModelException(Messages.ThreadsModel_EXCEPTION_NO_ALLOCATION_AVAILABLE_MESSAGE, e);
            }
            int n = 0;
            while (n < tips.length) {
                if (tips[n] != null) {
                    tips[n].setAllocatedBytes(allocs[n]);
                }
                ++n;
            }
        }
    }

    private static long[] toIDArray(ThreadInfoCompositeSupport[] tips) {
        long[] ids = new long[tips.length];
        int i = 0;
        while (i < tips.length) {
            if (tips[i] != null) {
                ids[i] = tips[i].getThreadId();
            }
            ++i;
        }
        return ids;
    }

    @Override
    public ThreadInfoCompositeSupport[] getThreadInfo(long[] threadIDArray, Integer depth) throws ThreadModelException {
        CompositeData[] object;
        Object[] params = new Object[]{threadIDArray, depth};
        CompositeData[] cdArray = object = this.getThreadInfos(params, THREAD_GET_THREADS_INFO_WITH_STACKTRACES_SIGNATURE);
        ThreadInfoCompositeSupport[] threadInfoWithStackTrace = new ThreadInfoCompositeSupport[cdArray.length];
        ArrayList<ThreadInfoCompositeSupport> result = new ArrayList<ThreadInfoCompositeSupport>();
        int n = 0;
        while (n < threadInfoWithStackTrace.length) {
            if (cdArray[n] != null) {
                result.add(new ThreadInfoCompositeSupport(cdArray[n]));
            }
            ++n;
        }
        ThreadInfoCompositeSupport[] threadInfoCompositeSupport = new ThreadInfoCompositeSupport[result.size()];
        result.toArray(threadInfoCompositeSupport);
        this.addDeadlockInformation(threadInfoCompositeSupport);
        this.addCPUInformation(threadInfoCompositeSupport);
        this.addAllocationInformation(threadInfoCompositeSupport);
        return threadInfoCompositeSupport;
    }

    @Override
    public void resetThreadMax() {
        Object[] params = new Object[]{};
        String[] siganture = new String[]{};
        try {
            ((MBeanServerConnection)this.m_connectionHandle.getServiceOrDummy(MBeanServerConnection.class)).invoke(this.getThreadMxBean(), "resetPeakThreadCount", params, siganture);
        }
        catch (Exception e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
        }
    }

    @Override
    public void update() throws ThreadModelException {
        Object[] params;
        CompositeData[] objectInfos;
        Object result1 = this.getAttribute(THREAD_OBJECT_NAME, THREAD_ALL_THREAD_IDS);
        if (result1 instanceof long[] && (objectInfos = this.getThreadInfos(params = new Object[]{result1}, THREAD_ALL_THREAD_IDS_SIGNATURE)) != null) {
            ArrayList<ThreadInfoCompositeSupport> tList = new ArrayList<ThreadInfoCompositeSupport>(objectInfos.length);
            CompositeData[] compositeDataArray = objectInfos;
            int n = objectInfos.length;
            int n2 = 0;
            while (n2 < n) {
                CompositeData objectInfo = compositeDataArray[n2];
                if (objectInfo != null) {
                    tList.add(new ThreadInfoCompositeSupport(objectInfo));
                }
                ++n2;
            }
            ThreadInfoCompositeSupport[] tips = new ThreadInfoCompositeSupport[tList.size()];
            tList.toArray(tips);
            this.m_threads = tips;
            this.addDeadlockInformation(tips);
            this.addCPUInformation(tips);
            this.addAllocationInformation(tips);
        }
    }

    private CompositeData[] getThreadInfos(Object[] params, String[] signature) throws ThreadModelException {
        Object result2;
        try {
            result2 = this.invoke(THREAD_OBJECT_NAME, THREAD_GET_THREAD_INFO, params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new ThreadModelException(Messages.ThreadsModel_EXCEPTION_NO_THREAD_INFO_MESSAGE, e);
        }
        catch (ReflectionException e) {
            ConsolePlugin.getDefault().getLogger().log(Level.SEVERE, "Error when getting information from ThreadMxBean.", e);
            result2 = null;
        }
        catch (SecurityException e) {
            throw new ThreadModelException(e.getLocalizedMessage(), e);
        }
        if (result2 instanceof CompositeData[]) {
            return (CompositeData[])result2;
        }
        throw new ThreadModelException(Messages.ThreadsModel_EXCEPTION_NO_THREAD_INFO_MESSAGE);
    }

    @Override
    public boolean isConnected() {
        return this.m_connectionHandle.isConnected();
    }

    private static class CPUSample {
        public long time;
        public long value;

        private CPUSample() {
        }
    }
}

