/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import oracle.jvm.hotspot.jfr.JFRDebug;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;

public class JFRThreadBuffer {
    Address buffer;
    Address start;
    Address top;
    Address end;
    Address pos;
    Address used;

    public JFRThreadBuffer(Address addr) {
        this.buffer = addr;
        long addressSize = VM.getVM().getAddressSize();
        this.start = this.buffer.getAddressAt(2L * addressSize);
        this.top = this.buffer.getAddressAt(3L * addressSize);
        this.pos = this.buffer.getAddressAt(4L * addressSize);
        this.end = this.buffer.getAddressAt(5L * addressSize);
        this.used = this.buffer.getAddressAt(6L * addressSize);
        if (JFRDebug.SA_JFR_DEBUG) {
            System.out.println("JFRThreadBuffer(): start=" + this.start + ", top= " + this.top + ", end= " + this.end + ", pos= " + this.pos);
        }
    }

    public Address getStart() {
        return this.start;
    }

    public Address getTop() {
        return this.top;
    }

    public byte[] getBytesAtTop() {
        int size = (int)this.usedSize();
        byte[] buffer = new byte[size];
        for (int i = 0; i < size; ++i) {
            buffer[i] = this.top.getJByteAt(i);
        }
        return buffer;
    }

    public Address getEnd() {
        return this.end;
    }

    public Address getPos() {
        return this.pos;
    }

    public long usedSize() {
        return this.pos.minus(this.top);
    }

    public void resetBuffer() {
        this.top = this.start;
        this.pos = this.start;
    }
}

