/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFRStreamWriter;
import oracle.jvm.hotspot.jfr.ThreadGroupEntry;
import oracle.jvm.hotspot.jfr.TraceTypes;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.StaticBaseConstructor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.GrowableArray;

public class ThreadGroupIDs
extends VMObject {
    private static AddressField listField;
    private static StaticBaseConstructor ThreadGroupEntryConstructor;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ThreadGroupIDs");
        listField = type.getAddressField("_list");
    }

    public ThreadGroupIDs(Address addr) {
        super(addr);
    }

    public GrowableArray<ThreadGroupEntry> list() {
        Address listAddress = listField.getValue(this.addr);
        return GrowableArray.create(listAddress, ThreadGroupEntryConstructor);
    }

    void writeThreadGroupEntries(JFRStreamWriter writer) {
        GrowableArray<ThreadGroupEntry> list = this.list();
        int number_of_tg_entries = list.length();
        writer.write(TraceTypes.CONTENT_TYPE_THREADGROUP);
        writer.write(number_of_tg_entries);
        for (int index = 0; index < number_of_tg_entries; ++index) {
            ThreadGroupEntry curtge = list.at(index);
            writer.write(curtge.threadGroupID());
            writer.write(curtge.parentGID());
            writer.writeString(curtge.threadGroupName());
        }
    }

    static {
        ThreadGroupEntryConstructor = new StaticBaseConstructor<ThreadGroupEntry>(ThreadGroupEntry.class);
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ThreadGroupIDs.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

