/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.operativeset.menus;

import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.common.Toolkit;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.AddMatchingRelationalKeyAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.AddMatchingThreadAction;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.FieldFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;

class RelatedEventsMenu
extends MenuManager
implements IMenuListener {
    private final OperativeSetService oss;

    public RelatedEventsMenu(OperativeSetService oss) {
        super(Messages.OPERATIVE_SET_ADD_RELATED_EVENTS_TEXT);
        this.setRemoveAllWhenShown(true);
        this.addMenuListener(this);
        this.oss = oss;
    }

    public void menuAboutToShow(IMenuManager manager) {
        HashSet<IMCThread> threads = new HashSet<IMCThread>();
        HashMap<String, RelationalKeyGroup> groups = new HashMap<String, RelationalKeyGroup>();
        for (IEvent e : this.oss.getEventFactory()) {
            for (IField f : e.getEventType().getFields()) {
                String relKey = f.getRelationalKey();
                if (relKey == null) continue;
                RelationalKeyGroup relKeyGroup = (RelationalKeyGroup)groups.get(relKey);
                if (relKeyGroup == null) {
                    relKeyGroup = new RelationalKeyGroup();
                    groups.put(relKey, relKeyGroup);
                }
                relKeyGroup.addEvent(e, f);
            }
            IMCThread thread = (IMCThread)e.getValue("(thread)");
            if (thread == null) continue;
            threads.add(thread);
        }
        IMCThread firstThread = null;
        boolean moreThanOneThread = false;
        Iterator it = threads.iterator();
        while (!moreThanOneThread && it.hasNext()) {
            if (firstThread == null) {
                firstThread = (IMCThread)it.next();
                continue;
            }
            boolean bl = moreThanOneThread = it.next() != null;
        }
        if (firstThread == null) {
            this.add((IAction)new AddMatchingThreadAction(this.oss, null, NLS.bind((String)Messages.OPERATIVE_SET_WITHOUT_ASSOCIATED, (Object)"(thread)")));
        } else {
            this.add((IAction)new AddMatchingThreadAction(this.oss, new HashSet<IMCThread>(Arrays.asList(firstThread)), RelatedEventsMenu.formatWithActionText(moreThanOneThread, "(thread)", firstThread)));
            if (moreThanOneThread) {
                this.add((IAction)new AddMatchingThreadAction(this.oss, threads, NLS.bind((String)Messages.OPERATIVE_SET_ALL_IN_SELECTION, (Object)"(thread)")));
            }
        }
        for (Map.Entry groupItem : groups.entrySet()) {
            this.add((IContributionItem)new Separator());
            String relKey = (String)groupItem.getKey();
            RelationalKeyGroup group = (RelationalKeyGroup)groupItem.getValue();
            String relKeyTitle = group.buildTitle();
            boolean moreThanOneValue = group.values.size() > 1;
            this.add((IAction)new AddMatchingRelationalKeyAction(this.oss, relKey, group.firstValue, RelatedEventsMenu.formatWithActionText(moreThanOneValue, relKeyTitle, group.firstValueString)));
            if (!moreThanOneValue) continue;
            this.add((IAction)new AddMatchingRelationalKeyAction(this.oss, relKey, group.values, NLS.bind((String)Messages.OPERATIVE_SET_ALL_IN_SELECTION, (Object)relKeyTitle)));
        }
    }

    private static String formatWithActionText(boolean moreThanOne, Object name, Object value) {
        return String.valueOf(NLS.bind((String)Messages.OPERATIVE_SET_WITH_VALUE, (Object)name, (Object)value)) + (moreThanOne ? " (" + Messages.OPERATIVE_SET_FIRST_IN_SELECTION + ")" : "");
    }

    private static class RelationalKeyGroup {
        Object firstValue;
        String firstValueString;
        Set<Object> values = new HashSet<Object>();
        Set<String> titleItems = new HashSet<String>();

        private RelationalKeyGroup() {
        }

        void addEvent(IEvent e, IField f) {
            Object value = f.getValue(e);
            if (this.firstValue == null) {
                this.firstValue = value;
                this.firstValueString = RelationalKeyGroup.formatObject(f, value);
            }
            this.values.add(value);
            this.titleItems.add(f.getName());
        }

        String buildTitle() {
            StringBuilder titleBuilder = new StringBuilder();
            Iterator<String> it = this.titleItems.iterator();
            while (it.hasNext()) {
                titleBuilder.append(it.next());
                if (!it.hasNext()) continue;
                titleBuilder.append(" / ");
            }
            return titleBuilder.toString();
        }

        private static String formatObject(IField retriever, Object matchObject) {
            Field field = FieldFactory.createFromDisplayUnitWithIndexIdentifier((UnitDescriptor)Toolkit.createUnit(retriever), (String)retriever.getIdentifier(), (int)0);
            String matchString = field.formatObject(matchObject);
            return matchString.length() < 40 ? matchString : String.valueOf(matchString.substring(0, 38)) + "...";
        }
    }
}

