/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.toolbar;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.contributions.BundleVersion;
import com.jrockit.mc.components.ui.contributions.ContributionDescriptor;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import com.jrockit.mc.components.ui.design.view.toolbar.PluginPropertiesPage;
import com.jrockit.mc.components.ui.design.view.toolbar.TabPageLabelProvider;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.tab.TabGroupDescriptor;
import com.jrockit.mc.components.ui.tab.TabItemDescriptor;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.ErrorDialog;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class ExportToUIPluginAction
extends Action {
    private static final String PLUGIN_XML_FILE = "plugin.xml";
    private static final String USER_INTERFACE_XML_FILE = "userInterface.xml";
    private static final String TEMPFILE_PREFIX_USER_INTERFACE = "tempuserInterface";
    public static final String KEY_MANIFEST_VERSION = "Manifest-Version";
    public static final String KEY_BUNDLE_VERSION = "Bundle-Version";
    public static final String KEY_BUNDLE_NAME = "Bundle-Name";
    public static final String KEY_BUNDLE_MANIFEST_VERSION = "Bundle-ManifestVersion";
    public static final String KEY_BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    public static final String KEY_REQUIRED_EXECUTION_ENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    public static final String KEY_REQUIRED_BUNDLE = "Require-Bundle";
    private final Shell m_shell;
    private final UserInterfaceContribution m_contribution;

    public ExportToUIPluginAction(Shell shell, UserInterfaceContribution contribution) {
        super(Messages.DESIGN_MENU_EXPORT_UI_TO_PLUGIN);
        this.m_shell = shell;
        this.m_contribution = contribution;
    }

    public void run() {
        ContributionDescriptor ce = this.m_contribution.getContributionDescriptor();
        UserInterfaceContribution copy = (UserInterfaceContribution)PersistenceToolkit.createWorkingCopy((Object)this.m_contribution);
        Object[] selected = this.selectedtabs(copy);
        if (selected != null && selected.length > 0) {
            File file;
            ContributionDescriptor cd = new ContributionDescriptor();
            cd.setName(Messages.MY_PLUGIN_TEXT);
            cd.setVersion(new BundleVersion(1, 0, 0));
            cd.setContainerIdentifier(ce.getContainerIdentifier());
            cd.setIdentifier("my.plugin");
            PluginPropertiesPage ppp = new PluginPropertiesPage(cd);
            OnePageWizardDialog dialog = new OnePageWizardDialog(this.m_shell, (IWizardPage)ppp);
            dialog.setHeightConstraint(200, 300);
            dialog.setWidthConstraint(400, 800);
            ppp.setTitle(Messages.EXPORT_PLUGIN_HEADER);
            ppp.setMessage(Messages.EXPORT_PLUGIN_TEXT);
            dialog.setImage(UIPlugin.getDefault().getImage("export.gif"));
            if (dialog.open() == 0 && (file = this.selectFile(cd)) != null) {
                this.pruneTabTree(copy, selected);
                this.safeExport(file, cd, copy);
            }
        }
    }

    private void safeExport(File file, ContributionDescriptor p, UserInterfaceContribution copy) {
        try {
            this.exportToJar(file, p, copy);
        }
        catch (IOException e) {
            ErrorDialog.showException((Shell)this.m_shell, (String)Messages.PLUGIN_EXPORT_WIZARD_ERROR_TEXT, (Throwable)e);
        }
    }

    private File selectFile(ContributionDescriptor ce) {
        FileDialog fd = new FileDialog(this.m_shell, 8192);
        fd.setText(Messages.PLUGIN_EXPORT_SELECT_OUTPUT_FILE_TEXT);
        fd.setFileName(this.createJARName(ce));
        String filename = fd.open();
        return filename != null ? new File(filename) : null;
    }

    private String createJARName(ContributionDescriptor ce) {
        return String.valueOf(ce.getIdentifier()) + "_" + ce.getVersion() + ".jar";
    }

    private Object[] selectedtabs(UserInterfaceContribution contrib) {
        ArrayContentProvider l = new ArrayContentProvider();
        List<TabItemDescriptor> tabPages = contrib.getUserInterface().getTabRepository().getAllTabItemDescriptors();
        TabPageLabelProvider ip = new TabPageLabelProvider((Device)this.m_shell.getDisplay());
        ListSelectionDialog dialog = new ListSelectionDialog(this.m_shell, tabPages, (IStructuredContentProvider)l, (ILabelProvider)ip, Messages.PLUGIN_EXPORT_SELECT_TABS_TO_EXPORT_MESSAGE_TEXT);
        dialog.open();
        return dialog.getResult();
    }

    private void pruneTabTree(UserInterfaceContribution contrib, Object[] keepers) {
        List<TabGroupDescriptor> rootGroups = contrib.getUserInterface().getTabRepository().getGroups();
        this.removeTabsInGroup(rootGroups, Arrays.asList(keepers));
        this.removeEmptyGroups(null, rootGroups);
    }

    private boolean removeEmptyGroups(TabGroupDescriptor parentGroup, List<TabGroupDescriptor> removeList) {
        Object[] descriptors;
        Object[] objectArray = descriptors = removeList.toArray();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            Object childGroup = objectArray[n2];
            TabGroupDescriptor g = (TabGroupDescriptor)childGroup;
            if (this.removeEmptyGroups(g, g.getGroups())) {
                removeList.remove(childGroup);
            }
            ++n2;
        }
        return this.isEmpty(parentGroup, removeList);
    }

    private boolean isEmpty(TabGroupDescriptor parentGroup, List<TabGroupDescriptor> removeList) {
        return removeList.isEmpty() && (parentGroup == null || parentGroup.getTabs().isEmpty());
    }

    private void removeTabsInGroup(List<TabGroupDescriptor> groups, List<Object> keepers) {
        for (TabGroupDescriptor group : groups) {
            this.removeTabsInGroup(group.getGroups(), keepers);
            TabItemDescriptor[] descriptors = group.getTabs().toArray(new TabItemDescriptor[group.getTabs().size()]);
            int n = 0;
            while (n < descriptors.length) {
                if (!keepers.contains(descriptors[n])) {
                    group.getTabs().remove(descriptors[n]);
                }
                ++n;
            }
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int anz;
        byte[] buf = new byte[1024];
        while ((anz = in.read(buf)) != -1) {
            out.write(buf, 0, anz);
        }
    }

    private void exportToJar(File file, ContributionDescriptor ce, UserInterfaceContribution copy) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JarOutputStream jarOutputStream = null;
        File tempFile1 = null;
        FileInputStream is = null;
        try {
            jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, this.createManifest(ce));
            tempFile1 = File.createTempFile(TEMPFILE_PREFIX_USER_INTERFACE, "");
            PersistenceToolkit.exportObjectToFile((Object)copy, (File)tempFile1);
            jarOutputStream.putNextEntry(new JarEntry(USER_INTERFACE_XML_FILE));
            is = new FileInputStream(tempFile1);
            this.copy(is, jarOutputStream);
            jarOutputStream.putNextEntry(new JarEntry(PLUGIN_XML_FILE));
            this.writePluginXML(jarOutputStream, ce);
            jarOutputStream.close();
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(jarOutputStream);
            IOToolkit.closeSilently((Closeable)fileOutputStream);
            IOToolkit.closeSilently(is);
            this.deleteFile(tempFile1);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)jarOutputStream);
        IOToolkit.closeSilently((Closeable)fileOutputStream);
        IOToolkit.closeSilently((Closeable)is);
        this.deleteFile(tempFile1);
    }

    private void deleteFile(File tempFile) {
        if (tempFile != null && !tempFile.delete()) {
            ComponentsPlugin.getDefault().getLogger().log(Level.WARNING, "Could not remove temp file" + tempFile);
        }
    }

    private void writePluginXML(JarOutputStream jarOutputStream, ContributionDescriptor ce) {
        PrintWriter pw = new PrintWriter(jarOutputStream);
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println("<?eclipse version=\"3.2\"?>");
        pw.println("<plugin>");
        pw.println("<extension point=\"com.jrockit.mc.components.ui.userInterface\">");
        pw.println("<userInterface");
        pw.println(" containerIdentifier=\"" + ce.getContainerIdentifier() + "\"");
        pw.println(" userInterfaceFile=\"/userInterface.xml\">");
        pw.println("</userInterface>");
        pw.println("</extension>");
        pw.println("</plugin>");
        pw.close();
    }

    private Manifest createManifest(ContributionDescriptor ce) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue(KEY_MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().putValue(KEY_BUNDLE_MANIFEST_VERSION, "2");
        manifest.getMainAttributes().putValue(KEY_BUNDLE_NAME, ce.getName());
        manifest.getMainAttributes().putValue(KEY_BUNDLE_SYMBOLIC_NAME, String.valueOf(ce.getIdentifier()) + ";singleton:=true");
        manifest.getMainAttributes().putValue(KEY_BUNDLE_VERSION, ce.getVersion());
        manifest.getMainAttributes().putValue(KEY_REQUIRED_BUNDLE, "com.jrockit.mc.components.ui;bundle-version=\"5.5.1\"");
        manifest.getMainAttributes().putValue(KEY_REQUIRED_EXECUTION_ENVIRONMENT, "JavaSE-1.6");
        return manifest;
    }
}

