/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.greychart.ui.model.TickDensityName;
import com.jrockit.mc.rjmx.ui.internal.ChartComposite;
import com.jrockit.mc.rjmx.ui.internal.ChartModel;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.ui.dialogs.MCTitleAreaDialog;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.QuantityKindProposal;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import se.hirt.greychart.TickDensity;
import se.hirt.greychart.data.RenderingMode;
import se.hirt.greychart.impl.DefaultYAxis;

public class ChartMenuBuilder {
    public static IContributionItem createShowMenu(ChartComposite chart) {
        MenuManager m = new MenuManager(Messages.ChartComposite_SHOW_MENU_TEXT);
        m.add((IAction)ChartMenuBuilder.createShow(Messages.ChartComposite_SHOW_LAST_15_SECONDS, 15000000000L, chart));
        m.add((IAction)ChartMenuBuilder.createShow(Messages.ChartComposite_SHOW_LAST_MINUTE, 60000000000L, chart));
        m.add((IAction)ChartMenuBuilder.createShow(Messages.ChartComposite_SHOW_LAST_10_MINUTES, 600000000000L, chart));
        m.add((IAction)ChartMenuBuilder.createShow(Messages.ChartComposite_SHOW_LAST_HOUR, 3600000000000L, chart));
        m.add((IAction)ChartMenuBuilder.createShow(Messages.ChartComposite_SHOW_LAST_DAY, 86400000000000L, chart));
        m.add((IAction)ChartMenuBuilder.createShow(Messages.ChartComposite_SHOW_LAST_WEEK, 604800000000000L, chart));
        return m;
    }

    private static Action createShow(String label, final long nanoSeconds, final ChartComposite chart) {
        return new Action(label){

            public void run() {
                chart.showLast(nanoSeconds);
            }
        };
    }

    public static IContributionItem createRangeMenu(final ChartModel chartModel) {
        MenuManager rangeMenu = new MenuManager(Messages.ChartComposite_MENU_Y_AXIS_RANGE_TEXT);
        rangeMenu.add((IAction)new Action(Messages.ChartComposite_MENU_AUTO_RANGE_TEXT){

            public void run() {
                chartModel.getYAxis().setRangeType(ChartModel.AxisRange.AUTO);
                chartModel.getYAxis().notifyObservers();
            }
        });
        rangeMenu.add((IAction)new Action(Messages.ChartComposite_MENU_AUTO_RANGE_ZERO_TEXT){

            public void run() {
                chartModel.getYAxis().setRangeType(ChartModel.AxisRange.AUTO_ZERO);
                chartModel.getYAxis().notifyObservers();
            }
        });
        rangeMenu.add((IAction)new Action(Messages.ChartComposite_MENU_CUSTOM_RANGE_TEXT){

            public void run() {
                ChartModel.RangedAxis yAxis = chartModel.getYAxis();
                RangeInputDialog rangeInputDialog = new RangeInputDialog(Display.getCurrent().getActiveShell(), yAxis.getKindOfQuantity(), yAxis.getMinValue(), yAxis.getMaxValue());
                if (rangeInputDialog.open() == 0) {
                    yAxis.setRangeType(ChartModel.AxisRange.CUSTOM);
                    yAxis.setMinValue(rangeInputDialog.getFromValue());
                    yAxis.setMaxValue(rangeInputDialog.getToValue());
                    yAxis.notifyObservers();
                }
            }
        });
        return rangeMenu;
    }

    public static IContributionItem createLabelDensityMenu(final DefaultYAxis yAxis) {
        MenuManager labelDensityMenu = new MenuManager(Messages.ChartComposite_MENU_LABEL_DENSITY_TEXT);
        TickDensity[] tickDensityArray = TickDensity.values();
        int n = tickDensityArray.length;
        int n2 = 0;
        while (n2 < n) {
            final TickDensity tickDensity = tickDensityArray[n2];
            labelDensityMenu.add((IAction)new Action(TickDensityName.getReadableName((TickDensity)tickDensity)){

                public void run() {
                    yAxis.setTickDensity(tickDensity);
                }
            });
            ++n2;
        }
        return labelDensityMenu;
    }

    public static IContributionItem createRenderingModeMenu(ChartModel chartModel) {
        MenuManager renderingModeMenu = new MenuManager(Messages.ChartComposite_MENU_RENDERING_MODE_TEXT);
        renderingModeMenu.add((IAction)ChartMenuBuilder.createRenderingMode(Messages.ChartComposite_MENU_RENDERING_MODE_SUBSAMPLING_TEXT, chartModel, RenderingMode.SUBSAMPLING));
        renderingModeMenu.add((IAction)ChartMenuBuilder.createRenderingMode(Messages.ChartComposite_MENU_RENDERING_MODE_AVERAGING_TEXT, chartModel, RenderingMode.AVERAGING));
        return renderingModeMenu;
    }

    private static Action createRenderingMode(String menuName, final ChartModel chartModel, final RenderingMode mode) {
        return new Action(menuName){

            public void run() {
                chartModel.setRenderingMode(mode);
                chartModel.notifyObservers();
            }
        };
    }

    public static IContributionItem createTitleMenu(final ChartModel chartModel) {
        MenuManager titleMenu = new MenuManager(Messages.ChartComposite_MENU_EDIT_TITLES_TEXT);
        titleMenu.add((IAction)new Action(Messages.ChartComposite_MENU_GRAPH_TITLE_TEXT){

            public void run() {
                String defaultValue = chartModel.getChartTitle();
                InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ChartComposite_INPUT_GRAPH_TITLE_TITLE, Messages.ChartComposite_INPUT_GRAPH_TITLE_MESSAGE, defaultValue, null);
                if (inputDialog.open() == 0) {
                    chartModel.setChartTitle(inputDialog.getValue());
                    chartModel.notifyObservers();
                }
            }
        });
        titleMenu.add((IAction)new Action(Messages.ChartComposite_MENU_Y_AXIS_TITLE_TEXT){

            public void run() {
                InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ChartComposite_INPUT_Y_AXIS_TITLE_TITLE, Messages.ChartComposite_INPUT_Y_AXIS_TITLE_MESSAGE, chartModel.getYAxis().getTitle(), null);
                if (inputDialog.open() == 0) {
                    chartModel.getYAxis().setTitle(inputDialog.getValue());
                    chartModel.getYAxis().notifyObservers();
                }
            }
        });
        titleMenu.add((IAction)new Action(Messages.ChartComposite_MENU_X_AXIS_TITLE_TEXT){

            public void run() {
                InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ChartComposite_INPUT_X_AXIS_TITLE_TITLE, Messages.ChartComposite_INPUT_X_AXIS_TITLE_MESSAGE, chartModel.getXAxis().getTitle(), null);
                if (inputDialog.open() == 0) {
                    chartModel.getXAxis().setTitle(inputDialog.getValue());
                    chartModel.getXAxis().notifyObservers();
                }
            }
        });
        return titleMenu;
    }

    public static class RangeInputDialog
    extends MCTitleAreaDialog {
        private Text fromText;
        private Text toText;
        private final KindOfQuantity<?> kindOfQuantity;
        private IQuantity fromValue;
        private IQuantity toValue;

        public RangeInputDialog(Shell parentShell, KindOfQuantity<?> kindOfQuantity, IQuantity fromValue, IQuantity toValue) {
            super(parentShell);
            this.kindOfQuantity = kindOfQuantity;
            this.fromValue = fromValue;
            this.toValue = toValue;
        }

        private void validateInput() {
            String errorMessage = null;
            try {
                IQuantity fromQuantity = this.kindOfQuantity.parseInteractive(this.fromText.getText());
                IQuantity toQuantity = this.kindOfQuantity.parseInteractive(this.toText.getText());
                if (fromQuantity.compareTo((Object)toQuantity) > 0) {
                    errorMessage = Messages.ChartComposite_DIALOG_RANGE_INPUT_MESSAGE_FROM_SMALLER_THAN_TO;
                }
            }
            catch (QuantityConversionException e) {
                errorMessage = e.getLocalizedMessage();
            }
            this.getButton(0).setEnabled(errorMessage == null);
            this.setErrorMessage(errorMessage);
        }

        protected Control createContents(Composite parent) {
            this.getShell().setText(Messages.ChartComposite_DIALOG_RANGE_INPUT_TITLE);
            Control contents = super.createContents(parent);
            contents.getShell().setSize(400, 250);
            DisplayToolkit.placeDialogInCenter((Shell)this.getParentShell(), (Shell)this.getShell());
            this.setMessage(Messages.ChartComposite_DIALOG_RANGE_INPUT_TEXT);
            this.setTitle(Messages.ChartComposite_DIALOG_RANGE_INPUT_TITLE);
            this.validateInput();
            return contents;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createCustomArea(composite);
            RangeInputDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private Control createCustomArea(Composite parent) {
            Composite numberFields = new Composite(parent, 0);
            numberFields.setLayout((Layout)new GridLayout(2, false));
            GridData gd = new GridData(4, 4, true, false);
            gd.widthHint = 80;
            Label minimumLabel = new Label(numberFields, 0);
            minimumLabel.setText(Messages.ChartComposite_DIALOG_RANGE_INPUT_MINIMUM_TEXT);
            minimumLabel.setLayoutData((Object)new GridData(4, 4, false, false));
            this.fromText = new Text(numberFields, 2052);
            this.fromText.setLayoutData((Object)gd);
            this.fromText.setFocus();
            this.fromText.setText(this.fromValue.interactiveFormat());
            this.fromText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RangeInputDialog.this.validateInput();
                }
            });
            QuantityKindProposal.install((Text)this.fromText, this.kindOfQuantity);
            Label maximumLabel = new Label(numberFields, 0);
            maximumLabel.setText(Messages.ChartComposite_DIALOG_RANGE_INPUT_MAXIMUM_TEXT);
            maximumLabel.setLayoutData((Object)new GridData(4, 4, false, false));
            this.toText = new Text(numberFields, 2052);
            this.toText.setLayoutData((Object)gd);
            this.toText.setText(this.toValue.interactiveFormat());
            this.toText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RangeInputDialog.this.validateInput();
                }
            });
            QuantityKindProposal.install((Text)this.toText, this.kindOfQuantity);
            return numberFields;
        }

        public IQuantity getFromValue() {
            return this.fromValue;
        }

        public IQuantity getToValue() {
            return this.toValue;
        }

        protected void okPressed() {
            try {
                this.fromValue = this.kindOfQuantity.parseInteractive(this.fromText.getText());
                this.toValue = this.kindOfQuantity.parseInteractive(this.toText.getText());
                super.okPressed();
            }
            catch (QuantityConversionException quantityConversionException) {
                // empty catch block
            }
        }
    }
}

