/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.PropertiesFileRenderer;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.SecretPropertyField;
import org.tp23.antinstaller.page.Page;

public class DefaultPropertiesFileRenderer
implements PropertiesFileRenderer {
    public void renderProperties(Installer installer, File file) {
        Page[] pageArray = installer.getPages();
        Properties properties = new Properties();
        properties.put("basedir", file.getAbsolutePath());
        for (int i = 0; i < pageArray.length; ++i) {
            OutputField[] outputFieldArray = pageArray[i].getOutputField();
            for (int j = 0; j < outputFieldArray.length; ++j) {
                InputField inputField;
                if (outputFieldArray[j] instanceof SecretPropertyField) {
                    inputField = (InputField)outputFieldArray[j];
                    properties.put(inputField.getProperty(), "XXXXXXXX");
                    continue;
                }
                if (!(outputFieldArray[j] instanceof InputField)) continue;
                inputField = (InputField)outputFieldArray[j];
                String string = inputField.getInputResult();
                properties.put(inputField.getProperty(), string);
            }
        }
        try {
            File file2 = new File(file.getAbsolutePath(), "ant.install.properties");
            properties.store(new FileOutputStream(file2), "Ant Installer - AutoGenerated properties");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

