/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller;

import java.io.File;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.taskdefs.Execute;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.AntOutputRenderer;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.runtime.Logger;
import org.tp23.antinstaller.runtime.Runner;
import org.tp23.antinstaller.runtime.exe.AntLauncherFilter;

public class InstallerContext {
    public static final String ENV_PREFIX = "env.";
    public static final String JAVA_PREFIX = "java.";
    private Logger logger = null;
    private Installer installer = null;
    private MessageRenderer messageRenderer = null;
    private AntOutputRenderer antOutputRenderer = null;
    private Runner runner = null;
    private Page currentPage = null;
    private File fileRoot = null;
    private BuildListener buildListener = null;
    private AntLauncherFilter antRunner = null;
    private String uIOverride = null;
    private boolean installedSucceded = false;

    public void setInstallSucceded(boolean bl) {
        this.installedSucceded = bl;
    }

    public boolean isInstallSucceded() {
        return this.installedSucceded;
    }

    public void log(String string) {
        if (this.logger != null) {
            this.logger.log(string);
        }
    }

    public void log(Throwable throwable) {
        if (this.logger != null) {
            this.logger.log(throwable);
        }
    }

    public static boolean isUnix() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") == -1;
    }

    public static Properties getEnvironment() {
        String string;
        Object object;
        Cloneable cloneable;
        Properties properties = new Properties();
        try {
            cloneable = Execute.getProcEnvironment();
            object = ((Vector)cloneable).elements();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                int n = string.indexOf(61);
                if (n == -1) continue;
                properties.put(ENV_PREFIX + string.substring(0, n), string.substring(n + 1));
            }
        }
        catch (Exception exception) {
            System.out.println("Can't load environment:" + exception.getClass() + "," + exception.getMessage());
        }
        cloneable = System.getProperties();
        object = ((Properties)cloneable).keySet().iterator();
        while (object.hasNext()) {
            string = object.next();
            properties.put(JAVA_PREFIX + string.toString(), ((Properties)cloneable).get(string));
        }
        return properties;
    }

    public Installer getInstaller() {
        return this.installer;
    }

    public String getMinJavaVersion() {
        return this.installer.getMinJavaVersion();
    }

    public MessageRenderer getMessageRenderer() {
        return this.messageRenderer;
    }

    public void setMessageRenderer(MessageRenderer messageRenderer) {
        this.messageRenderer = messageRenderer;
        this.messageRenderer.setInstallerContext(this);
    }

    public AntOutputRenderer getAntOutputRenderer() {
        return this.antOutputRenderer;
    }

    public void setAntOutputRenderer(AntOutputRenderer antOutputRenderer) {
        this.antOutputRenderer = antOutputRenderer;
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(Page page) {
        this.currentPage = page;
    }

    public File getFileRoot() {
        return this.fileRoot;
    }

    public void setFileRoot(File file) {
        this.fileRoot = file;
    }

    public BuildListener getBuildListener() {
        return this.buildListener;
    }

    public void setBuildListener(BuildListener buildListener) {
        this.buildListener = buildListener;
    }

    public AntLauncherFilter getAntRunner() {
        return this.antRunner;
    }

    public void setAntRunner(AntLauncherFilter antLauncherFilter) {
        this.antRunner = antLauncherFilter;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Runner getRunner() {
        return this.runner;
    }

    public void setRunner(Runner runner) {
        this.runner = runner;
    }

    public void setInstaller(Installer installer) {
        this.installer = installer;
    }

    public String getUIOverride() {
        return this.uIOverride;
    }

    public void setUIOverride(String string) {
        this.uIOverride = string;
    }
}

