/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputException;
import org.tp23.antinstaller.input.InputField;

public class DateInput
extends InputField {
    private String dateFormat = "dd/MM/yyyy";
    private DateFormat formatter = new SimpleDateFormat(this.dateFormat);

    public DateInput() {
        this.formatter.setLenient(false);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String string) {
        try {
            this.formatter = new SimpleDateFormat(string);
            this.formatter.setLenient(false);
            this.dateFormat = string;
        }
        catch (RuntimeException runtimeException) {
            throw new InputException("Invalid date format in DateInput");
        }
    }

    public void setValue(String string) {
        this.setInputResult(string);
    }

    public boolean validate(InstallerContext installerContext) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        String string = this.getInputResult();
        try {
            this.formatter.parse(string);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string.equals("TODAY") ? this.formatter.format(new Date()) : string;
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("Date:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            System.out.println("Date:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            System.out.println("Date:defaultValue must be set");
            return false;
        }
        return true;
    }
}

