/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputField;

public class TargetInput
extends InputField {
    private String target;
    private String defaultValue;
    private String force;
    private String osSpecific;
    private String strict;
    private int idx = TargetInput.getGlobalIdx();
    private static int globalIdx = 1;

    public String getTarget() {
        if (TargetInput.isTrue(this.osSpecific)) {
            return this.getOSSpecificTarget();
        }
        return this.target;
    }

    public void setTarget(String string) {
        this.target = string;
        this.setProperty("target" + this.idx);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getForce() {
        return this.force;
    }

    public void setForce(String string) {
        this.force = string;
    }

    public String getStrict() {
        return this.strict;
    }

    public void setStrict(String string) {
        this.strict = string;
    }

    public String getOsSpecific() {
        return this.osSpecific;
    }

    public void setOsSpecific(String string) {
        this.osSpecific = string;
    }

    public boolean validate(InstallerContext installerContext) throws ValidationException {
        this.setInputResult(this.target);
        return true;
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("Target:displayText must be set");
            return false;
        }
        if (this.getTarget() == null) {
            System.out.println("Target:target must be set");
            return false;
        }
        if (!InputField.optionalBoolean(this.getForce())) {
            System.out.println("Target:force must be true or false or null");
            return false;
        }
        if (!InputField.optionalBoolean(this.getStrict())) {
            System.out.println("Target:strict must be true or false or null");
            return false;
        }
        if (!InputField.optionalBoolean(this.getOsSpecific())) {
            System.out.println("Target:osSpecific must be true or false or null");
            return false;
        }
        if (!InputField.requiredBoolean(this.getDefaultValue())) {
            System.out.println("Target:defaultValue must be true or false");
            return false;
        }
        return true;
    }

    public int getIdx() {
        return this.idx;
    }

    public static int getGlobalIdx() {
        return globalIdx++;
    }

    public String getOSSpecificTarget() {
        if (TargetInput.isTrue(this.strict)) {
            return this.getStrictTarget();
        }
        return this.getLaxTarget();
    }

    private String getStrictTarget() {
        return this.target + System.getProperty("os.name");
    }

    private String getLaxTarget() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("linux") != -1) {
            return this.target + "-linux";
        }
        if (string.indexOf("mac") != -1) {
            return this.target + "-mac";
        }
        if (string.indexOf("windows") != -1) {
            return this.target + "-win";
        }
        if (string.indexOf("solaris") != -1 || string.indexOf("sunos") != -1) {
            return this.target + "-sun";
        }
        return this.target + "-other";
    }
}

