/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer;

import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.antinstaller.renderer.swing.SwingPageRenderer;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;
import org.tp23.antinstaller.renderer.text.TextPageRenderer;

public class RendererFactory {
    public static TextOutputFieldRenderer getTextRenderer(OutputField outputField) throws ClassNotFoundException {
        String string = outputField.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new UnsupportedOperationException("InputField can not be a member of the default package");
        }
        int n2 = string.substring(0, n - 1).lastIndexOf(46, n - 1);
        if (n2 == -1) {
            throw new UnsupportedOperationException("InputField can not be a member of a single level package");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n2));
        stringBuffer.append(".renderer.text.");
        stringBuffer.append(string.substring(n + 1));
        stringBuffer.append("Renderer");
        try {
            Class<?> clazz = Class.forName(stringBuffer.toString());
            return (TextOutputFieldRenderer)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Class does not meet the contract for TextInputFieldRenderer:" + stringBuffer);
        }
    }

    public static TextPageRenderer getTextPageRenderer(Page page) throws ClassNotFoundException {
        String string = page.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new UnsupportedOperationException("Pages can not be a member of the default package");
        }
        int n2 = string.substring(0, n - 1).lastIndexOf(46, n - 1);
        if (n2 == -1) {
            throw new UnsupportedOperationException("Pages can not be a member of a single level package");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n2));
        stringBuffer.append(".renderer.text.");
        stringBuffer.append(string.substring(n + 1));
        stringBuffer.append("Renderer");
        try {
            Class<?> clazz = Class.forName(stringBuffer.toString());
            return (TextPageRenderer)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Class does not meet the contract for TextPageRenderer:" + stringBuffer);
        }
    }

    public static SwingPageRenderer getSwingPageRenderer(Page page) throws ClassNotFoundException {
        String string = page.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new UnsupportedOperationException("Pages can not be a member of the default package");
        }
        int n2 = string.substring(0, n - 1).lastIndexOf(46, n - 1);
        if (n2 == -1) {
            throw new UnsupportedOperationException("Pages can not be a member of a single level package");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n2));
        stringBuffer.append(".renderer.swing.");
        stringBuffer.append(string.substring(n + 1));
        stringBuffer.append("Renderer");
        try {
            Class<?> clazz = Class.forName(stringBuffer.toString());
            return (SwingPageRenderer)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Class does not meet the contract for SwingPageRenderer:" + stringBuffer);
        }
    }

    public static SwingOutputFieldRenderer getSwingRenderer(OutputField outputField) throws ClassNotFoundException {
        String string = outputField.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new UnsupportedOperationException("OutputField can not be a member of the default package");
        }
        int n2 = string.substring(0, n - 1).lastIndexOf(46, n - 1);
        if (n2 == -1) {
            throw new UnsupportedOperationException("OutputField can not be a member of a single level package");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n2));
        stringBuffer.append(".renderer.swing.");
        stringBuffer.append(string.substring(n + 1));
        stringBuffer.append("Renderer");
        try {
            Class<?> clazz = Class.forName(stringBuffer.toString());
            return (SwingOutputFieldRenderer)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ClassNotFoundException("Class does not meet the contract for SwingInputFieldRenderer:" + stringBuffer);
        }
    }
}

