/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.CheckboxInput;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.swing.AICheckBox;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class CheckboxInputRenderer
extends SwingOutputFieldRenderer {
    protected CheckboxInput inputField;
    protected JLabel fieldLabel = new AILabel();
    protected AICheckBox checkBox = new AICheckBox();

    public void initComponent(JPanel jPanel) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setOutputField(OutputField outputField) {
        this.inputField = (CheckboxInput)outputField;
    }

    public void updateInputField() {
        boolean bl = this.checkBox.isSelected();
        if (bl) {
            this.inputField.setValue("true");
        } else {
            this.inputField.setValue("false");
        }
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            String string = this.inputField.getDefaultValue();
            this.checkBox.setSelected(InputField.isTrue(string));
        }
    }

    private void jbInit() throws Exception {
        this.fieldLabel.setText(this.inputField.getDisplayText());
        this.checkBox.setSelected(OutputField.isTrue(this.inputField.getDefaultValue()));
        this.checkBox.setEnabled(!OutputField.isTrue(this.inputField.getForce()));
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CheckboxInputRenderer.this.updateInputField();
                CheckboxInputRenderer.this.inputField.setEditted(true);
            }
        });
    }

    public int addSelf(JPanel jPanel, GBCF gBCF, int n, boolean bl) {
        jPanel.add((Component)this.fieldLabel, gBCF.getCell(n, 0));
        jPanel.add((Component)this.checkBox, gBCF.getCell(n, 1));
        if (bl) {
            this.checkBox.setOverflow(SwingOutputFieldRenderer.OVERFLOW_FIELD_SIZE);
        }
        return ++n;
    }

    public void renderError() {
    }
}

