/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.FileInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.swing.AIButton;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.AIShortTextField;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class FileInputRenderer
extends SwingOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    protected FileInput inputField;
    protected AILabel fieldLabel = new AILabel();
    protected AIShortTextField jTextField = new AIShortTextField();
    protected AIButton browseButton = new AIButton();
    protected JPanel browsePanel = new JPanel();
    private Color origFore = this.jTextField.getForeground();
    private JPanel parent;

    public void initComponent(JPanel jPanel) {
        this.parent = jPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setOutputField(OutputField outputField) {
        this.inputField = (FileInput)outputField;
        this.inputField.setValue(this.inputField.getDefaultValue(true));
    }

    public void updateInputField() {
        if (!this.inputField.getDefaultValue(true).equals(this.jTextField.getText())) {
            this.inputField.setEditted(true);
        }
        this.inputField.setValue(this.jTextField.getText());
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            this.jTextField.setText(this.inputField.getDefaultValue(true));
        }
    }

    private void jbInit() throws Exception {
        BorderLayout borderLayout = new BorderLayout();
        this.browsePanel.setLayout(borderLayout);
        this.fieldLabel.setText(this.inputField.getDisplayText());
        this.jTextField.setText(this.inputField.getDefaultValue(true));
        this.browsePanel.add((Component)this.jTextField, "Center");
        this.browsePanel.add((Component)this.browseButton, "East");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                File file = null;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileHidingEnabled(false);
                jFileChooser.setFileSelectionMode(0);
                if (FileInputRenderer.this.jTextField.getText() != null) {
                    jFileChooser.setCurrentDirectory(new File(FileInputRenderer.this.jTextField.getText()).getParentFile());
                }
                if ((n = jFileChooser.showDialog(FileInputRenderer.this.parent, actionEvent.getActionCommand())) == 0) {
                    file = jFileChooser.getSelectedFile();
                }
                if (file != null) {
                    FileInputRenderer.this.jTextField.setText(file.getAbsolutePath());
                    FileInputRenderer.this.inputField.setValue(file.getAbsolutePath());
                    FileInputRenderer.this.inputField.setEditted(true);
                }
            }
        });
        this.browseButton.setText(res.getString("selectFile"));
        this.browseButton.setPreferredSize(new Dimension(150, 20));
        this.jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileInputRenderer.this.updateInputField();
            }
        });
        this.jTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FileInputRenderer.this.jTextField.setForeground(FileInputRenderer.this.origFore);
            }
        });
    }

    public int addSelf(JPanel jPanel, GBCF gBCF, int n, boolean bl) {
        jPanel.add((Component)this.fieldLabel, gBCF.getCell(n, 0));
        jPanel.add((Component)this.browsePanel, gBCF.getCell(n, 1));
        if (bl) {
            this.jTextField.setOverflow(SwingOutputFieldRenderer.OVERFLOW_SHORT_FIELD_SIZE);
        }
        return ++n;
    }

    public void renderError() {
        MessageRenderer messageRenderer = this.ctx.getMessageRenderer();
        messageRenderer.printMessage(res.getString("fileNotExist"));
        this.jTextField.requestFocus();
        this.jTextField.setForeground(Color.red);
    }
}

