/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import org.tp23.antinstaller.page.ProgressPage;
import org.tp23.antinstaller.renderer.AntOutputRenderer;
import org.tp23.antinstaller.renderer.swing.ProgressPanel;
import org.tp23.antinstaller.renderer.swing.SwingInstallerContext;
import org.tp23.antinstaller.renderer.swing.SwingPageRenderer;
import org.tp23.gui.widget.SystemOutJTextArea;

public class ProgressPageRenderer
extends SwingPageRenderer
implements AntOutputRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    private static final int MESSAGE_PANEL_HEIGHT = 30;
    private JPanel contentPanel = new JPanel();
    private JTabbedPane jTabbedPane = new JTabbedPane();
    private JPanel messagesPanel = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JToggleButton jToggleButton = new JToggleButton();
    private JLabel feedBackLabel = new JLabel();
    private SystemOutJTextArea outPanel = new SystemOutJTextArea();
    private SystemOutJTextArea errPanel = new SystemOutJTextArea();
    private boolean showTargets = true;
    private JScrollPane progressScrollPane = new JScrollPane();
    private ProgressPanel progressPanel;

    public ProgressPageRenderer() {
        this.errPanel.setAsSystemErr();
        this.outPanel.setAsSystemOut();
    }

    public PrintStream getErr() {
        return this.errPanel.getOut();
    }

    public PrintStream getOut() {
        return this.outPanel.getOut();
    }

    public void instanceInit() {
        this.showTargets = ((ProgressPage)this.page).isShowTargets();
        this.contentPanel.setLayout(this.borderLayout1);
        this.add((Component)this.contentPanel, "Center");
        this.messagesPanel.setLayout(null);
        Dimension dimension = new Dimension(PAGE_WIDTH, 30);
        this.messagesPanel.setSize(dimension);
        this.messagesPanel.setPreferredSize(dimension);
        this.messagesPanel.setMaximumSize(dimension);
        this.messagesPanel.setMinimumSize(dimension);
        this.feedBackLabel.setText(res.getString("click") + " " + this.ctx.getInstaller().getFinishButtonText() + " " + res.getString("toContinue"));
        this.feedBackLabel.setBounds(new Rectangle(115, 7, 272, 22));
        this.jToggleButton.setText(res.getString("showDetails"));
        this.jToggleButton.setBounds(new Rectangle(5, 7, 104, 22));
        this.messagesPanel.add((Component)this.jToggleButton, null);
        this.messagesPanel.add((Component)this.feedBackLabel, null);
        this.jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProgressPageRenderer.this.jToggleButton.isSelected()) {
                    if (ProgressPageRenderer.this.showTargets) {
                        ProgressPageRenderer.this.contentPanel.remove(ProgressPageRenderer.this.progressScrollPane);
                    }
                    ProgressPageRenderer.this.contentPanel.add((Component)ProgressPageRenderer.this.jTabbedPane, "Center");
                    ProgressPageRenderer.this.contentPanel.doLayout();
                    ProgressPageRenderer.this.contentPanel.repaint();
                } else {
                    ProgressPageRenderer.this.contentPanel.remove(ProgressPageRenderer.this.jTabbedPane);
                    if (ProgressPageRenderer.this.showTargets) {
                        ProgressPageRenderer.this.contentPanel.add((Component)ProgressPageRenderer.this.progressScrollPane, "Center");
                    }
                    ProgressPageRenderer.this.contentPanel.doLayout();
                    ProgressPageRenderer.this.contentPanel.repaint();
                }
            }
        });
        this.contentPanel.add((Component)this.messagesPanel, "North");
        if (this.showTargets) {
            this.progressScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
            this.contentPanel.add((Component)this.progressScrollPane, "Center");
        }
        this.jTabbedPane.add(res.getString("output"), (Component)this.outPanel);
        this.jTabbedPane.add(res.getString("errors"), (Component)this.errPanel);
        this.jTabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPanel.setMaximumSize(new Dimension(PAGE_WIDTH, Integer.MAX_VALUE));
        this.contentPanel.setMinimumSize(new Dimension(PAGE_WIDTH, 100));
        this.contentPanel.setPreferredSize(new Dimension(PAGE_WIDTH, PAGE_HEIGHT - 100));
        this.getNextButton().setEnabled(false);
        this.getFinishButton().setText(this.ctx.getInstaller().getFinishButtonText());
        this.getFinishButton().setEnabled(true);
    }

    public void setContext(SwingInstallerContext swingInstallerContext) {
        super.setContext(swingInstallerContext);
        if (this.showTargets) {
            this.progressPanel = new ProgressPanel(swingInstallerContext.getInstallerContext());
            this.progressScrollPane.getViewport().add(this.progressPanel);
            this.swingCtx.setProgressPanel(this.progressPanel);
        }
        this.swingCtx.setFeedBackLabel(this.feedBackLabel);
    }

    public void updateInputFields() {
    }

    public boolean validateFields() {
        return true;
    }

    public void updateDefaultValues() {
    }
}

