/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Target;
import org.tp23.antinstaller.InstallerContext;

public class ProgressPanel
extends JPanel
implements Scrollable {
    public static final int tHeight = 19;
    public static final int leftIndent = 15;
    public static final int DONE = 0;
    public static final int INPROGRESS = 1;
    public static final int TODO = 2;
    private static final Color progressColor = new Color(0, 125, 0);
    private static final Font mainFont = new Font("Dialog", 0, 11);
    private static final Font subFont = new Font("Dialog", 0, 10);
    List targets = null;
    private final InstallerContext ctx;
    private int mainTargetPos = 0;
    private ProgressModel currentPM = null;

    public ProgressPanel(InstallerContext installerContext) {
        super(true);
        this.ctx = installerContext;
    }

    public void prepareCalledTargets() {
        Vector vector = this.ctx.getInstaller().getTargets();
        Iterator iterator = vector.iterator();
        this.targets = new ArrayList();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.targets.add(new ProgressModel(string));
        }
        this.repaint();
    }

    public void targetStarted(BuildEvent buildEvent) {
        try {
            Target target = buildEvent.getTarget();
            ProgressModel progressModel = (ProgressModel)this.targets.get(this.mainTargetPos);
            progressModel.state = 1;
            if (target.getName().equals(progressModel.name)) {
                this.currentPM = progressModel;
                ++this.mainTargetPos;
                this.repaint();
            } else {
                ProgressModel progressModel2 = new ProgressModel(target.getName());
                progressModel2.state = 1;
                if (this.currentPM != null) {
                    this.currentPM.state = 0;
                }
                this.currentPM = progressModel2;
                progressModel.subTargets.add(progressModel2);
                this.getParent().doLayout();
                this.repaint();
            }
        }
        catch (Exception exception) {
            this.ctx.log(exception);
        }
    }

    public void targetFinished(BuildEvent buildEvent) {
        this.currentPM.state = 0;
    }

    public void buildFinished(BuildEvent buildEvent) {
        this.setToDone(this.targets);
        this.repaint();
    }

    private void setToDone(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProgressModel progressModel = (ProgressModel)iterator.next();
            progressModel.state = 0;
            this.setToDone(progressModel.subTargets);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.targets == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(graphics.getClipBounds().x, graphics.getClipBounds().y, graphics.getClipBounds().width, graphics.getClipBounds().height);
        Iterator iterator = this.targets.iterator();
        int n = 0;
        int n2 = 1;
        while (iterator.hasNext()) {
            ProgressModel progressModel = (ProgressModel)iterator.next();
            this.drawTarget(progressModel, (Graphics2D)graphics, n, n2 < this.targets.size(), n2 > 1);
            n += 19;
            n += progressModel.subTargets.size() * 19;
            ++n2;
        }
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public Dimension getSize() {
        if (this.targets == null) {
            return new Dimension(500, 95);
        }
        int n = this.targets.size();
        Iterator iterator = this.targets.iterator();
        while (iterator.hasNext()) {
            ProgressModel progressModel = (ProgressModel)iterator.next();
            n += progressModel.subTargets.size();
        }
        return new Dimension(500, n * 19);
    }

    private void drawTarget(ProgressModel progressModel, Graphics2D graphics2D, int n, boolean bl, boolean bl2) {
        graphics2D.setFont(mainFont);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.gray);
        if (bl2) {
            graphics2D.drawLine(23, n, 23, n + 8);
        }
        if (bl || progressModel.subTargets.size() > 0) {
            graphics2D.drawLine(23, 9 + n, 23, 19 + n);
        }
        int n2 = 0;
        graphics2D.drawLine(23, 8 + n, 15 + n2 + 20, 8 + n);
        if (progressModel.state == 0) {
            graphics2D.setColor(Color.darkGray);
        }
        if (progressModel.state == 1) {
            graphics2D.setColor(progressColor);
        }
        if (progressModel.state == 2) {
            graphics2D.setColor(Color.gray);
        }
        graphics2D.fillRoundRect(15 + n2 + 3, n + 4, 11, 9, 7, 7);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(progressModel.name, 15 + n2 + 22, 13 + n);
        if (progressModel.subTargets.size() > 0) {
            Iterator iterator = progressModel.subTargets.iterator();
            int n3 = 1;
            while (iterator.hasNext()) {
                this.drawSubTarget((ProgressModel)iterator.next(), graphics2D, n += 19, bl | n3 < progressModel.subTargets.size());
                ++n3;
            }
        }
    }

    private void drawSubTarget(ProgressModel progressModel, Graphics2D graphics2D, int n, boolean bl) {
        graphics2D.setFont(subFont);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.gray);
        graphics2D.drawLine(23, n, 23, n + 8);
        if (bl) {
            graphics2D.drawLine(23, 9 + n, 23, 19 + n);
        }
        int n2 = 15;
        graphics2D.drawLine(23, 8 + n, 15 + n2 + 4, 8 + n);
        if (progressModel.state == 0) {
            graphics2D.setColor(Color.darkGray);
        }
        if (progressModel.state == 1) {
            graphics2D.setColor(progressColor);
        }
        if (progressModel.state == 2) {
            graphics2D.setColor(Color.gray);
        }
        graphics2D.fillRoundRect(15 + n2 + 4, n + 5, 9, 7, 7, 7);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(progressModel.name, 15 + n2 + 15, 12 + n);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 19;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 57;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public static class ProgressModel {
        int state = 2;
        String name;
        List subTargets = new ArrayList();

        public ProgressModel(String string) {
            this.name = string;
        }

        int getHeight() {
            return 19 + this.subTargets.size() * 19;
        }
    }
}

