/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.AIRadioButton;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class SelectInputRenderer
extends SwingOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    protected SelectInput inputField;
    protected JLabel fieldLabel = new AILabel();
    protected ButtonGroup optionGroup = new ButtonGroup();
    private int numOfEntries = 2;

    public void initComponent(JPanel jPanel) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setOutputField(OutputField outputField) {
        this.inputField = (SelectInput)outputField;
        this.numOfEntries = this.inputField.getOptions().length;
    }

    public void updateInputField() {
        Enumeration<AbstractButton> enumeration = this.optionGroup.getElements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (jRadioButton.isSelected()) {
                this.inputField.setValue(this.inputField.getOptions()[n].value);
                break;
            }
            ++n;
        }
        if (n > this.inputField.getOptions().length) {
            this.inputField.setValue(this.inputField.getDefaultValue());
        }
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            String string = this.inputField.getDefaultValue();
            Enumeration<AbstractButton> enumeration = this.optionGroup.getElements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                if (string.equals(this.inputField.getOptions()[n].value)) {
                    JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                    jRadioButton.setSelected(true);
                } else {
                    enumeration.nextElement();
                }
                ++n;
            }
        }
    }

    private void jbInit() throws Exception {
        this.fieldLabel.setText(this.inputField.getDisplayText());
        SelectInput.Option[] optionArray = this.inputField.getOptions();
        for (int i = 0; i < optionArray.length; ++i) {
            AIRadioButton aIRadioButton = new AIRadioButton(optionArray[i].text);
            this.optionGroup.add(aIRadioButton);
            if (optionArray[i].value.equals(this.inputField.getDefaultValue())) {
                aIRadioButton.setSelected(true);
            }
            aIRadioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    SelectInputRenderer.this.inputField.setEditted(true);
                }
            });
        }
    }

    public int addSelf(JPanel jPanel, GBCF gBCF, int n, boolean bl) {
        jPanel.add((Component)this.fieldLabel, gBCF.getCell(n, 0));
        Enumeration<AbstractButton> enumeration = this.optionGroup.getElements();
        enumeration.hasMoreElements();
        AIRadioButton aIRadioButton = (AIRadioButton)enumeration.nextElement();
        jPanel.add((Component)aIRadioButton, gBCF.getCell(n++, 1));
        if (bl) {
            aIRadioButton.setOverflow(SwingOutputFieldRenderer.OVERFLOW_FIELD_SIZE);
        }
        JPanel jPanel2 = new JPanel();
        while (enumeration.hasMoreElements()) {
            aIRadioButton = (AIRadioButton)enumeration.nextElement();
            jPanel.add((Component)jPanel2, gBCF.getCell(n, 0));
            jPanel.add((Component)aIRadioButton, gBCF.getCell(n++, 1));
            if (!bl) continue;
            aIRadioButton.setOverflow(SwingOutputFieldRenderer.OVERFLOW_FIELD_SIZE);
        }
        return n;
    }

    public void renderError() {
        this.ctx.getMessageRenderer().printMessage(res.getString("notValidSelection"));
    }
}

