/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.CheckboxInput;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class CheckboxInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    protected InstallerContext ctx;

    public void setContext(InstallerContext installerContext) {
        this.ctx = installerContext;
    }

    public void renderOutput(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        CheckboxInput checkboxInput = (CheckboxInput)outputField;
        printStream.print(checkboxInput.getDisplayText());
        printStream.print("   [");
        printStream.print(res.getString("_default_"));
        printStream.print(":");
        printStream.print(checkboxInput.getDefaultValue());
        printStream.print("]");
        if (InputField.isTrue(checkboxInput.getForce())) {
            printStream.println(res.getString("_required_"));
            checkboxInput.setValue(checkboxInput.getDefaultValue());
            return;
        }
        printStream.println();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        printStream.println();
        if (string == null || string.trim().equals("")) {
            string = checkboxInput.getDefaultValue();
        }
        if (InputField.isTrue(string)) {
            checkboxInput.setValue("true");
        } else {
            checkboxInput.setValue("false");
        }
    }

    public boolean isAbort() {
        return false;
    }

    public void renderError(OutputField outputField, InputStream inputStream, PrintStream printStream) {
    }
}

