/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.DirectoryInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class DirectoryInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    protected InstallerContext ctx;

    public void setContext(InstallerContext installerContext) {
        this.ctx = installerContext;
    }

    public void renderOutput(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        DirectoryInput directoryInput = (DirectoryInput)outputField;
        printStream.print(directoryInput.getDisplayText());
        printStream.print("   [");
        printStream.print(res.getString("_default_"));
        printStream.print(":");
        printStream.print(directoryInput.getDefaultValue(true));
        printStream.print("]");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        printStream.println();
        String string = bufferedReader.readLine();
        printStream.println();
        if (string == null || string.equals("")) {
            string = directoryInput.getDefaultValue(true);
        }
        directoryInput.setInputResult(new File(string).getAbsolutePath());
    }

    public boolean isAbort() {
        return false;
    }

    public void renderError(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        this.renderOutput(outputField, inputStream, printStream);
    }
}

