/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.page.LicensePage;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.text.Pager;
import org.tp23.antinstaller.renderer.text.TextPageRenderer;

public class LicensePageRenderer
extends TextPageRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    private static final String nextChar = res.getString("nextChar");
    private boolean usePaging = false;

    public boolean renderPage(Page page) throws InstallException {
        if (page instanceof LicensePage) {
            LicensePage licensePage = (LicensePage)page;
            String string = licensePage.getUsePaging();
            this.usePaging = string != null && this.isTrue(string);
            return this.renderLicensePage(licensePage);
        }
        throw new InstallException("Wrong Renderer in LicensePageRenderer.renderPage");
    }

    private boolean renderLicensePage(LicensePage licensePage) throws InstallException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.in));
            this.out.println();
            this.out.println(res.getString("clickViewLicense"));
            bufferedReader.readLine();
            String string = licensePage.getResource();
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream));
            this.printHeader(licensePage);
            String string2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader2.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append('\n');
            }
            String string3 = null;
            Pager pager = new Pager(stringBuffer.toString());
            if (this.usePaging) {
                while (pager.next(this.out)) {
                    this.out.println();
                    this.out.println(this.getNextInstructions());
                    string3 = bufferedReader.readLine();
                    if (string3.toUpperCase().startsWith(nextChar)) continue;
                }
                pager.rest(this.out);
            } else {
                this.out.println(pager.getText());
            }
            for (int i = 0; i < 80; ++i) {
                this.out.print('~');
            }
            this.out.println();
            this.out.println(res.getString("licenseAccept"));
            string3 = bufferedReader.readLine();
            string3 = string3.trim();
            if (this.isTrue(string3)) {
                return true;
            }
            licensePage.setAbort(true);
            return false;
        }
        catch (IOException iOException) {
            throw new InstallException("Not able to read license file", iOException);
        }
    }

    private String getNextInstructions() {
        return res.getString("license_next");
    }
}

