/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.PasswordTextInput;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;
import org.tp23.antinstaller.renderer.text.ValidatedTextInputRenderer;

public class PasswordTextInputRenderer
extends ValidatedTextInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    protected InstallerContext ctx;

    public void setContext(InstallerContext installerContext) {
        this.ctx = installerContext;
    }

    public void renderOutput(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        PasswordTextInput passwordTextInput = (PasswordTextInput)outputField;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(outputField.getDisplayText());
        stringBuffer.append("   [");
        stringBuffer.append(res.getString("_default_"));
        stringBuffer.append(":");
        stringBuffer.append(passwordTextInput.getDefaultValue());
        stringBuffer.append("]");
        String string = null;
        if (OutputField.isTrue(passwordTextInput.getTextMask())) {
            string = new PasswordField().getPassword(stringBuffer.toString());
            System.out.print("\r                                                      ");
        } else {
            printStream.println(stringBuffer.toString());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            string = bufferedReader.readLine();
        }
        printStream.println();
        printStream.println();
        if (string == null || string.equals("")) {
            string = passwordTextInput.getDefaultValue();
        }
        passwordTextInput.setInputResult(string);
    }

    public void renderError(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        printStream.println("The password is not of the correct format");
        this.renderOutput(outputField, inputStream, printStream);
    }

    public boolean isAbort() {
        return false;
    }

    public class PasswordField {
        String getPassword(String string) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            MaskingThread maskingThread = new MaskingThread(string);
            Thread thread = new Thread(maskingThread);
            thread.start();
            while (true) {
                char c = (char)System.in.read();
                maskingThread.stopMasking();
                if (c == '\r') {
                    c = (char)System.in.read();
                    if (c != '\n') continue;
                    break;
                }
                if (c == '\n') break;
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
    }

    class MaskingThread
    extends Thread {
        private boolean stop = false;
        private int index;
        private String prompt;

        public MaskingThread(String string) {
            this.prompt = string;
        }

        public void run() {
            while (!this.stop) {
                try {
                    MaskingThread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (!this.stop) {
                    System.out.print("\r" + this.prompt + " \r" + this.prompt);
                }
                System.out.flush();
            }
        }

        public void stopMasking() {
            this.stop = true;
        }
    }
}

