/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class TargetInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    protected InstallerContext ctx;

    public void setContext(InstallerContext installerContext) {
        this.ctx = installerContext;
    }

    public void renderOutput(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        TargetInput targetInput = (TargetInput)outputField;
        printStream.println("Install the following component?");
        printStream.print(targetInput.getDisplayText());
        printStream.print("   [");
        printStream.print(res.getString("_default_"));
        printStream.print(":");
        printStream.print(targetInput.getDefaultValue());
        printStream.print("]");
        if (InputField.isTrue(targetInput.getForce())) {
            printStream.print("   [");
            printStream.print(res.getString("_required_"));
            printStream.println("]");
            this.ctx.getCurrentPage().addTarget(targetInput.getIdx(), targetInput.getTarget());
            printStream.println();
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        printStream.println();
        String string = bufferedReader.readLine();
        printStream.println();
        if (string == null || string.trim().equals("")) {
            string = targetInput.getDefaultValue();
        }
        if (InputField.isTrue(string)) {
            this.ctx.getCurrentPage().addTarget(targetInput.getIdx(), targetInput.getTarget());
        } else {
            this.ctx.getCurrentPage().removeTarget(targetInput.getIdx(), targetInput.getTarget());
        }
    }

    public boolean isAbort() {
        return false;
    }

    public void renderError(OutputField outputField, InputStream inputStream, PrintStream printStream) {
    }
}

