/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.input.TargetSelectInput;
import org.tp23.antinstaller.renderer.text.SelectInputRenderer;

public class TargetSelectInputRenderer
extends SelectInputRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");

    public void renderOutput(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        TargetSelectInput targetSelectInput = (TargetSelectInput)outputField;
        this.printText(targetSelectInput, printStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        printStream.println();
        if (string == null || string.equals("")) {
            string = targetSelectInput.getDefaultValue();
        } else {
            try {
                int n = Integer.parseInt(string.trim());
                string = targetSelectInput.getOptions()[n - 1].value;
            }
            catch (Exception exception) {
                return;
            }
        }
        this.ctx.getCurrentPage().addTarget(targetSelectInput.getIdx(), string);
        targetSelectInput.setInputResult(string);
    }

    private void printText(TargetSelectInput targetSelectInput, PrintStream printStream) throws IOException {
        printStream.println(targetSelectInput.getDisplayText());
        SelectInput.Option[] optionArray = targetSelectInput.getOptions();
        printStream.print("  ");
        printStream.println(res.getString("enterNumber"));
        for (int i = 0; i < optionArray.length; ++i) {
            printStream.print("  ");
            printStream.print(i + 1);
            printStream.print(") ");
            printStream.print(optionArray[i].text);
            if (targetSelectInput.getDefaultValue().equals(optionArray[i].value)) {
                printStream.print(" [");
                printStream.print(res.getString("_default_"));
                printStream.print("]");
            }
            printStream.println();
        }
    }
}

