/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.renderer.PageRenderer;

public abstract class TextPageRenderer
implements PageRenderer {
    public static final int PAGE_BLANK_LINES = 20;
    public static final int PAGE_DECO_WIDTH = 80;
    protected InputStream in;
    protected PrintStream out;
    protected InstallerContext ctx;
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    private static final char[] affimativeChars = TextPageRenderer.parseChars(res.getString("affirmativeChars"));

    public void setContext(InstallerContext installerContext) {
        this.ctx = installerContext;
    }

    public InstallerContext getContext() {
        return this.ctx;
    }

    public void init(InputStream inputStream, PrintStream printStream) {
        this.out = printStream;
        this.in = inputStream;
    }

    public abstract boolean renderPage(Page var1) throws InstallException;

    protected void printHeader(Page page) throws IOException {
        int n;
        for (n = 0; n < 20; ++n) {
            this.out.println();
        }
        for (n = 0; n < 80; ++n) {
            this.out.print('~');
        }
        this.out.println();
        this.out.println("  " + page.getDisplayText());
        for (n = 0; n < 80; ++n) {
            this.out.print('~');
        }
        this.out.println();
        this.out.println();
        this.out.println();
    }

    private static char[] parseChars(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i]) || ',' == cArray[i]) continue;
            cArray2[n++] = cArray[i];
        }
        char[] cArray3 = new char[n];
        System.arraycopy(cArray2, 0, cArray3, 0, n);
        return cArray3;
    }

    protected boolean isTrue(String string) {
        if (string.length() == 0) {
            return true;
        }
        char c = string.charAt(0);
        boolean bl = false;
        for (int i = 0; i < affimativeChars.length; ++i) {
            bl |= Character.toUpperCase(c) == affimativeChars[i];
        }
        return bl;
    }
}

