/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.ProgressPage;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.exe.LoadConfigFilter;

public class ConfigurationLoader
extends LoadConfigFilter {
    public static void main(String[] stringArray) {
        int n = 1;
        try {
            n = ConfigurationLoader.validate(stringArray[0], "antinstall-config.xml");
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
            System.exit(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(n);
        }
    }

    public static int validate(String string, String string2) throws IOException, ConfigurationException {
        int n;
        int n2;
        ConfigurationLoader configurationLoader = new ConfigurationLoader();
        Installer installer = configurationLoader.readConfig(new File(string), string2);
        Page[] pageArray = installer.getPages();
        boolean bl = false;
        for (n2 = 0; n2 < pageArray.length; ++n2) {
            OutputField[] outputFieldArray = pageArray[n2].getOutputField();
            for (n = 0; n < outputFieldArray.length; ++n) {
                if (outputFieldArray[n].validateObject()) continue;
                bl = true;
                System.out.println("Error in page:" + pageArray[n2].getName());
            }
        }
        System.out.println("Finished checking config inputs");
        if (!(pageArray[pageArray.length - 1] instanceof ProgressPage)) {
            bl = true;
            System.out.println("Last Page should be a progress page");
        }
        n2 = 0;
        for (int i = 0; i < pageArray.length; ++i) {
            n2 += pageArray[i].getTargets().size();
        }
        if (n2 == 0) {
            System.out.println("Warning: No Page Targets (not a problem if there are target input types)");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < pageArray.length; ++n) {
            OutputField[] outputFieldArray;
            String string3;
            if (pageArray[n] instanceof SimpleInputPage && (string3 = (outputFieldArray = (OutputField[])pageArray[n]).getIfTarget()) != null && !arrayList.contains(string3)) {
                System.out.println("ifTarget=" + string3);
                System.out.println("ifTarget will never test true, no prior target in page:" + pageArray[n].getName());
                bl = true;
            }
            arrayList.addAll(pageArray[n].getTargets());
            outputFieldArray = pageArray[n].getOutputField();
            for (int i = 0; i < outputFieldArray.length; ++i) {
                if (!(outputFieldArray[i] instanceof TargetInput)) continue;
                TargetInput targetInput = (TargetInput)outputFieldArray[i];
                arrayList.add(targetInput.getTarget());
            }
        }
        System.out.println("Finished checking config");
        if (!bl) {
            return 0;
        }
        return 1;
    }
}

