/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.io.File;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.runtime.TextRunner;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.tp23.antinstaller.runtime.exe.ExecuteRunnerFilter;
import org.tp23.antinstaller.runtime.exe.FilterChain;
import org.tp23.antinstaller.runtime.exe.FilterFactory;
import org.tp23.antinstaller.runtime.exe.FinalizerFilter;
import org.tp23.antinstaller.runtime.exe.ScriptFilterChain;
import org.tp23.antinstaller.selfextract.SelfExtractor;

public class ExecInstall {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    private final InstallerContext ctx = new InstallerContext();
    private FilterChain chain;

    public ExecInstall(FilterChain filterChain) {
        this.chain = filterChain;
    }

    public void exec() {
        ExecuteFilter[] executeFilterArray = null;
        try {
            this.chain.init(this.ctx);
            executeFilterArray = this.chain.getFilters();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        for (int i = 0; i < executeFilterArray.length; ++i) {
            Object object;
            try {
                executeFilterArray[i].exec(this.ctx);
                continue;
            }
            catch (ExecuteRunnerFilter.AbortException abortException) {
                MessageRenderer messageRenderer = this.ctx.getMessageRenderer();
                messageRenderer.printMessage(abortException.getMessage());
                this.ctx.log("Aborted");
                object = (FinalizerFilter)executeFilterArray[executeFilterArray.length - 1];
                ((FinalizerFilter)object).exec(this.ctx);
                System.exit(1);
                continue;
            }
            catch (Exception exception) {
                this.ctx.log("Installation error:" + exception.getMessage() + ":" + exception.getClass().toString());
                boolean bl = true;
                if (this.ctx.getInstaller() != null) {
                    bl = this.ctx.getInstaller().isVerbose();
                }
                if (bl) {
                    this.ctx.log(exception);
                }
                if (this.ctx.getRunner() instanceof TextRunner) {
                    if (bl) {
                        exception.printStackTrace();
                    }
                } else if (bl) {
                    exception.printStackTrace(System.err);
                } else {
                    System.err.println("Installation failed:" + exception.getClass().getName());
                    System.err.println(exception.getMessage());
                }
                if ((object = this.ctx.getMessageRenderer()) != null) {
                    object.printMessage(res.getString("installationFailed") + "\n" + exception.getMessage());
                }
                if (this.ctx.getRunner() != null) {
                    this.ctx.getRunner().fatalError();
                    break;
                }
                System.exit(1);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            FilterChain filterChain = FilterFactory.factory("/org/tp23/antinstaller/runtime/exe/script.fconfig");
            ExecInstall execInstall = new ExecInstall(new ScriptFilterChain());
            Object var3_4 = null;
            if (stringArray.length != 2) {
                ExecInstall.printUsage();
            }
            execInstall.ctx.setUIOverride(stringArray[0]);
            execInstall.setInstallRoot(new File(stringArray[1]));
            execInstall.exec();
        }
        catch (InstallException installException) {
            System.out.println("Cant load filter chain:/org/tp23/antinstaller/runtime/exe/script.fconfig");
            installException.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage java -cp $CLASSPATH org.tp23.antinstaller.ExecInstall [text|swing]? [install root]");
    }

    public void setUIOverride(String string) {
        this.ctx.setUIOverride(string);
    }

    public void setInstallRoot(File file) {
        this.ctx.setFileRoot(file);
    }

    public void setTempRoot(File file) {
        this.addShutdownHook(file);
    }

    private void addShutdownHook(final File file) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (ExecInstall.this.ctx.getInstaller() != null && ExecInstall.this.ctx.getInstaller().isDebug()) {
                    return;
                }
                if (file != null && file.exists() && file.isDirectory()) {
                    SelfExtractor.deleteRecursive(file);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(thread);
    }
}

