/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime;

import java.awt.GraphicsConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.antmod.FeedbackListener;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.renderer.AntOutputRenderer;
import org.tp23.antinstaller.renderer.RendererFactory;
import org.tp23.antinstaller.renderer.swing.PageCompletionListener;
import org.tp23.antinstaller.renderer.swing.SwingInstallerContext;
import org.tp23.antinstaller.renderer.swing.SwingMessageRenderer;
import org.tp23.antinstaller.renderer.swing.SwingPageRenderer;
import org.tp23.antinstaller.renderer.swing.plaf.LookAndFeelFactory;
import org.tp23.antinstaller.runtime.IfPropertyHelper;
import org.tp23.antinstaller.runtime.Logger;
import org.tp23.antinstaller.runtime.Runner;

public class SwingRunner
implements Runner,
PageCompletionListener {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    private List targets = new ArrayList();
    private SwingInstallerContext swingCtx = null;
    private JFrame frame = new JFrame();
    private List pageRenderers;
    private volatile boolean doAnt = false;
    private Thread initialThread;
    private IfPropertyHelper ifHelper;
    private InstallerContext ctx;
    private Logger logger;
    private Installer installer;

    public SwingRunner(InstallerContext installerContext) {
        this.swingCtx = new SwingInstallerContext(installerContext, this.frame);
        SwingMessageRenderer swingMessageRenderer = new SwingMessageRenderer();
        swingMessageRenderer.setOwner(this.frame);
        installerContext.setMessageRenderer(swingMessageRenderer);
        installerContext.setBuildListener(new FeedbackListener(this.swingCtx));
        this.ifHelper = new IfPropertyHelper(installerContext);
        this.logger = installerContext.getLogger();
        this.installer = installerContext.getInstaller();
        this.ctx = installerContext;
    }

    public boolean runInstaller() throws InstallException {
        new LookAndFeelFactory(this.ctx).setLAF();
        try {
            this.frame.setTitle(this.installer.getName());
            this.frame.setDefaultCloseOperation(3);
            this.frame.setSize(SwingPageRenderer.PAGE_WIDTH, SwingPageRenderer.PAGE_HEIGHT);
            this.frame.getRootPane().setDoubleBuffered(true);
            this.setLocation(this.frame);
            this.setIcon(this.frame, this.installer);
            this.preparePages(this.installer.getPages(), this.ctx);
            this.showFirstPage(this.installer.getPages()[0]);
            this.initialThread = Thread.currentThread();
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.doAnt;
        }
        catch (Exception exception) {
            this.logger.log("Fatal exception:" + exception.getMessage());
            if (this.ctx.getInstaller().isVerbose()) {
                this.logger.log(exception);
            }
            this.ctx.getMessageRenderer().printMessage("Fatal exception:" + exception.getMessage());
            throw new InstallException("", exception);
        }
    }

    public void pageBack(Page page) {
        if (page.isAbort()) {
            this.abort();
            return;
        }
        Page[] pageArray = this.installer.getPages();
        for (int i = 0; i < pageArray.length; ++i) {
            block7: {
                if (pageArray[i] != page || i <= 0) continue;
                int n = i - 1;
                boolean bl = true;
                while (!(!bl || this.ifTarget(pageArray[n], pageArray) && this.ifHelper.ifProperty(pageArray[n]))) {
                    bl = true;
                    --n;
                }
                SwingPageRenderer swingPageRenderer = (SwingPageRenderer)this.pageRenderers.get(n);
                this.ctx.setCurrentPage(pageArray[n]);
                try {
                    this.renderNext(swingPageRenderer);
                }
                catch (InstallException installException) {
                    this.logger.log("InstallExcepiton rendering page:" + page.getName());
                    if (this.installer.isVerbose()) {
                        this.logger.log(installException);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.log("ClassNotFoundException rendering page:" + page.getName());
                    if (!this.installer.isVerbose()) break block7;
                    this.logger.log(classNotFoundException);
                }
            }
            return;
        }
    }

    public void pageComplete(Page page) {
        block15: {
            try {
                if (page.isAbort()) {
                    this.abort();
                    return;
                }
                Page[] pageArray = this.installer.getPages();
                for (int i = 0; i < pageArray.length; ++i) {
                    if (pageArray[i] != page) continue;
                    SwingPageRenderer swingPageRenderer = (SwingPageRenderer)this.pageRenderers.get(i);
                    boolean bl = false;
                    try {
                        swingPageRenderer.updateInputFields();
                        bl = swingPageRenderer.validateFields();
                    }
                    catch (ValidationException validationException) {
                        this.logger.log("ValidationException rendering page:" + page.getName());
                        if (this.installer.isVerbose()) {
                            this.logger.log(validationException);
                        }
                        return;
                    }
                    if (!bl) {
                        return;
                    }
                    if (i < pageArray.length - 1) {
                        block14: {
                            int n = i + 1;
                            boolean bl2 = true;
                            while (!(!bl2 || this.ifTarget(pageArray[n], pageArray) && this.ifHelper.ifProperty(pageArray[n]))) {
                                bl2 = true;
                                ++n;
                            }
                            SwingPageRenderer swingPageRenderer2 = (SwingPageRenderer)this.pageRenderers.get(n);
                            this.ctx.setCurrentPage(pageArray[n]);
                            try {
                                this.renderNext(swingPageRenderer2);
                            }
                            catch (InstallException installException) {
                                this.logger.log("InstallException rendering page:" + page.getName());
                                if (this.installer.isVerbose()) {
                                    this.logger.log(installException);
                                }
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                this.logger.log("ClassNotFoundException rendering page:" + page.getName());
                                if (!this.installer.isVerbose()) break block14;
                                this.logger.log(classNotFoundException);
                            }
                        }
                        return;
                    }
                    if (i != pageArray.length - 1) continue;
                    swingPageRenderer.getBackButton().setEnabled(false);
                    swingPageRenderer.getNextButton().setEnabled(false);
                    swingPageRenderer.getFinishButton().setEnabled(false);
                    this.doAnt = true;
                    this.initialThread.interrupt();
                    return;
                }
            }
            catch (Throwable throwable) {
                this.ctx.log("Throwable during page completion:" + throwable.getMessage());
                if (!this.ctx.getInstaller().isVerbose()) break block15;
                this.ctx.log(throwable);
            }
        }
    }

    private void showFirstPage(Page page) throws Exception {
        this.ctx.setCurrentPage(page);
        this.renderNext((SwingPageRenderer)this.pageRenderers.get(0));
    }

    private void preparePages(Page[] pageArray, InstallerContext installerContext) throws Exception {
        this.pageRenderers = new ArrayList();
        for (int i = 0; i < pageArray.length; ++i) {
            SwingPageRenderer swingPageRenderer = RendererFactory.getSwingPageRenderer(pageArray[i]);
            if (i == 0) {
                swingPageRenderer.getBackButton().setEnabled(false);
            }
            swingPageRenderer.setContext(this.swingCtx);
            swingPageRenderer.setPageCompletionListener(this);
            swingPageRenderer.setPage(pageArray[i]);
            swingPageRenderer.instanceInit();
            this.pageRenderers.add(swingPageRenderer);
            if (!(swingPageRenderer instanceof AntOutputRenderer)) continue;
            installerContext.setAntOutputRenderer((AntOutputRenderer)((Object)swingPageRenderer));
        }
    }

    protected void renderNext(SwingPageRenderer swingPageRenderer) throws ClassNotFoundException, InstallException {
        swingPageRenderer.updateDefaultValues();
        this.frame.getContentPane().removeAll();
        this.frame.getContentPane().add(swingPageRenderer);
        this.frame.getContentPane().repaint();
        this.frame.show();
        if (swingPageRenderer.getNextButton().isEnabled()) {
            swingPageRenderer.getNextButton().requestFocus();
        } else if (swingPageRenderer.getFinishButton().isEnabled()) {
            swingPageRenderer.getFinishButton().requestFocus();
        }
    }

    private void setLocation(JFrame jFrame) {
        GraphicsConfiguration graphicsConfiguration = jFrame.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getCenterX() - SwingPageRenderer.PAGE_WIDTH / 2;
        int n2 = (int)graphicsConfiguration.getBounds().getCenterY() - SwingPageRenderer.PAGE_HEIGHT / 2;
        jFrame.setLocation(n, n2);
        jFrame.setResizable(false);
    }

    private void setIcon(JFrame jFrame, Installer installer) {
        block4: {
            String string = installer.getWindowIcon();
            try {
                if (string == null) {
                    return;
                }
                InputStream inputStream = this.getClass().getResourceAsStream(string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[256];
                int n = 0;
                n = inputStream.read(byArray);
                while (n != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                ImageIcon imageIcon = new ImageIcon(byteArrayOutputStream.toByteArray());
                jFrame.setIconImage(imageIcon.getImage());
            }
            catch (Exception exception) {
                this.logger.log("Can not load icon resource:" + string);
                if (!installer.isVerbose()) break block4;
                this.logger.log(exception);
            }
        }
    }

    public void antFinished() {
        SwingPageRenderer swingPageRenderer = (SwingPageRenderer)this.pageRenderers.get(this.pageRenderers.size() - 1);
        swingPageRenderer.getBackButton().setEnabled(false);
        swingPageRenderer.getNextButton().setEnabled(false);
        swingPageRenderer.getCancelButton().setEnabled(false);
        swingPageRenderer.getFinishButton().setText(res.getString("exit"));
        swingPageRenderer.getFinishButton().setEnabled(true);
        swingPageRenderer.getFinishButton().requestFocus();
        swingPageRenderer.getTitleLabel().setText(res.getString("complete"));
        this.ctx.getAntOutputRenderer().getErr().flush();
        this.ctx.getAntOutputRenderer().getOut().flush();
        this.ctx.getMessageRenderer().printMessage(res.getString("finished"));
    }

    public void fatalError() {
        SwingPageRenderer swingPageRenderer = (SwingPageRenderer)this.pageRenderers.get(this.pageRenderers.size() - 1);
        swingPageRenderer.getBackButton().setEnabled(false);
        swingPageRenderer.getNextButton().setEnabled(false);
        swingPageRenderer.getCancelButton().setEnabled(false);
        swingPageRenderer.getFinishButton().setText(res.getString("exit"));
        swingPageRenderer.getFinishButton().setEnabled(true);
        swingPageRenderer.getFinishButton().requestFocus();
        swingPageRenderer.getTitleLabel().setText(res.getString("failed"));
    }

    public String toString() {
        return "SwingRunner";
    }

    private void abort() {
        this.doAnt = false;
        this.initialThread.interrupt();
    }

    private boolean ifTarget(Page page, Page[] pageArray) {
        SimpleInputPage simpleInputPage;
        String string;
        if (page instanceof SimpleInputPage && (string = (simpleInputPage = (SimpleInputPage)page).getIfTarget()) != null) {
            boolean bl = false;
            for (int i = 0; i < pageArray.length; ++i) {
                bl |= pageArray[i].isTarget(string);
            }
            return bl;
        }
        return true;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public List getPageRenderers() {
        return this.pageRenderers;
    }
}

