/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.antmod.Launcher;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;

public class AntLauncherFilter
implements ExecuteFilter {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");

    public void exec(InstallerContext installerContext) throws InstallException {
        if (installerContext.getInstaller().isVerbose()) {
            installerContext.log("Starting Ant Launcher");
        }
        try {
            MessageRenderer messageRenderer = installerContext.getMessageRenderer();
            Vector vector = installerContext.getInstaller().getTargets();
            Object[] objectArray = new String[vector.size() + 4];
            vector.toArray(objectArray);
            if (installerContext.getInstaller().isVerbose()) {
                installerContext.log("Running targets:" + this.printArray(objectArray));
            }
            System.out.println("Targets:" + this.printArray(objectArray));
            objectArray[objectArray.length - 2] = "-lib";
            objectArray[objectArray.length - 1] = "antlib";
            objectArray[objectArray.length - 4] = "-buildfile";
            objectArray[objectArray.length - 3] = installerContext.getFileRoot().getAbsolutePath() + System.getProperty("file.separator") + "build.xml";
            System.setOut(installerContext.getAntOutputRenderer().getOut());
            System.setErr(installerContext.getAntOutputRenderer().getErr());
            Map map = installerContext.getInstaller().getResultContainer().getAllProperties();
            Launcher launcher = new Launcher(map);
            int n = launcher.run((String[])objectArray, installerContext);
            if (n != 0) {
                messageRenderer.printMessage(res.getString("Failed"));
            } else {
                installerContext.setInstallSucceded(true);
            }
            installerContext.log("Ant finished");
        }
        catch (Throwable throwable) {
            throw new InstallException("Error running the install");
        }
        finally {
            installerContext.getRunner().antFinished();
        }
    }

    private String printArray(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length - 4; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }
}

