/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.launch.Locator;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.antmod.ProjectHelper3;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.tp23.antinstaller.selfextract.SelfExtractor;

public class AntProjectFilter
implements ExecuteFilter {
    private static String antVersion = null;
    public static final String ANTHOME_PROPERTY = "ant.home";
    public static final String USER_LIBDIR = ".ant/lib";
    static /* synthetic */ Class class$org$tp23$antinstaller$runtime$exe$AntProjectFilter;

    public void exec(InstallerContext installerContext) throws InstallException {
        if (installerContext.getInstaller().isVerbose()) {
            installerContext.log("Starting Ant Project");
        }
        try {
            Serializable serializable;
            Project project = new Project();
            AntProjectFilter.appendClassPath();
            AntProjectFilter.setAntHome(installerContext);
            project.setCoreLoader(this.getClass().getClassLoader());
            DefaultLogger defaultLogger = new DefaultLogger();
            defaultLogger.setOutputPrintStream(installerContext.getAntOutputRenderer().getOut());
            defaultLogger.setErrorPrintStream(installerContext.getAntOutputRenderer().getErr());
            defaultLogger.setMessageOutputLevel(2);
            BuildListener buildListener = installerContext.getBuildListener();
            if (buildListener != null) {
                project.addBuildListener(buildListener);
            }
            project.addBuildListener((BuildListener)defaultLogger);
            project.setInputHandler((InputHandler)new DefaultInputHandler());
            project.fireBuildStarted();
            project.init();
            project.setUserProperty("ant.version", AntProjectFilter.getAntVersion());
            Map map = installerContext.getInstaller().getResultContainer().getAllProperties();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                project.setUserProperty(string, string2);
            }
            try {
                Diagnostics.validateVersion();
            }
            catch (Throwable throwable) {
                System.err.println("Version error:" + throwable.getClass() + "," + throwable.getMessage());
                installerContext.getRunner().antFinished();
                return;
            }
            ProjectHelper3 projectHelper3 = new ProjectHelper3();
            project.addReference("ant.projectHelper", (Object)projectHelper3);
            File file = new File(installerContext.getFileRoot(), "build.xml");
            if (file.exists()) {
                projectHelper3.parse(project, file);
                project.setUserProperty("ant.file", file.getAbsolutePath());
            } else {
                serializable = this.getClass().getResource("/build.xml");
                projectHelper3.parse(project, serializable);
                project.setUserProperty("ant.file", ((URL)serializable).toExternalForm());
            }
            serializable = SelfExtractor.getEnclosingJar(this);
            project.setUserProperty("antinstaller.jar", ((File)serializable).getAbsolutePath());
            System.out.println("antinstaller.jar" + ((File)serializable).getAbsolutePath());
            project.setBaseDir(installerContext.getFileRoot());
            project.executeTargets(installerContext.getInstaller().getTargets());
            installerContext.setInstallSucceded(true);
            installerContext.log("Ant finished");
        }
        catch (Throwable throwable) {
            throw new InstallException("Error running the install", throwable);
        }
        finally {
            installerContext.getRunner().antFinished();
        }
    }

    public static synchronized String getAntVersion() throws BuildException {
        if (antVersion == null) {
            try {
                Properties properties = new Properties();
                InputStream inputStream = (class$org$tp23$antinstaller$runtime$exe$AntProjectFilter == null ? (class$org$tp23$antinstaller$runtime$exe$AntProjectFilter = AntProjectFilter.class$("org.tp23.antinstaller.runtime.exe.AntProjectFilter")) : class$org$tp23$antinstaller$runtime$exe$AntProjectFilter).getResourceAsStream("/org/apache/tools/ant/version.txt");
                properties.load(inputStream);
                inputStream.close();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Apache Ant version ");
                stringBuffer.append(properties.getProperty("VERSION"));
                stringBuffer.append(" compiled on ");
                stringBuffer.append(properties.getProperty("DATE"));
                antVersion = stringBuffer.toString();
            }
            catch (IOException iOException) {
                throw new BuildException("Could not load the version information:" + iOException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                throw new BuildException("Could not load the version information.");
            }
        }
        return antVersion;
    }

    private static void appendClassPath() {
        try {
            StringBuffer stringBuffer = new StringBuffer(System.getProperty("java.class.path"));
            if (stringBuffer.charAt(stringBuffer.length() - 1) == File.pathSeparatorChar) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            URL[] uRLArray = AntProjectFilter.getLibPaths();
            for (int i = 0; i < uRLArray.length; ++i) {
                stringBuffer.append(File.pathSeparatorChar);
                stringBuffer.append(Locator.fromURI((String)uRLArray[i].toString()));
            }
            System.setProperty("java.class.path", stringBuffer.toString());
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Invalid Jar path");
        }
    }

    private static void setAntHome(InstallerContext installerContext) {
        String string = System.getProperty(ANTHOME_PROPERTY);
        if (string == null) {
            System.setProperty(ANTHOME_PROPERTY, installerContext.getFileRoot().getAbsolutePath());
        }
    }

    private static URL[] getLibPaths() throws MalformedURLException {
        ArrayList arrayList = new ArrayList();
        URL[] uRLArray = Locator.getLocationURLs((File)new File("antlib"));
        URL[] uRLArray2 = Locator.getLocationURLs((File)new File(USER_LIBDIR));
        File file = Locator.getToolsJar();
        int n = uRLArray.length + uRLArray2.length + (file != null ? 1 : 0);
        URL[] uRLArray3 = new URL[n];
        int n2 = 0;
        if (file != null) {
            uRLArray3[n2++] = file.toURL();
        }
        if (uRLArray.length != 0) {
            System.arraycopy(uRLArray, 0, uRLArray3, n2, uRLArray.length);
            n2 += uRLArray.length;
        }
        if (uRLArray2.length != 0) {
            System.arraycopy(uRLArray2, 0, uRLArray3, n2, uRLArray2.length);
        }
        return uRLArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

