/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.Installer;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.AppRootInput;
import org.tp23.antinstaller.input.CheckboxInput;
import org.tp23.antinstaller.input.CommentOutput;
import org.tp23.antinstaller.input.DateInput;
import org.tp23.antinstaller.input.DirectoryInput;
import org.tp23.antinstaller.input.ExtValidatedTextInput;
import org.tp23.antinstaller.input.FileInput;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.LargeSelectInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.PasswordTextInput;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.input.TargetInput;
import org.tp23.antinstaller.input.TargetSelectInput;
import org.tp23.antinstaller.input.UnvalidatedTextInput;
import org.tp23.antinstaller.input.ValidatedTextInput;
import org.tp23.antinstaller.page.LicensePage;
import org.tp23.antinstaller.page.Page;
import org.tp23.antinstaller.page.ProgressPage;
import org.tp23.antinstaller.page.SimpleInputPage;
import org.tp23.antinstaller.page.SplashPage;
import org.tp23.antinstaller.runtime.ConfigurationException;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LoadConfigFilter
implements ExecuteFilter {
    public static final String INSTALLER_CONFIG_FILE = "antinstall-config.xml";
    protected Installer installerConfig = new Installer();
    protected InstallerContext ctx;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;

    public void exec(InstallerContext installerContext) throws InstallException {
        this.ctx = installerContext;
        try {
            this.installerConfig = this.readConfig(installerContext.getFileRoot(), INSTALLER_CONFIG_FILE);
            installerContext.setInstaller(this.installerConfig);
            installerContext.log("Config loaded");
        }
        catch (IOException iOException) {
            throw new InstallException("Not able to load and read the AntInstaller config", iOException);
        }
        catch (ConfigurationException configurationException) {
            throw new InstallException("Not able to load and read the AntInstaller config", configurationException);
        }
    }

    public Installer readConfig(File file, String string) throws IOException, ConfigurationException {
        this.installerConfig.getResultContainer().setInstallRoot(file);
        InputSource inputSource = new InputSource(new FileInputStream(new File(file, string)));
        this.readConfig(inputSource);
        return this.installerConfig;
    }

    protected Installer readConfig(File file, InputStream inputStream) throws IOException, ConfigurationException {
        this.installerConfig.getResultContainer().setInstallRoot(file);
        InputSource inputSource = new InputSource(inputStream);
        this.readConfig(inputSource);
        return this.installerConfig;
    }

    protected Installer readConfig(InputSource inputSource) throws IOException, ConfigurationException {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) {
                    if (string.equals("-//tp23 //DTD Ant Installer Config//EN") && string2.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.2.dtd")) {
                        InputSource inputSource = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.2.dtd"));
                        return inputSource;
                    }
                    if (string.equals("-//tp23 //DTD Ant Installer Config//EN") && string2.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.3.dtd")) {
                        InputSource inputSource = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.3.dtd"));
                        return inputSource;
                    }
                    if (string.equals("-//tp23 //DTD Ant Installer Config//EN") && string2.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.4.dtd")) {
                        InputSource inputSource = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.4.dtd"));
                        return inputSource;
                    }
                    if (string.equals("-//tp23 //DTD Ant Installer Config//EN") && string2.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.5.dtd")) {
                        InputSource inputSource = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.5.dtd"));
                        return inputSource;
                    }
                    if (string.equals("-//tp23 //DTD Ant Installer Config//EN") && string2.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.6.dtd")) {
                        InputSource inputSource = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.6.dtd"));
                        return inputSource;
                    }
                    if (string.equals("-//tp23 //DTD Ant Installer Config//EN") && string2.equals("http://antinstaller.sf.net/dtd/antinstall-config-0.7.dtd")) {
                        InputSource inputSource = new InputSource(this.getClass().getResourceAsStream("/org/tp23/antinstaller/antinstall-config-0.7.dtd"));
                        return inputSource;
                    }
                    return null;
                }
            });
            document = documentBuilder.parse(inputSource);
            Element element = document.getDocumentElement();
            element.normalize();
            this.setProperties(this.installerConfig, element.getAttributes());
            NodeList nodeList = element.getElementsByTagName("page");
            this.getPages(this.installerConfig, nodeList);
        }
        catch (Exception exception) {
            throw new IOException("DomFactory error: caused by:" + exception.getClass() + ":" + exception.getMessage());
        }
        return this.installerConfig;
    }

    private void getPages(Installer installer, NodeList nodeList) throws ConfigurationException {
        ArrayList<Page> arrayList = new ArrayList<Page>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Page page = this.getPageType(element.getAttribute("type"));
            this.setProperties(page, element.getAttributes());
            arrayList.add(page);
            this.getOutputFields(page, element);
        }
        Page[] pageArray = new Page[arrayList.size()];
        arrayList.toArray(pageArray);
        installer.setPages(pageArray);
    }

    private void getOutputFields(Page page, Element element) throws ConfigurationException {
        NodeList nodeList = element.getChildNodes();
        ArrayList<OutputField> arrayList = new ArrayList<OutputField>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            OutputField outputField;
            if (!(nodeList.item(i) instanceof Element) || (outputField = this.getOutputFieldType((element2 = (Element)nodeList.item(i)).getNodeName(), element2)) == null) continue;
            this.setProperties(outputField, element2.getAttributes());
            arrayList.add(outputField);
            if (!(outputField instanceof InputField)) continue;
            InputField inputField = (InputField)outputField;
            inputField.setResultContainer(this.installerConfig.getResultContainer());
        }
        OutputField[] outputFieldArray = new OutputField[arrayList.size()];
        arrayList.toArray(outputFieldArray);
        page.setOutputField(outputFieldArray);
    }

    private Page getPageType(String string) throws ConfigurationException {
        if (string.equalsIgnoreCase("license")) {
            return new LicensePage();
        }
        if (string.equalsIgnoreCase("input")) {
            return new SimpleInputPage();
        }
        if (string.equalsIgnoreCase("progress")) {
            return new ProgressPage();
        }
        if (string.equalsIgnoreCase("splash")) {
            return new SplashPage();
        }
        throw new ConfigurationException("Unknown Page type:" + string);
    }

    private OutputField getOutputFieldType(String string, Element element) throws ConfigurationException {
        if (string.equalsIgnoreCase("text")) {
            return new UnvalidatedTextInput();
        }
        if (string.equalsIgnoreCase("directory")) {
            return new DirectoryInput();
        }
        if (string.equalsIgnoreCase("target")) {
            return new TargetInput();
        }
        if (string.equalsIgnoreCase("file")) {
            return new FileInput();
        }
        if (string.equalsIgnoreCase("comment")) {
            return new CommentOutput();
        }
        if (string.equalsIgnoreCase("checkbox")) {
            return new CheckboxInput();
        }
        if (string.equalsIgnoreCase("validated")) {
            return new ValidatedTextInput();
        }
        if (string.equalsIgnoreCase("ext-validated")) {
            return new ExtValidatedTextInput();
        }
        if (string.equalsIgnoreCase("password")) {
            return new PasswordTextInput();
        }
        if (string.equalsIgnoreCase("date")) {
            return new DateInput();
        }
        if (string.equalsIgnoreCase("app-root")) {
            return new AppRootInput();
        }
        if (string.equalsIgnoreCase("select")) {
            SelectInput selectInput = new SelectInput();
            NodeList nodeList = element.getElementsByTagName("option");
            ArrayList<SelectInput.Option> arrayList = new ArrayList<SelectInput.Option>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                SelectInput.Option option = selectInput.getNewOption();
                option.text = element2.getAttribute("text");
                option.value = element2.getAttribute("value");
                arrayList.add(option);
            }
            SelectInput.Option[] optionArray = new SelectInput.Option[arrayList.size()];
            arrayList.toArray(optionArray);
            selectInput.setOptions(optionArray);
            return selectInput;
        }
        if (string.equalsIgnoreCase("target-select")) {
            TargetSelectInput targetSelectInput = new TargetSelectInput();
            NodeList nodeList = element.getElementsByTagName("option");
            ArrayList<SelectInput.Option> arrayList = new ArrayList<SelectInput.Option>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                SelectInput.Option option = targetSelectInput.getNewOption();
                option.text = element3.getAttribute("text");
                option.value = element3.getAttribute("value");
                arrayList.add(option);
            }
            SelectInput.Option[] optionArray = new SelectInput.Option[arrayList.size()];
            arrayList.toArray(optionArray);
            targetSelectInput.setOptions(optionArray);
            return targetSelectInput;
        }
        if (string.equalsIgnoreCase("large-select")) {
            LargeSelectInput largeSelectInput = new LargeSelectInput();
            NodeList nodeList = element.getElementsByTagName("option");
            ArrayList<LargeSelectInput.Option> arrayList = new ArrayList<LargeSelectInput.Option>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element4 = (Element)nodeList.item(i);
                LargeSelectInput.Option option = largeSelectInput.getNewOption();
                option.text = element4.getAttribute("text");
                option.value = element4.getAttribute("value");
                arrayList.add(option);
            }
            LargeSelectInput.Option[] optionArray = new LargeSelectInput.Option[arrayList.size()];
            arrayList.toArray(optionArray);
            largeSelectInput.setOptions(optionArray);
            return largeSelectInput;
        }
        System.out.println("Unrecognised Input Element:" + string);
        return null;
    }

    private void setProperties(Object object, NamedNodeMap namedNodeMap) {
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = namedNodeMap.item(i);
            String string = node.getNodeName();
            String string2 = node.getNodeValue();
            String string3 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
            Method[] methodArray = object.getClass().getMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                if (!methodArray[j].getName().equals(string3)) continue;
                try {
                    Object[] objectArray;
                    Class<?>[] classArray = methodArray[j].getParameterTypes();
                    if (classArray[0].equals(class$java$lang$Boolean == null ? LoadConfigFilter.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                        objectArray = new Boolean[1];
                        objectArray[0] = string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") ? new Boolean(true) : new Boolean(false);
                    } else {
                        objectArray = classArray[0].equals(class$java$lang$Integer == null ? LoadConfigFilter.class$("java.lang.Integer") : class$java$lang$Integer) ? new Integer[]{new Integer(string2)} : new String[]{string2};
                    }
                    methodArray[j].invoke(object, objectArray);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

