/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import org.tp23.antinstaller.DefaultPropertiesFileRenderer;
import org.tp23.antinstaller.ExplicitPropertiesFileRenderer;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.PropertiesFileRenderer;
import org.tp23.antinstaller.input.ResultContainer;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;

public class PropertyPrinterFilter
implements ExecuteFilter {
    public void exec(InstallerContext installerContext) throws InstallException {
        this.printProperties(installerContext);
        ResultContainer resultContainer = installerContext.getInstaller().getResultContainer();
        resultContainer.setProperty("basedir", installerContext.getFileRoot().getAbsolutePath());
        if (installerContext.getInstaller().isVerbose()) {
            installerContext.log("Properties printed:ant.install.properties");
        }
    }

    private void printProperties(InstallerContext installerContext) {
        PropertiesFileRenderer propertiesFileRenderer = installerContext.getInstaller().isVerbose() ? new ExplicitPropertiesFileRenderer() : new DefaultPropertiesFileRenderer();
        propertiesFileRenderer.renderProperties(installerContext.getInstaller(), installerContext.getFileRoot());
    }
}

