/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.gui.widget;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;
import org.tp23.gui.widget.CloseListener;
import org.tp23.gui.widget.LocateableImageIcon;

public class ClosableTabbedPane
extends JTabbedPane {
    private static byte[] data;
    private static final int IMAGE_SIZE = 309;
    private CloseListener closeListener;
    private LocateableImageIcon closeIcon;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.tp23.gui.widget.ClosableTabbedPane");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream in = clazz.getResourceAsStream("/resources/close.png");
            data = new byte[309];
            int i = 0;
            while (i < data.length) {
                ClosableTabbedPane.data[i] = (byte)in.read();
                ++i;
            }
        }
        catch (IOException e) {
            data = null;
            e.printStackTrace();
        }
    }

    public ClosableTabbedPane() {
        this(1);
    }

    public ClosableTabbedPane(int tabPlacement) {
        this(1, 0);
    }

    public ClosableTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        TabbedPaneUI tui = this.getUI();
        this.closeIcon = new LocateableImageIcon(data);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                Point p = me.getPoint();
                if (ClosableTabbedPane.this.getCloseIconbounds().contains(p)) {
                    ClosableTabbedPane.this.fireCloseListener(ClosableTabbedPane.this.getSelectedComponent());
                }
            }
        });
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.getComponentCount() > 0) {
            Rectangle bounds = this.getCloseIconbounds();
            if (g.getClipBounds().intersects(bounds)) {
                this.closeIcon.paintIcon(this, g, bounds.x, bounds.y);
            }
        }
    }

    public void setCloseListener(CloseListener closeListener) {
        this.closeListener = closeListener;
    }

    private void fireCloseListener(Component c) {
        if (this.closeListener != null) {
            ActionEvent ae = new ActionEvent(c, 1001, "Tabbed Closed");
            this.closeListener.closePerformed(ae);
        }
    }

    private Rectangle getCloseIconbounds() {
        int x = 0;
        int y = 0;
        TabbedPaneUI tui = this.getUI();
        if (this.getTabPlacement() == 1) {
            x = this.getBounds().x + this.getBounds().width - this.closeIcon.getIconWidth() - 2;
            y = tui.getTabBounds((JTabbedPane)this, (int)0).y + 2;
        } else if (this.getTabPlacement() == 3) {
            x = this.getBounds().x + this.getBounds().width - this.closeIcon.getIconWidth() - 2;
            y = tui.getTabBounds((JTabbedPane)this, (int)0).y + 2;
        }
        Rectangle bounds = new Rectangle(x, y, this.closeIcon.getIconWidth(), this.closeIcon.getIconHeight());
        return bounds;
    }
}

