/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.gui.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.tp23.gui.widget.TextBufferPanel;

public class ExtendableStatusPanel
extends JPanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JTextField statusField = new JTextField();
    private JToggleButton showBufferToggleButton = new JToggleButton();
    private TextBufferPanel textBuffer;
    private JScrollPane textBufferScroller;
    private final Dimension preferredTextSize = new Dimension(200, 20);
    private final Dimension preferredButtonSize = new Dimension(75, 20);
    private final Dimension preferredExpandedSize = new Dimension(200, 80);

    public ExtendableStatusPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ExtendableStatusPanel(String initialText) {
        this();
        this.setText(initialText);
    }

    public String getText() {
        return this.statusField.getText();
    }

    public void setText(String text) {
        this.statusField.setText(text);
        this.textBuffer.append(text);
    }

    private void jbInit() throws Exception {
        this.textBuffer = new TextBufferPanel(15);
        this.textBufferScroller = new JScrollPane();
        this.textBufferScroller.getViewport().add(this.textBuffer);
        this.setLayout(this.borderLayout1);
        this.textBufferScroller.setPreferredSize(new Dimension(200, this.preferredExpandedSize.height - this.preferredButtonSize.height));
        this.textBuffer.setJScrollPane(this.textBufferScroller);
        this.statusField.setSelectionStart(0);
        this.statusField.setText("");
        this.statusField.setMaximumSize(this.preferredTextSize);
        this.statusField.setMinimumSize(this.preferredTextSize);
        this.statusField.setPreferredSize(this.preferredTextSize);
        this.showBufferToggleButton.setMaximumSize(this.preferredButtonSize);
        this.showBufferToggleButton.setMinimumSize(this.preferredButtonSize);
        this.showBufferToggleButton.setPreferredSize(this.preferredButtonSize);
        this.showBufferToggleButton.setText("More");
        this.add((Component)this.statusField, "Center");
        this.add((Component)this.showBufferToggleButton, "East");
        this.showBufferToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JRootPane topLevel = ExtendableStatusPanel.this.getRootPane();
                if (ExtendableStatusPanel.this.showBufferToggleButton.isSelected()) {
                    ExtendableStatusPanel.this.add((Component)ExtendableStatusPanel.this.textBufferScroller, "North");
                    ExtendableStatusPanel.this.setPreferredSize(ExtendableStatusPanel.this.preferredExpandedSize);
                    ExtendableStatusPanel.this.setMaximumSize(ExtendableStatusPanel.this.preferredExpandedSize);
                    ExtendableStatusPanel.this.doLayout();
                    topLevel.validate();
                    ExtendableStatusPanel.this.textBuffer.scrollToEnd();
                } else {
                    ExtendableStatusPanel.this.remove(ExtendableStatusPanel.this.textBufferScroller);
                    ExtendableStatusPanel.this.setPreferredSize(ExtendableStatusPanel.this.preferredTextSize);
                    ExtendableStatusPanel.this.setMaximumSize(ExtendableStatusPanel.this.preferredTextSize);
                    ExtendableStatusPanel.this.doLayout();
                    ExtendableStatusPanel.this.textBuffer.scrollToEnd();
                    topLevel.validate();
                    ExtendableStatusPanel.this.repaint();
                }
            }
        });
    }

    public static void main(String[] args) {
        try {
            JFrame test = new JFrame();
            test.getContentPane().setLayout(new BorderLayout());
            test.getContentPane().add((Component)new JPanel(), "Center");
            test.getContentPane().add((Component)new ExtendableStatusPanel(), "South");
            test.pack();
            test.show();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
    }
}

